/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import java.io.ByteArrayOutputStream;

public class Base64Codec {
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    private static final byte[] decodingTable = new byte[128];
    private static byte fillbyte = (byte)61;

    static {
        int n = 0;
        while (n < decodingTable.length) {
            Base64Codec.decodingTable[n] = 0;
            ++n;
        }
        n = 0;
        while (n < encodingTable.length) {
            Base64Codec.decodingTable[Base64Codec.encodingTable[n]] = (byte)n;
            ++n;
        }
    }

    public static String encode(String string) {
        return new String(Base64Codec.encode(string.getBytes()));
    }

    public static byte[] encode(byte[] byArray) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            int n2 = n + 1 < byArray.length ? byArray[n + 1] : -1;
            int n3 = n + 2 < byArray.length ? byArray[n + 2] : -1;
            int n4 = by >>> 2 & 0x3F;
            int n5 = by << 4 & 0x3F;
            int n6 = -1;
            int n7 = -1;
            if (n2 >= 0) {
                n5 |= n2 >>> 4 & 0x3F;
                n6 = n2 << 2 & 0x3F;
            }
            if (n3 >= 0) {
                n6 |= n3 >>> 6 & 0x3F;
                n7 = n3 & 0x3F;
            }
            byteArrayOutputStream.write(encodingTable[n4]);
            byteArrayOutputStream.write(encodingTable[n5]);
            byteArrayOutputStream.write(n6 >= 0 ? encodingTable[n6] : fillbyte);
            byteArrayOutputStream.write(n7 >= 0 ? encodingTable[n7] : fillbyte);
            n += 3;
        }
        return byteArrayOutputStream.toByteArray();
    }

    public static String decode(String string) {
        return new String(Base64Codec.decode(string.getBytes()));
    }

    public static byte[] decode(byte[] byArray) {
        int n = byArray.length;
        while (byArray[n - 1] == fillbyte && n > 0) {
            --n;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        int n2 = 0;
        while (n2 < n) {
            byte by = decodingTable[byArray[n2]];
            int n3 = n2 + 1 < n ? decodingTable[byArray[n2 + 1]] : -1;
            int n4 = n2 + 2 < n ? decodingTable[byArray[n2 + 2]] : -1;
            int n5 = n2 + 3 < n ? decodingTable[byArray[n2 + 3]] : -1;
            byte by2 = (byte)(by << 2 & 0xFF);
            int n6 = -1;
            int n7 = -1;
            if (n3 >= 0) {
                by2 = (byte)(by2 | n3 >>> 4 & 0xFF);
                n6 = (byte)(n3 << 4 & 0xFF);
            }
            if (n4 >= 0) {
                n6 = (byte)(n6 | (byte)(n4 >>> 2 & 0xFF));
                n7 = (byte)(n4 << 6 & 0xFF);
            }
            if (n5 >= 0) {
                n7 = (byte)(n7 | (byte)(n5 & 0xFF));
            }
            byteArrayOutputStream.write(by2);
            if (n3 >= 0 && n6 > 0) {
                byteArrayOutputStream.write(n6);
            }
            if (n4 >= 0 && n7 > 0) {
                byteArrayOutputStream.write(n7);
            }
            n2 += 4;
        }
        return byteArrayOutputStream.toByteArray();
    }
}

