/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.security;

import eu.geclipse.core.IProblem;
import eu.geclipse.core.IProblemProvider;
import eu.geclipse.core.ProblemRegistry;
import org.ietf.jgss.GSSException;

public class GridGSSProblems
implements IProblemProvider {
    public static final int BAD_BINDINGS_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_MECH_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_MIC_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_NAME_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_NAMETYPE_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_QOP_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int BAD_STATUS_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int CONTEXT_EXPIRED_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int CREDENTIALS_EXPIRED_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int DEFECTIVE_CREDENTIAL_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int DEFECTIVE_TOKEN_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int DUPLICATE_ELEMENT_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int DUPLICATE_TOKEN_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int FAILURE_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int GAP_TOKEN_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int NAME_NOT_MN_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int NO_CONTEXT_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int NO_CRED_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int OLD_TOKEN_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int UNAUTHORIZED_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int UNAVAILABLE_GSS_PROBLEM = ProblemRegistry.uniqueID();
    public static final int UNSEQ_TOKEN_GSS_PROBLEM = ProblemRegistry.uniqueID();

    public IProblem getProblem(int n, Throwable throwable) {
        IProblem iProblem = null;
        if (throwable instanceof GSSException) {
            iProblem = this.getProblem(n, (GSSException)throwable);
        }
        return iProblem;
    }

    public static int getProblemID(GSSException gSSException) {
        int n = -1;
        int n2 = gSSException.getMajor();
        switch (n2) {
            case 1: {
                n = BAD_BINDINGS_GSS_PROBLEM;
                break;
            }
            case 2: {
                n = BAD_MECH_GSS_PROBLEM;
                break;
            }
            case 6: {
                n = BAD_MIC_GSS_PROBLEM;
                break;
            }
            case 3: {
                n = BAD_NAME_GSS_PROBLEM;
                break;
            }
            case 4: {
                n = BAD_NAMETYPE_GSS_PROBLEM;
                break;
            }
            case 14: {
                n = BAD_QOP_GSS_PROBLEM;
                break;
            }
            case 5: {
                n = BAD_STATUS_GSS_PROBLEM;
                break;
            }
            case 7: {
                n = CONTEXT_EXPIRED_GSS_PROBLEM;
                break;
            }
            case 8: {
                n = CREDENTIALS_EXPIRED_GSS_PROBLEM;
                break;
            }
            case 9: {
                n = DEFECTIVE_CREDENTIAL_GSS_PROBLEM;
                break;
            }
            case 10: {
                n = DEFECTIVE_TOKEN_GSS_PROBLEM;
                break;
            }
            case 17: {
                n = DUPLICATE_ELEMENT_GSS_PROBLEM;
                break;
            }
            case 19: {
                n = DUPLICATE_TOKEN_GSS_PROBLEM;
                break;
            }
            case 11: {
                n = FAILURE_GSS_PROBLEM;
                break;
            }
            case 22: {
                n = GAP_TOKEN_GSS_PROBLEM;
                break;
            }
            case 18: {
                n = NAME_NOT_MN_GSS_PROBLEM;
                break;
            }
            case 12: {
                n = NO_CONTEXT_GSS_PROBLEM;
                break;
            }
            case 13: {
                n = NO_CRED_GSS_PROBLEM;
                break;
            }
            case 20: {
                n = OLD_TOKEN_GSS_PROBLEM;
                break;
            }
            case 15: {
                n = UNAUTHORIZED_GSS_PROBLEM;
                break;
            }
            case 16: {
                n = UNAVAILABLE_GSS_PROBLEM;
                break;
            }
            case 21: {
                n = UNSEQ_TOKEN_GSS_PROBLEM;
            }
        }
        return n;
    }

    private IProblem getProblem(int n, GSSException gSSException) {
        String string = gSSException.getMajorString();
        String string2 = gSSException.getMinorString();
        String string3 = String.valueOf(string) + " (" + string2 + ")";
        int[] nArray = this.getSolutions(n);
        IProblem iProblem = ProblemRegistry.createProblem(n, string3, gSSException, nArray, "eu.geclipse.core");
        return iProblem;
    }

    int[] getSolutions(int n) {
        int[] nArray = null;
        return nArray;
    }
}

