/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util;

import eu.geclipse.core.internal.Activator;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class SecureFile
extends File {
    private static final String SECURE_PERMISSIONS_FAILED = "Failed to set secure permissions: ";
    private static final long serialVersionUID = 101010123456789010L;

    public SecureFile(String string) {
        super(string);
    }

    public SecureFile(String string, String string2) {
        super(string, string2);
    }

    public SecureFile(File file, String string) {
        super(file, string);
    }

    public SecureFile(URI uRI) {
        super(uRI);
    }

    private static boolean protect(String string) {
        Status status;
        String string2;
        int n = 0;
        if (System.getProperty("os.name").contains("Windows")) {
            return true;
        }
        String string3 = "600";
        SecureFile secureFile = new SecureFile(string);
        if (secureFile.isDirectory()) {
            string3 = "700";
        }
        String[] stringArray = new String[]{"chmod", string3, string};
        String[] stringArray2 = new String[]{"PATH=/bin;/usr/bin;/usr/local/bin"};
        Runtime runtime = Runtime.getRuntime();
        Process process = null;
        try {
            process = runtime.exec(stringArray, stringArray2);
        }
        catch (Exception exception) {
            String string4 = "Failed to set secure permissions: Exception running chmod";
            Status status2 = new Status(2, "eu.geclipse.core", 0, string4, (Throwable)exception);
            Activator.logStatus((IStatus)status2);
            return false;
        }
        InputStream inputStream = process.getErrorStream();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        InputStream inputStream2 = process.getInputStream();
        new BufferedReader(new InputStreamReader(inputStream2));
        try {
            n = process.waitFor();
        }
        catch (InterruptedException interruptedException) {
            n = 1;
            string2 = "Failed to set secure permissions: Exception waiting for chmod to finish";
            status = new Status(2, "eu.geclipse.core", 0, string2, (Throwable)interruptedException);
            Activator.logStatus((IStatus)status);
        }
        if (n != 0) {
            String string5 = null;
            string2 = "chmod command returned non-zero value: ";
            try {
                while ((string5 = bufferedReader.readLine()) != null) {
                    string2.concat(String.valueOf(string5) + " -- ");
                }
            }
            catch (IOException iOException) {}
            status = new Status(2, "eu.geclipse.core", SECURE_PERMISSIONS_FAILED + string2);
            Activator.logStatus((IStatus)status);
            return false;
        }
        return true;
    }

    public boolean setSecure() throws IOException {
        String string = this.getPath();
        boolean bl = SecureFile.protect(string);
        if (!bl) {
            throw new IOException(SECURE_PERMISSIONS_FAILED + string);
        }
        return bl;
    }

    public boolean isSecure() {
        return false;
    }

    public boolean createNewFile() throws IOException {
        if (!super.createNewFile()) {
            return false;
        }
        String string = this.getPath();
        boolean bl = SecureFile.protect(string);
        if (!bl) {
            File file = new File(string);
            file.delete();
            throw new IOException(SECURE_PERMISSIONS_FAILED + string);
        }
        return bl;
    }

    public static SecureFile createTempFile(String string, String string2) throws IOException {
        return SecureFile.createTempFile(string, string2, null);
    }

    public static SecureFile createTempFile(String string, String string2, File file) throws IOException {
        File file2 = File.createTempFile(string, string2, file);
        String string3 = file2.getPath();
        SecureFile secureFile = new SecureFile(string3);
        if (!SecureFile.protect(string3)) {
            throw new IOException(SECURE_PERMISSIONS_FAILED + string3);
        }
        return secureFile;
    }

    public boolean renameTo(File file) {
        return super.renameTo(file) && SecureFile.protect(this.getPath());
    }

    public boolean mkdir() {
        return super.mkdir() && SecureFile.protect(this.getPath());
    }

    public boolean mkdirs() {
        return super.mkdirs() && SecureFile.protect(this.getPath());
    }

    public static /* bridge */ /* synthetic */ File createTempFile(String string, String string2, File file) throws IOException {
        return SecureFile.createTempFile(string, string2, file);
    }

    public static /* bridge */ /* synthetic */ File createTempFile(String string, String string2) throws IOException {
        return SecureFile.createTempFile(string, string2);
    }
}

