/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util;

import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.ISolution;
import eu.geclipse.core.Messages;
import eu.geclipse.core.SolutionRegistry;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.Date;
import org.eclipse.core.runtime.IProgressMonitor;

public class TimeChecker {
    static final String[] SERVERS = new String[]{"time.fu-berlin.de", "time.mtu.edu", "ntp0.csx.cam.ac.uk"};
    private static final int RDATE_PORT = 37;
    private static final long EPOCH_DIFFERENCE = 2208988800L;
    private static final int TIMEOUT = 5000;
    private static final int MAX_SYSTIME_OFFSET = 90;
    private static final int MAX_SERVER_SPREAD = 10;
    private long sysTime = 0L;
    private long referenceTime = 0L;

    public boolean getTimeCheckStatus() {
        boolean bl = false;
        if (this.sysTime != 0L && Math.abs(this.sysTime - this.referenceTime) <= 90L) {
            bl = true;
        }
        return bl;
    }

    public void checkSysTime(IProgressMonitor iProgressMonitor) throws GridException, InterruptedException {
        long[] lArray = new long[SERVERS.length];
        long l = 0L;
        long l2 = 0L;
        this.sysTime = System.currentTimeMillis() / 1000L;
        iProgressMonitor.beginTask(Messages.getString("TimeChecker.quering_time_servers"), SERVERS.length);
        int n = 0;
        while (n < SERVERS.length) {
            iProgressMonitor.subTask(String.valueOf(Messages.getString("TimeChecker.contacting")) + " " + SERVERS[n] + "...");
            try {
                lArray[n] = TimeChecker.queryTime(SERVERS[n]);
            }
            catch (GridException gridException) {
                lArray[n] = 0L;
            }
            iProgressMonitor.worked(1);
            if (iProgressMonitor.isCanceled()) {
                throw new InterruptedException();
            }
            ++n;
        }
        Arrays.sort(lArray);
        iProgressMonitor.done();
        n = 0;
        int n2 = 0;
        while (n2 < SERVERS.length) {
            if (lArray[n2] == 0L) {
                n = (short)(n + 1);
            } else {
                l += lArray[n2];
            }
            ++n2;
        }
        if (n == SERVERS.length) {
            GridException gridException = new GridException(CoreProblems.SYSTEM_TIME_CHECK_FAILED, Messages.getString("TimeChecker.no_servers_reachable"));
            ISolution iSolution = SolutionRegistry.getRegistry().getSolution(SolutionRegistry.CHECK_INTERNET_CONNECTION);
            gridException.getProblem().addSolution(iSolution);
            iSolution = SolutionRegistry.getRegistry().getSolution(SolutionRegistry.CHECK_FIREWALL);
            gridException.getProblem().addSolution(iSolution);
            throw gridException;
        }
        this.referenceTime = l /= (long)(SERVERS.length - n);
        l2 = lArray[SERVERS.length - 1] - lArray[n];
        if (l2 >= 10L) {
            GridException gridException = new GridException(CoreProblems.SYSTEM_TIME_CHECK_FAILED, Messages.getString("TimeChecker.inconsistent_servers"));
            ISolution iSolution = SolutionRegistry.getRegistry().getSolution(SolutionRegistry.CONTACT_SERVER_ADMINS);
            gridException.getProblem().addSolution(iSolution);
            throw gridException;
        }
    }

    protected static long queryTime(String string) throws GridException {
        DatagramSocket datagramSocket;
        InetAddress inetAddress;
        long l = 0L;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            throw new GridException(CoreProblems.UNKNOWN_HOST, unknownHostException);
        }
        try {
            datagramSocket = new DatagramSocket();
            datagramSocket.setSoTimeout(5000);
        }
        catch (SocketException socketException) {
            throw new GridException(CoreProblems.BIND_FAILED, socketException);
        }
        DatagramPacket datagramPacket = new DatagramPacket(new byte[0], 0, inetAddress, 37);
        try {
            datagramSocket.send(datagramPacket);
        }
        catch (Exception exception) {
            throw new GridException(CoreProblems.CONNECTION_FAILED, exception);
        }
        byte[] byArray = new byte[4];
        datagramPacket = new DatagramPacket(byArray, byArray.length);
        try {
            datagramSocket.receive(datagramPacket);
        }
        catch (Exception exception) {
            throw new GridException(CoreProblems.CONNECTION_TIMEOUT, exception);
        }
        l = TimeChecker.readLongFromNetwork(byArray);
        return l - 2208988800L;
    }

    private static long readLongFromNetwork(byte[] byArray) {
        long l = 0L;
        long l2 = 0L;
        int n = 0;
        while (n < byArray.length) {
            l2 <<= 8;
            l = 0xFFL & (long)byArray[n];
            l2 |= l;
            ++n;
        }
        return l2;
    }

    public String getSystemDate() {
        Date date = new Date(this.sysTime * 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 0);
        return dateFormat.format(date);
    }

    public String getReferenceDate() {
        Date date = new Date(this.referenceTime * 1000L);
        DateFormat dateFormat = DateFormat.getDateTimeInstance(2, 0);
        return dateFormat.format(date);
    }

    public long getOffset() {
        return Math.abs(this.sysTime - this.referenceTime);
    }

    public int getTolerance() {
        return 90;
    }
}

