/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util.tar;

import eu.geclipse.core.util.tar.TarArchiveException;
import eu.geclipse.core.util.tar.TarProblems;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class TarEntry {
    protected static final int BLOCK_SZ = 512;
    private static final int OFFSET_NAME = 0;
    private static final int OFFSET_SIZE = 124;
    private static final int OFFSET_CHECKSUM = 148;
    private static final int OFFSET_TYPE = 156;
    private static final int OFFSET_MAGIC = 257;
    private static final int OFFSET_VERSION = 263;
    private static final int OFFSET_PREFIX = 345;
    private static final int LENGTH_NAME = 100;
    private static final int LENGTH_SIZE = 12;
    private static final int LENGTH_CHECKSUM = 8;
    private static final int LENGTH_MAGIC = 6;
    private static final int LENGTH_PREFIX = 155;
    private static final byte ENTRY_TYPE_FILE = 48;
    private static final byte ENTRY_TYPE_FILE_ALT = 0;
    private static final byte ENTRY_TYPE_HARDLINK = 49;
    private static final byte ENTRY_TYPE_SOFTLINK = 50;
    private static final byte ENTRY_TYPE_CHARDEV = 51;
    private static final byte ENTRY_TYPE_BLOCKDEV = 52;
    private static final byte ENTRY_TYPE_DIR = 53;
    private static final byte ENTRY_TYPE_FIFO = 54;
    private static final byte SPACE = 32;
    private static final String MAGIC = "ustar ";
    private static final byte ENTRY_FLAG_NULL = 45;
    private static final byte ENTRY_FLAG_FILE = 102;
    private static final byte ENTRY_FLAG_DIR = 100;
    private IPath entryPath;
    private long entrySize;
    private byte entryType;

    public TarEntry(byte[] byArray) throws TarArchiveException {
        String string;
        if (byArray.length != 512) {
            throw new TarArchiveException(TarProblems.WRONG_HEADER_SIZE);
        }
        if (this.assertNullEntry(byArray)) {
            this.entryType = (byte)45;
            this.entrySize = 0L;
            return;
        }
        this.verifyChecksum(byArray);
        String string2 = this.readString(byArray, 257, 6);
        if (!string2.equals(MAGIC) || byArray[263] != 32 || byArray[264] != 0) {
            throw new TarArchiveException(TarProblems.UNSUPPORTED_ENTRY_TYPE);
        }
        String string3 = this.readString(byArray, 0, 100);
        String string4 = this.readString(byArray, 345, 155);
        if (string4.length() != 0) {
            string = System.getProperty("file.separator");
            if (!string4.endsWith(string)) {
                string4.concat(string);
            }
            string3 = string4.concat(string3);
        }
        this.entryPath = new Path(string3);
        string = this.readString(byArray, 124, 11);
        try {
            string = string.replaceAll("^ +", "");
            this.entrySize = Long.parseLong(string, 8);
        }
        catch (Exception exception) {
            throw new TarArchiveException(TarProblems.INVALID_ENTRY_SIZE, exception);
        }
        if (byArray[135] != 0 && byArray[135] != 32) {
            throw new TarArchiveException(TarProblems.INVALID_ENTRY_SIZE);
        }
        switch ((char)byArray[156]) {
            case '\u0000': 
            case '0': {
                this.entryType = (byte)102;
                break;
            }
            case '1': 
            case '2': 
            case '3': 
            case '4': 
            case '6': {
                throw new TarArchiveException(TarProblems.UNSUPPORTED_ENTRY_TYPE);
            }
            case '5': {
                this.entryType = (byte)100;
                break;
            }
            default: {
                throw new TarArchiveException(TarProblems.INVALID_ENTRY_TYPE);
            }
        }
    }

    private String readString(byte[] byArray, int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        while (byArray[n + n3] != 0 && n3 < n2) {
            stringBuffer = stringBuffer.append((char)byArray[n + n3]);
            ++n3;
        }
        return stringBuffer.toString();
    }

    private void verifyChecksum(byte[] byArray) throws TarArchiveException {
        int n;
        int n2 = 0;
        int n3 = 0;
        while (n3 < 148) {
            n2 += byArray[n3];
            ++n3;
        }
        n2 += 256;
        n3 = 156;
        while (n3 < 512) {
            n2 += byArray[n3];
            ++n3;
        }
        String string = this.readString(byArray, 148, 6);
        try {
            string = string.replaceAll("^ +", "");
            n = Integer.parseInt(string, 8);
        }
        catch (Exception exception) {
            throw new TarArchiveException(TarProblems.BAD_HEADER_CHECKSUM, exception);
        }
        if (byArray[154] != 0 || byArray[155] != 32) {
            throw new TarArchiveException(TarProblems.BAD_HEADER_CHECKSUM);
        }
        if (n2 != n) {
            throw new TarArchiveException(TarProblems.BAD_HEADER_CHECKSUM);
        }
    }

    private boolean assertNullEntry(byte[] byArray) {
        boolean bl = true;
        byte[] byArray2 = byArray;
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte by = byArray2[n2];
            if (by != 0) {
                bl = false;
                break;
            }
            ++n2;
        }
        return bl;
    }

    public boolean isNull() {
        return this.entryType == 45;
    }

    public boolean isDirectory() {
        return this.entryType == 100;
    }

    public IPath getPath() {
        return this.entryPath;
    }

    public long getSize() {
        return this.entrySize;
    }
}

