/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.core.util.tar;

import eu.geclipse.core.util.tar.TarArchiveException;
import eu.geclipse.core.util.tar.TarEntry;
import eu.geclipse.core.util.tar.TarProblems;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class TarInputStream {
    private static final int BLOCK_SZ = 512;
    private static final int BLOCK_MASK = 511;
    private InputStream tarStream;
    private TarEntry currentEntry;
    private boolean dataPending;

    public TarInputStream(InputStream inputStream) {
        this.tarStream = inputStream;
        this.currentEntry = null;
        this.dataPending = false;
    }

    public TarEntry getNextEntry() throws TarArchiveException {
        TarEntry tarEntry;
        if (this.currentEntry != null && this.dataPending) {
            this.copyEntryContents(null);
        }
        try {
            tarEntry = new TarEntry(this.readBlock(512));
            if (tarEntry.isNull()) {
                tarEntry = new TarEntry(this.readBlock(512));
            }
        }
        catch (IOException iOException) {
            throw new TarArchiveException(TarProblems.UNSPECIFIED_IO_PROBLEM, iOException);
        }
        if (!tarEntry.isNull()) {
            if (tarEntry.getSize() > 0L) {
                this.dataPending = true;
            }
            this.currentEntry = tarEntry;
        }
        return tarEntry.isNull() ? null : this.currentEntry;
    }

    private byte[] readBlock(int n) throws IOException {
        byte[] byArray = new byte[n];
        int n2 = 0;
        int n3 = n;
        int n4 = 0;
        do {
            n4 = this.tarStream.read(byArray, n2, n3);
            n3 -= n4;
        } while ((n2 += n4) < n);
        return byArray;
    }

    public void copyEntryContents(OutputStream outputStream) throws TarArchiveException {
        long l = this.currentEntry.getSize();
        long l2 = l / 512L;
        int n = (int)l & 0x1FF;
        if (n != 0) {
            ++l2;
        }
        byte[] byArray = new byte[512];
        int n2 = 512;
        try {
            while (l2 > 0L) {
                byArray = this.readBlock(512);
                if (outputStream != null) {
                    if (l2 == 1L && n != 0) {
                        n2 = n;
                    }
                    outputStream.write(byArray, 0, n2);
                }
                --l2;
            }
        }
        catch (IOException iOException) {
            throw new TarArchiveException(TarProblems.UNSPECIFIED_IO_PROBLEM);
        }
        this.dataPending = false;
    }
}

