/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.codec.uncompressed;

import eu.geclipse.gvid.IConnection;
import eu.geclipse.gvid.IDecoder;
import eu.geclipse.gvid.IEvents;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ComponentColorModel;
import java.awt.image.DataBufferByte;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;

public class UncompressedDecoder
implements IDecoder {
    private IConnection connection;
    private IEvents events;
    private BufferedImage image = new BufferedImage(100, 100, 6);
    private byte[] imageData;
    private int framesDecoded = 0;

    public boolean decodeNextFrame() throws IOException {
        boolean bl = false;
        int n = 4;
        if (this.connection.getNumBytesInBuffer() != 0) {
            int n2;
            int n3 = this.connection.readUint32();
            int n4 = this.connection.readUint32();
            if (this.image.getWidth() != n3 || this.image.getHeight() != n4) {
                n2 = n3 * n4 * n;
                this.imageData = new byte[n2];
                DataBufferByte dataBufferByte = new DataBufferByte(this.imageData, n2);
                ComponentColorModel componentColorModel = new ComponentColorModel(ColorSpace.getInstance(1000), true, true, 1, 0);
                int[] nArray = new int[4];
                nArray[1] = 1;
                nArray[2] = 2;
                nArray[3] = 3;
                WritableRaster writableRaster = Raster.createInterleavedRaster(dataBufferByte, n3, n4, n3 * n, n, nArray, null);
                this.image = new BufferedImage(componentColorModel, writableRaster, false, null);
            }
            n2 = 0;
            while ((n2 += this.connection.readData(this.imageData, n3 * n4 * n - n2, n2)) != n3 * n4 * n) {
            }
            ++this.framesDecoded;
            this.events.sendFrameFinished(this.framesDecoded, 0, 0);
            bl = true;
        }
        return bl;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public int getXSize() {
        return this.image.getWidth();
    }

    public int getYSize() {
        return this.image.getHeight();
    }

    public void init(IConnection iConnection, IEvents iEvents) {
        this.connection = iConnection;
        this.events = iEvents;
    }
}

