/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.internal;

import eu.geclipse.gvid.internal.Event;
import eu.geclipse.gvid.internal.Events;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;

class AwtEventConverter
implements MouseMotionListener,
MouseListener,
KeyListener,
WindowListener,
ComponentListener,
MouseWheelListener {
    private Events events;
    private byte mouseState;
    private IOException exception;

    AwtEventConverter(Events events) {
        this.events = events;
        this.mouseState = 0;
        this.exception = null;
    }

    void checkForException() throws IOException {
        if (this.exception != null) {
            throw this.exception;
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = 1;
            event.active.gain = 1;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = 1;
            event.active.gain = 0;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = (byte)5;
            event.button.button = (byte)mouseEvent.getButton();
            this.mouseState = (byte)(this.mouseState | 1 << event.button.button);
            event.button.x = (short)mouseEvent.getX();
            event.button.y = (short)mouseEvent.getY();
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = (byte)6;
            event.button.button = (byte)mouseEvent.getButton();
            this.mouseState = (byte)(this.mouseState & ~(1 << event.button.button));
            event.button.x = (short)mouseEvent.getX();
            event.button.y = (short)mouseEvent.getY();
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void keyPressed(KeyEvent keyEvent) {
        try {
            Event event = this.convertKeyEvent(keyEvent);
            event.type = (byte)2;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            Event event = this.convertKeyEvent(keyEvent);
            event.type = (byte)3;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    private Event convertKeyEvent(KeyEvent keyEvent) {
        Event event = new Event();
        short s = 0;
        event.type = (byte)2;
        event.key.key = (short)keyEvent.getKeyChar();
        switch (keyEvent.getKeyCode()) {
            case 10: {
                event.key.key = (short)13;
                break;
            }
            case 112: {
                event.key.key = (short)282;
                break;
            }
            case 113: {
                event.key.key = (short)283;
                break;
            }
            case 114: {
                event.key.key = (short)284;
                break;
            }
            case 115: {
                event.key.key = (short)285;
                break;
            }
            case 116: {
                event.key.key = (short)286;
                break;
            }
            case 117: {
                event.key.key = (short)287;
                break;
            }
            case 118: {
                event.key.key = (short)288;
                break;
            }
            case 119: {
                event.key.key = (short)289;
                break;
            }
            case 120: {
                event.key.key = (short)290;
                break;
            }
            case 121: {
                event.key.key = (short)291;
                break;
            }
            case 122: {
                event.key.key = (short)292;
                break;
            }
            case 123: {
                event.key.key = (short)293;
                break;
            }
            case 16: {
                event.key.key = (short)303;
                break;
            }
            case 17: {
                event.key.key = (short)306;
                break;
            }
            case 18: {
                event.key.key = (short)308;
                break;
            }
            case 19: {
                event.key.key = (short)302;
                break;
            }
            case 8: {
                event.key.key = (short)8;
                break;
            }
            case 45: {
                event.key.key = (short)269;
                break;
            }
            case 38: {
                event.key.key = (short)273;
                break;
            }
            case 40: {
                event.key.key = (short)274;
                break;
            }
            case 39: {
                event.key.key = (short)275;
                break;
            }
            case 37: {
                event.key.key = (short)276;
                break;
            }
            default: {
                event.key.key = (short)keyEvent.getKeyChar();
            }
        }
        if ((keyEvent.getModifiers() & 1) != 0) {
            s = (short)(s | 1);
        }
        if ((keyEvent.getModifiers() & 2) != 0) {
            s = (short)(s | 0x40);
        }
        if ((keyEvent.getModifiers() & 8) != 0) {
            s = (short)(s | 0x100);
        }
        if ((keyEvent.getModifiers() & 4) != 0) {
            s = (short)(s | 0x400);
        }
        event.key.modifier = s;
        return event;
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void windowActivated(WindowEvent windowEvent) {
    }

    public void windowClosed(WindowEvent windowEvent) {
    }

    public void windowClosing(WindowEvent windowEvent) {
        try {
            Event event = new Event();
            event.type = (byte)7;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void windowDeactivated(WindowEvent windowEvent) {
    }

    public void windowDeiconified(WindowEvent windowEvent) {
    }

    public void windowIconified(WindowEvent windowEvent) {
    }

    public void windowOpened(WindowEvent windowEvent) {
    }

    public void componentHidden(ComponentEvent componentEvent) {
    }

    public void componentMoved(ComponentEvent componentEvent) {
    }

    public void componentResized(ComponentEvent componentEvent) {
        try {
            Component component = (Component)componentEvent.getSource();
            Dimension dimension = component.getSize();
            Event event = new Event();
            event.type = (byte)8;
            event.resize.w = (short)dimension.getWidth();
            event.resize.h = (short)dimension.getHeight();
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void componentShown(ComponentEvent componentEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = (byte)4;
            event.motion.state = this.mouseState;
            event.motion.x = (short)mouseEvent.getX();
            event.motion.y = (short)mouseEvent.getY();
            event.motion.xrel = 0;
            event.motion.yrel = 0;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        try {
            Event event = new Event();
            event.type = (byte)4;
            event.motion.state = this.mouseState;
            event.motion.x = (short)mouseEvent.getX();
            event.motion.y = (short)mouseEvent.getY();
            event.motion.xrel = 0;
            event.motion.yrel = 0;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }

    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        try {
            Event event = new Event();
            event.type = (byte)5;
            event.button.button = mouseWheelEvent.getWheelRotation() < 0 ? (byte)4 : (byte)5;
            event.button.x = (short)mouseWheelEvent.getX();
            event.button.y = (short)mouseWheelEvent.getY();
            this.events.sendEvent(event);
            event.type = (byte)6;
            this.events.sendEvent(event);
        }
        catch (IOException iOException) {
            this.exception = iOException;
        }
    }
}

