/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.internal;

import eu.geclipse.gvid.Activator;
import eu.geclipse.gvid.IConnection;
import eu.geclipse.gvid.internal.Messages;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class Connection
implements IConnection {
    private static final int READ_BUFFER_SIZE = 0x200000;
    private long bytesReceived;
    private long bytesSent;
    private long oldBytesReceived;
    private long oldBytesSent;
    private long sendSpeed;
    private long recvSpeed;
    private long lastSendMeasureTime;
    private long lastRecvMeasureTime;
    private byte[] readBuffer;
    private int readBufferDataStart = 0;
    private int bytesInBuffer;
    private InputStream inputStream;
    private OutputStream outputStream;

    public Connection(InputStream inputStream, OutputStream outputStream) {
        this.inputStream = inputStream;
        this.outputStream = outputStream;
        this.bytesReceived = 0L;
        this.bytesSent = 0L;
        this.oldBytesReceived = 0L;
        this.oldBytesSent = 0L;
        this.sendSpeed = 0L;
        this.recvSpeed = 0L;
        this.lastSendMeasureTime = System.currentTimeMillis();
        this.lastRecvMeasureTime = System.currentTimeMillis();
        this.readBuffer = new byte[0x200000];
        this.readBufferDataStart = 0;
        this.bytesInBuffer = 0;
    }

    public int writeData(byte[] byArray, int n) throws IOException {
        this.outputStream.write(byArray, 0, n);
        this.bytesSent += (long)n;
        return n;
    }

    public void fillBuffer(boolean bl) throws IOException {
        if (this.readBufferDataStart > 0x100000) {
            System.arraycopy(this.readBuffer, this.readBufferDataStart, this.readBuffer, 0, this.bytesInBuffer);
            this.readBufferDataStart = 0;
        }
        if (this.bytesInBuffer < 0x200000 && (bl || this.inputStream.available() > 0)) {
            int n = this.inputStream.read(this.readBuffer, this.readBufferDataStart + this.bytesInBuffer, 0x200000 - this.bytesInBuffer - this.readBufferDataStart);
            if (n < 0) {
                throw new IOException(Messages.getString("Connection.readFailed"));
            }
            this.bytesReceived += (long)n;
            this.bytesInBuffer += n;
        }
    }

    public int getNumBytesInBuffer() throws IOException {
        this.fillBuffer(false);
        return this.bytesInBuffer;
    }

    public void dropBytes(int n) throws IOException {
        int n2 = n;
        if (n > this.bytesInBuffer) {
            Activator.logMessage(4, Messages.formatMessage("Connection.amountGreaterBufferContents", new Integer(n), new Integer(this.bytesInBuffer)));
            n2 = this.bytesInBuffer;
        }
        this.bytesInBuffer -= n2;
        this.readBufferDataStart += n2;
        this.fillBuffer(false);
    }

    public int getDataStart() {
        return this.readBufferDataStart;
    }

    public byte[] getDataBuffer() {
        return this.readBuffer;
    }

    public void flush() {
        try {
            this.outputStream.flush();
        }
        catch (IOException iOException) {
            Activator.logException(iOException);
        }
    }

    public int readData(byte[] byArray, int n) throws IOException {
        return this.readData(byArray, n, 0);
    }

    public int readData(byte[] byArray, int n, int n2) throws IOException {
        this.fillBuffer(this.bytesInBuffer == 0);
        int n3 = n;
        if (this.bytesInBuffer < n3) {
            n3 = this.bytesInBuffer;
        }
        System.arraycopy(this.readBuffer, this.readBufferDataStart, byArray, n2, n3);
        this.dropBytes(n3);
        return n3;
    }

    public long getCurrentSendSpeed() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastSendMeasureTime;
        if (l2 > 1000L) {
            this.lastSendMeasureTime = l;
            this.sendSpeed = (this.bytesSent - this.oldBytesSent) * 1000L / l2;
            this.oldBytesSent = this.bytesSent;
        }
        return this.sendSpeed;
    }

    public long getCurrentRecvSpeed() {
        long l = System.currentTimeMillis();
        long l2 = l - this.lastRecvMeasureTime;
        if (l2 > 1000L) {
            this.lastRecvMeasureTime = l;
            this.recvSpeed = (this.bytesReceived - this.oldBytesReceived) * 1000L / l2;
            this.oldBytesReceived = this.bytesReceived;
        }
        return this.recvSpeed;
    }

    public byte readByte() throws IOException {
        byte[] byArray = new byte[1];
        this.readData(byArray, 1);
        return byArray[0];
    }

    public short readUint16() throws IOException {
        short s = 0;
        s = (short)(0xFF & this.readByte());
        s = (short)(s << 8);
        s = (short)(s + (0xFF & this.readByte()));
        return s;
    }

    public int readUint32() throws IOException {
        int n = 0;
        n = 0xFF & this.readByte();
        n <<= 8;
        n += 0xFF & this.readByte();
        n <<= 8;
        n += 0xFF & this.readByte();
        n <<= 8;
        return n += 0xFF & this.readByte();
    }
}

