/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.internal;

import eu.geclipse.gvid.Activator;
import eu.geclipse.gvid.IEvents;
import eu.geclipse.gvid.internal.Connection;
import eu.geclipse.gvid.internal.Event;
import eu.geclipse.gvid.internal.Messages;
import java.io.IOException;

public class Events
implements IEvents {
    public static final int NO_EVENT = 0;
    public static final int ACTIVE_EVENT = 1;
    public static final int KEY_PRESS_EVENT = 2;
    public static final int KEY_RELEASE_EVENT = 3;
    public static final int MOUSE_MOVE_EVENT = 4;
    public static final int MOUSE_PRESS_EVENT = 5;
    public static final int MOUSE_RELEASE_EVENT = 6;
    public static final int QUIT_EVENT = 7;
    public static final int VIDEO_RESIZE_EVENT = 8;
    public static final int FRAME_FINISHED = 9;
    public static final int REDRAW = 10;
    private Connection connection;
    private boolean haveOldMotion;
    private Event oldMotion;
    private Event redrawEvent;
    private Event quitEvent;
    private int lastDecoderFrameNr;

    public Events(Connection connection) {
        this.connection = connection;
        this.haveOldMotion = false;
        this.oldMotion = new Event();
        this.oldMotion.motion.x = 0;
        this.oldMotion.motion.y = 0;
        this.oldMotion.motion.xrel = 0;
        this.oldMotion.motion.yrel = 0;
        this.oldMotion.type = (byte)4;
        this.redrawEvent = new Event();
        this.redrawEvent.type = (byte)10;
        this.quitEvent = new Event();
        this.quitEvent.type = (byte)7;
        this.lastDecoderFrameNr = -1;
    }

    Event recvEvent() throws IOException {
        Event event = null;
        if (this.connection.getNumBytesInBuffer() != 0) {
            event = new Event();
            event.type = this.connection.readByte();
            switch (event.type) {
                case 7: {
                    break;
                }
                case 8: {
                    event.resize.w = this.connection.readUint16();
                    event.resize.h = this.connection.readUint16();
                    break;
                }
                case 1: {
                    event.active.gain = this.connection.readByte();
                    break;
                }
                case 2: 
                case 3: {
                    event.key.key = this.connection.readUint16();
                    event.key.modifier = this.connection.readUint16();
                    break;
                }
                case 4: {
                    event.motion.state = this.connection.readByte();
                    event.motion.x = this.connection.readUint16();
                    event.motion.y = this.connection.readUint16();
                    event.motion.xrel = this.connection.readUint16();
                    event.motion.yrel = this.connection.readUint16();
                    break;
                }
                case 5: 
                case 6: {
                    event.button.button = this.connection.readByte();
                    event.button.x = this.connection.readUint16();
                    event.button.y = this.connection.readUint16();
                    break;
                }
                case 9: {
                    event.frame_finished.frame_num = this.connection.readUint32();
                    event.frame_finished.enc_time = this.connection.readUint32();
                    event.frame_finished.comp_time = this.connection.readUint32();
                    this.lastDecoderFrameNr = event.frame_finished.frame_num;
                    break;
                }
                case 10: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    Activator.logMessage(4, Messages.getString("Events.invalidEventType"));
                }
            }
        }
        return event;
    }

    int getLastDecoderFrameNr() {
        return this.lastDecoderFrameNr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendEvent(Event event) throws IOException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (event != this.oldMotion) {
                if (this.haveOldMotion && (event.type != 4 || event.motion.state != this.oldMotion.motion.state)) {
                    this.flush();
                }
                if (!(event.type != 4 || this.haveOldMotion && this.oldMotion.motion.state != event.motion.state)) {
                    this.oldMotion.motion.state = event.motion.state;
                    this.oldMotion.motion.x = event.motion.x;
                    this.oldMotion.motion.y = event.motion.y;
                    this.oldMotion.motion.xrel = (short)(this.oldMotion.motion.xrel + event.motion.xrel);
                    this.oldMotion.motion.yrel = (short)(this.oldMotion.motion.yrel + event.motion.yrel);
                    this.haveOldMotion = true;
                    return;
                }
            }
            byte[] byArray = new byte[30];
            int n = 0;
            byArray[n++] = event.type;
            switch (event.type) {
                case 7: {
                    break;
                }
                case 8: {
                    n = this.putUint16(n, byArray, event.resize.w);
                    n = this.putUint16(n, byArray, event.resize.h);
                    break;
                }
                case 1: {
                    byArray[n++] = event.active.gain;
                    break;
                }
                case 2: 
                case 3: {
                    n = this.putUint16(n, byArray, event.key.key);
                    n = this.putUint16(n, byArray, event.key.modifier);
                    break;
                }
                case 4: {
                    byArray[n++] = event.motion.state;
                    n = this.putUint16(n, byArray, event.motion.x);
                    n = this.putUint16(n, byArray, event.motion.y);
                    n = this.putUint16(n, byArray, event.motion.xrel);
                    n = this.putUint16(n, byArray, event.motion.yrel);
                    break;
                }
                case 5: 
                case 6: {
                    byArray[n++] = event.button.button;
                    n = this.putUint16(n, byArray, event.button.x);
                    n = this.putUint16(n, byArray, event.button.y);
                    break;
                }
                case 9: {
                    n = this.putUint32(n, byArray, event.frame_finished.frame_num);
                    n = this.putUint32(n, byArray, event.frame_finished.enc_time);
                    n = this.putUint32(n, byArray, event.frame_finished.comp_time);
                    break;
                }
                case 10: {
                    break;
                }
                case 0: {
                    break;
                }
                default: {
                    n = 0;
                    Activator.logMessage(4, Messages.getString("Events.invalidEventType"));
                }
            }
            if (n != 0 || event.type == 10) {
                this.connection.writeData(byArray, n);
            }
        }
    }

    void sendRedrawEvent() throws IOException {
        this.sendEvent(this.redrawEvent);
    }

    void sendQuitEvent() throws IOException {
        this.sendEvent(this.quitEvent);
    }

    public void sendFrameFinished(int n, int n2, int n3) throws IOException {
        Event event = new Event();
        event.type = (byte)9;
        event.frame_finished.frame_num = n;
        event.frame_finished.enc_time = n2;
        event.frame_finished.comp_time = n3;
        this.sendEvent(event);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flush() throws IOException {
        Connection connection = this.connection;
        synchronized (connection) {
            if (this.haveOldMotion) {
                this.sendEvent(this.oldMotion);
                this.connection.flush();
                this.oldMotion.motion.x = 0;
                this.oldMotion.motion.y = 0;
                this.oldMotion.motion.xrel = 0;
                this.oldMotion.motion.yrel = 0;
                this.haveOldMotion = false;
            }
        }
    }

    int putUint16(int n, byte[] byArray, short s) {
        int n2 = n;
        byArray[n2++] = (byte)(s >> 8);
        byArray[n2++] = (byte)(s & 0xFF);
        return n2;
    }

    int putUint32(int n, byte[] byArray, int n2) {
        int n3 = n;
        byArray[n3++] = (byte)(n2 >> 24);
        byArray[n3++] = (byte)((n2 & 0xFF0000) >> 16);
        byArray[n3++] = (byte)((n2 & 0xFF00) >> 8);
        byArray[n3++] = (byte)(n2 & 0xFF);
        return n3;
    }
}

