/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.internal;

import eu.geclipse.core.GridException;
import eu.geclipse.gvid.Activator;
import eu.geclipse.gvid.IDecoder;
import eu.geclipse.gvid.IGVidStatsListener;
import eu.geclipse.gvid.internal.AwtEventConverter;
import eu.geclipse.gvid.internal.Connection;
import eu.geclipse.gvid.internal.Events;
import eu.geclipse.gvid.internal.FpsCounter;
import eu.geclipse.gvid.internal.GVidStatsEvent;
import eu.geclipse.gvid.internal.Messages;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.event.EventListenerList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class GVidClient
extends Component
implements Runnable {
    private static final long serialVersionUID = 1L;
    private Connection connection;
    private IDecoder decoder;
    private int oldFps = -1;
    private long oldRecvSpd = -1L;
    private long oldSendSpd = -1L;
    private Events events;
    private AwtEventConverter awtEventConverter;
    private boolean running;
    private BufferedImage lastImage;
    private Graphics graphics;
    private final EventListenerList listenerList = new EventListenerList();
    private final FpsCounter fpsCounter = new FpsCounter();

    public GVidClient(InputStream inputStream, OutputStream outputStream) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        String string = iPreferenceStore.getString("codecName");
        this.connection = new Connection(inputStream, outputStream);
        this.events = new Events(this.connection);
        this.awtEventConverter = new AwtEventConverter(this.events);
        this.running = false;
        this.lastImage = new BufferedImage(100, 100, 5);
        this.decoder = this.getDecoderImpl(string);
        if (this.decoder != null) {
            this.decoder.init(this.connection, this.events);
        }
        this.registerEvents();
    }

    private IDecoder getDecoderImpl(String string) {
        CoreException coreException = null;
        IDecoder iDecoder = null;
        try {
            IExtension[] iExtensionArray;
            IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("eu.geclipse.gvid.codec");
            IExtension[] iExtensionArray2 = iExtensionArray = iExtensionPoint.getExtensions();
            int n = iExtensionArray.length;
            int n2 = 0;
            while (n2 < n) {
                IConfigurationElement[] iConfigurationElementArray;
                IExtension iExtension = iExtensionArray2[n2];
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray = iExtension.getConfigurationElements();
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                    if ("codec".equals(iConfigurationElement.getName()) && string.equals(iConfigurationElement.getAttribute("name"))) {
                        iDecoder = (IDecoder)iConfigurationElement.createExecutableExtension("decoderClass");
                    }
                    ++n4;
                }
                ++n2;
            }
        }
        catch (CoreException coreException2) {
            coreException = coreException2;
        }
        if (iDecoder == null || coreException != null) {
            NewProblemDialog.openProblem((Shell)Display.getCurrent().getActiveShell(), (String)Messages.getString("GVidClient.gvid"), (String)Messages.formatMessage("GVidClient.cantInstanciateCodec", string), (Throwable)coreException);
        }
        return iDecoder;
    }

    public void stop() {
        try {
            this.events.sendQuitEvent();
            this.running = false;
        }
        catch (IOException iOException) {}
    }

    public boolean isRunning() {
        return this.running;
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.lastImage.getWidth(), this.lastImage.getHeight());
    }

    private void registerEvents() {
        this.addMouseListener(this.awtEventConverter);
        this.addMouseMotionListener(this.awtEventConverter);
        this.addMouseWheelListener(this.awtEventConverter);
        this.addKeyListener(this.awtEventConverter);
        this.addComponentListener(this.awtEventConverter);
    }

    private void unregisterEvents() {
        this.removeMouseListener(this.awtEventConverter);
        this.removeMouseMotionListener(this.awtEventConverter);
        this.removeMouseWheelListener(this.awtEventConverter);
        this.removeKeyListener(this.awtEventConverter);
        this.removeComponentListener(this.awtEventConverter);
    }

    public boolean getFocusTraversalKeysEnabled() {
        return false;
    }

    public void run() {
        boolean bl = false;
        if (this.decoder == null) {
            return;
        }
        this.running = true;
        this.graphics = this.getGraphics();
        this.requestFocusInWindow();
        while (this.running) {
            try {
                if (this.decoder.decodeNextFrame()) {
                    this.fpsCounter.incFrameCount();
                    if (this.lastImage.getWidth() != this.decoder.getImage().getWidth() || this.lastImage.getHeight() != this.decoder.getImage().getHeight()) {
                        this.graphics = this.getGraphics();
                    }
                    this.lastImage = this.decoder.getImage();
                    if (!bl) {
                        this.setSize(this.lastImage.getWidth(), this.lastImage.getHeight());
                        bl = true;
                    }
                    this.graphics.drawImage(this.lastImage, 0, 0, null);
                } else {
                    Thread.sleep(10L);
                }
                this.awtEventConverter.checkForException();
                this.updateTransferStats();
                this.events.flush();
            }
            catch (InterruptedException interruptedException) {
                this.running = false;
            }
            catch (IOException iOException) {
                this.running = false;
            }
            catch (Exception exception) {
                this.running = false;
                final GridException gridException = new GridException(-1, (Throwable)exception);
                Display.getDefault().asyncExec(new Runnable(){

                    public void run() {
                        NewProblemDialog.openProblem(null, (String)"Error during video decoding", (String)"An error occured during video decoding (is the right codec selected?)", (GridException)gridException, null);
                    }
                });
            }
        }
        this.unregisterEvents();
    }

    private void updateTransferStats() {
        if (this.fpsCounter.getFps() != this.oldFps || this.connection.getCurrentRecvSpeed() != this.oldRecvSpd || this.connection.getCurrentSendSpeed() != this.oldSendSpd) {
            this.oldFps = this.fpsCounter.getFps();
            this.oldRecvSpd = this.connection.getCurrentRecvSpeed();
            this.oldSendSpd = this.connection.getCurrentSendSpeed();
            GVidStatsEvent gVidStatsEvent = new GVidStatsEvent(this, this.oldFps, this.oldRecvSpd, this.oldSendSpd);
            this.fireStatsEvent(gVidStatsEvent);
        }
    }

    public void addStatsListener(IGVidStatsListener iGVidStatsListener) {
        this.listenerList.add(IGVidStatsListener.class, iGVidStatsListener);
    }

    public void removeStatsListener(IGVidStatsListener iGVidStatsListener) {
        this.listenerList.remove(IGVidStatsListener.class, iGVidStatsListener);
    }

    private void fireStatsEvent(GVidStatsEvent gVidStatsEvent) {
        IGVidStatsListener[] iGVidStatsListenerArray = (IGVidStatsListener[])this.listenerList.getListeners(IGVidStatsListener.class);
        int n = 0;
        while (n < iGVidStatsListenerArray.length) {
            iGVidStatsListenerArray[n].statsUpdated(gVidStatsEvent);
            ++n;
        }
    }

    public void paint(Graphics graphics) {
        graphics.drawImage(this.lastImage, 0, 0, null);
    }
}

