/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.gvid.internal.views;

import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.gvid.IGVidPage;
import eu.geclipse.gvid.IGVidStatsListener;
import eu.geclipse.gvid.internal.GVidClient;
import eu.geclipse.gvid.internal.GVidStatsEvent;
import eu.geclipse.gvid.internal.views.Messages;
import java.awt.Frame;
import java.io.IOException;
import org.eclipse.swt.awt.SWT_AWT;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

class GVidPage
extends Composite
implements IGVidStatsListener,
IGVidPage {
    Label statsLabel;
    GVidClient gvidClient;
    Thread gvidThread;
    IBidirectionalConnection connection;
    private Frame awtFrame;
    private Composite SWT_AWT_container;
    private CTabItem tabItem;

    GVidPage(Composite composite, int n, CTabItem cTabItem) {
        super(composite, n);
        this.tabItem = cTabItem;
        this.initialize();
        this.awtFrame = SWT_AWT.new_Frame((Composite)this.SWT_AWT_container);
    }

    private void initialize() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 1;
        gridLayout.verticalSpacing = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        GridData gridData2 = new GridData();
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.verticalAlignment = 2;
        gridData2.horizontalAlignment = 4;
        this.setLayout((Layout)gridLayout);
        GridLayout gridLayout2 = new GridLayout(1, false);
        gridLayout2.marginWidth = 0;
        gridLayout2.marginHeight = 0;
        this.statsLabel = new Label((Composite)this, 0);
        this.statsLabel.setLayoutData((Object)gridData2);
        this.SWT_AWT_container = new Composite((Composite)this, 0x1000000);
        this.SWT_AWT_container.setLayout((Layout)new FillLayout());
        this.SWT_AWT_container.setLayoutData((Object)gridData);
    }

    void startClient(IBidirectionalConnection iBidirectionalConnection) throws IOException {
        this.connection = iBidirectionalConnection;
        this.gvidClient = new GVidClient(this.connection.getInputStream(), this.connection.getOutputStream());
        this.gvidClient.addStatsListener(this);
        this.awtFrame.add(this.gvidClient);
        this.awtFrame.validate();
        this.gvidThread = new Thread((Runnable)this.gvidClient, "GVid client thread");
        this.gvidThread.start();
    }

    void stopClient() {
        if (this.gvidClient != null) {
            this.gvidClient.stop();
            try {
                this.gvidThread.join();
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.connection != null) {
            this.connection.close();
        }
    }

    public void statsUpdated(GVidStatsEvent gVidStatsEvent) {
        final String string = Messages.formatMessage("GVidView.statsLine", new Integer(gVidStatsEvent.getFps()), new Double((double)((int)((double)gVidStatsEvent.getSendSpeed() / 102.4)) / 10.0), new Double((double)((int)((double)gVidStatsEvent.getRecvSpeed() / 102.4)) / 10.0));
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                GVidPage.this.statsLabel.setText(string);
            }
        });
    }

    public String getTabName() {
        return this.tabItem.getText();
    }

    public void setTabName(String string) {
        this.tabItem.setText(string);
    }
}

