/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.editors;

import eu.geclipse.jsdl.model.JobDefinitionType;
import eu.geclipse.jsdl.ui.adapters.jsdl.JsdlAdaptersFactory;
import eu.geclipse.jsdl.ui.adapters.posix.PosixAdaptersFactory;
import eu.geclipse.jsdl.ui.editors.Messages;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.DataStagingPage;
import eu.geclipse.jsdl.ui.internal.pages.JobApplicationPage;
import eu.geclipse.jsdl.ui.internal.pages.JobDefinitionPage;
import eu.geclipse.jsdl.ui.internal.pages.OverviewPage;
import eu.geclipse.jsdl.ui.internal.pages.ResourcesPage;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.ui.MarkerHelper;
import org.eclipse.emf.common.ui.editor.ProblemEditorPart;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.util.EditUIMarkerHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.SaveAsDialog;
import org.eclipse.ui.editors.text.TextEditor;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.part.FileEditorInput;

public final class JsdlEditor
extends FormEditor
implements IEditingDomainProvider {
    protected AdapterFactoryEditingDomain editingDomain;
    protected Collection<Resource> savedResources = new ArrayList<Resource>();
    protected Collection<Resource> removedResources = new ArrayList<Resource>();
    protected Collection<Resource> changedResources = new ArrayList<Resource>();
    protected ISelection editorSelection = StructuredSelection.EMPTY;
    protected Map<Resource, Diagnostic> resourceToDiagnosticMap = new LinkedHashMap<Resource, Diagnostic>();
    protected boolean updateProblemIndication = true;
    protected MarkerHelper markerHelper = new EditUIMarkerHelper();
    protected ComposedAdapterFactory adapterFactory;
    protected JobDefinitionType jobDefType = null;
    private TextEditor editor = null;
    private int sourcePageIndex;
    private boolean refreshedModel = false;
    private boolean isDirtyFlag = false;
    private OverviewPage overviewPage = new OverviewPage(this);
    private JobDefinitionPage jobDefPage = new JobDefinitionPage(this);
    private JobApplicationPage jobApplicationPage = new JobApplicationPage(this);
    private DataStagingPage dataStagingPage = new DataStagingPage(this);
    private ResourcesPage resourcesPage = new ResourcesPage(this);
    protected IResourceChangeListener resourceChangeListener = new IResourceChangeListener(){

        public void resourceChanged(IResourceChangeEvent iResourceChangeEvent) {
            IResourceDelta iResourceDelta = iResourceChangeEvent.getDelta();
            try {
                /*
                 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
                 */
                class ResourceDeltaVisitor
                implements IResourceDeltaVisitor {
                    protected ResourceSet resourceSet;
                    protected Collection<Resource> changedRes;
                    protected Collection<Resource> removedRes;

                    ResourceDeltaVisitor() {
                        this.resourceSet = (this).JsdlEditor.this.editingDomain.getResourceSet();
                        this.changedRes = new ArrayList<Resource>();
                        this.removedRes = new ArrayList<Resource>();
                    }

                    public boolean visit(IResourceDelta iResourceDelta) {
                        Resource resource;
                        if (iResourceDelta.getFlags() != 131072 && iResourceDelta.getResource().getType() == 1 && (iResourceDelta.getKind() & 6) != 0 && (resource = this.resourceSet.getResource(URI.createURI((String)iResourceDelta.getFullPath().toString()), false)) != null) {
                            if ((iResourceDelta.getKind() & 2) != 0) {
                                this.removedRes.add(resource);
                            } else if (!(this).JsdlEditor.this.savedResources.remove(resource)) {
                                this.changedRes.add(resource);
                            }
                        }
                        return true;
                    }

                    public Collection<Resource> getChangedResources() {
                        return this.changedRes;
                    }

                    public Collection<Resource> getRemovedResources() {
                        return this.removedRes;
                    }
                }
                ResourceDeltaVisitor resourceDeltaVisitor = new ResourceDeltaVisitor();
                iResourceDelta.accept((IResourceDeltaVisitor)resourceDeltaVisitor);
                if (!resourceDeltaVisitor.getRemovedResources().isEmpty()) {
                    JsdlEditor.this.removedResources.addAll(resourceDeltaVisitor.getRemovedResources());
                    if (!JsdlEditor.this.isDirty()) {
                        JsdlEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.getSite().getPage().closeEditor((IEditorPart)JsdlEditor.this, false);
                                JsdlEditor.this.dispose();
                            }
                        });
                    }
                }
                if (!resourceDeltaVisitor.getChangedResources().isEmpty()) {
                    JsdlEditor.this.changedResources.addAll(resourceDeltaVisitor.getChangedResources());
                    if (JsdlEditor.this.getSite().getPage().getActiveEditor() == JsdlEditor.this) {
                        JsdlEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.handleActivate();
                            }
                        });
                    }
                }
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
        }
    };
    protected EContentAdapter problemIndicationAdapter = new EContentAdapter(){

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void notifyChanged(Notification notification) {
            if (notification.getNotifier() instanceof Resource) {
                switch (notification.getFeatureID(Resource.class)) {
                    case 4: 
                    case 6: 
                    case 7: {
                        Resource resource = (Resource)notification.getNotifier();
                        Diagnostic diagnostic = JsdlEditor.this.analyzeResourceProblems((Resource)notification.getNotifier(), null);
                        if (diagnostic.getSeverity() != 0) {
                            JsdlEditor.this.resourceToDiagnosticMap.put(resource, diagnostic);
                        } else {
                            JsdlEditor.this.resourceToDiagnosticMap.remove(resource);
                        }
                        if (!JsdlEditor.this.updateProblemIndication) return;
                        JsdlEditor.this.getSite().getShell().getDisplay().asyncExec(new Runnable(){

                            public void run() {
                                JsdlEditor.this.updateProblemIndication();
                            }
                        });
                    }
                    default: {
                        return;
                    }
                }
            } else {
                super.notifyChanged(notification);
            }
        }

        protected void setTarget(Resource resource) {
            this.basicSetTarget((Notifier)resource);
        }

        protected void unsetTarget(Resource resource) {
            this.basicUnsetTarget((Notifier)resource);
        }
    };

    public JsdlEditor() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(new ResourceItemProviderAdapterFactory());
        arrayList.add((Object)new JsdlAdaptersFactory());
        arrayList.add((Object)new PosixAdaptersFactory());
        arrayList.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(arrayList);
        BasicCommandStack basicCommandStack = new BasicCommandStack();
        basicCommandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject eventObject) {
                Composite composite = JsdlEditor.this.getContainer();
                composite.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        JsdlEditor.this.firePropertyChange(257);
                    }
                });
            }
        });
        this.editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, (CommandStack)basicCommandStack, new HashMap());
    }

    protected void cleanDirtyState() {
        this.overviewPage.setDirty(false);
        this.jobDefPage.setDirty(false);
        this.jobApplicationPage.setDirty(false);
        this.resourcesPage.setDirty(false);
        this.dataStagingPage.setDirty(false);
    }

    public void setDirty(boolean bl) {
        if (this.isDirtyFlag != bl) {
            this.isDirtyFlag = bl;
            this.editorDirtyStateChanged();
        }
    }

    protected void addPages() {
        this.getJsdlModel();
        try {
            this.addPage((IFormPage)this.overviewPage);
            this.addPage((IFormPage)this.jobDefPage);
            this.addPage((IFormPage)this.jobApplicationPage);
            this.addPage((IFormPage)this.dataStagingPage);
            this.addPage((IFormPage)this.resourcesPage);
            this.addResourceEditorPage();
            this.pushContentToPages();
        }
        catch (PartInitException partInitException) {
            Activator.logException(partInitException);
        }
    }

    private void pushContentToPages() {
        this.overviewPage.setPageContent((EObject)this.jobDefType, this.isModelRefreshed());
        this.jobDefPage.setPageContent((EObject)this.jobDefType, this.isModelRefreshed());
        this.jobApplicationPage.setPageContent((EObject)this.jobDefType, this.isModelRefreshed());
        this.resourcesPage.setPageContent((EObject)this.jobDefType, this.isModelRefreshed());
        this.dataStagingPage.setPageContent((EObject)this.jobDefType, this.isModelRefreshed());
    }

    public boolean isModelRefreshed() {
        return this.refreshedModel;
    }

    private void addResourceEditorPage() throws PartInitException {
        this.sourcePageIndex = this.addPage((IEditorPart)this.getSourceEditor(), this.getEditorInput());
        this.setPageText(this.sourcePageIndex, this.getEditorInput().getName());
        this.getSourceEditor().setInput(this.getEditorInput());
    }

    private TextEditor getSourceEditor() {
        if (this.editor == null) {
            this.editor = new TextEditor();
        }
        return this.editor;
    }

    public void init(IEditorSite iEditorSite, IEditorInput iEditorInput) {
        this.setSite((IWorkbenchPartSite)iEditorSite);
        this.setInputWithNotify(iEditorInput);
        this.setPartName(iEditorInput.getName());
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener, 1);
    }

    protected void handleActivate() {
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
        if (!this.removedResources.isEmpty()) {
            if (this.handleDirtyConflict()) {
                this.getSite().getPage().closeEditor((IEditorPart)this, false);
                this.dispose();
            } else {
                this.removedResources.clear();
                this.changedResources.clear();
                this.savedResources.clear();
            }
        } else if (!this.changedResources.isEmpty()) {
            this.changedResources.removeAll(this.savedResources);
            this.handleChangedResources();
            this.changedResources.clear();
            this.savedResources.clear();
        }
    }

    protected void handleChangedResources() {
        if (!(this.changedResources.isEmpty() || this.isDirty() && !this.handleDirtyConflict())) {
            this.editingDomain.getCommandStack().flush();
            this.updateProblemIndication = false;
            for (Resource resource : this.changedResources) {
                if (!resource.isLoaded()) continue;
                resource.unload();
                try {
                    resource.load(Collections.EMPTY_MAP);
                }
                catch (IOException iOException) {
                    if (this.resourceToDiagnosticMap.containsKey(resource)) continue;
                    this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, iOException));
                }
            }
            this.updateProblemIndication = true;
            this.updateProblemIndication();
            this.getJsdlModel();
        }
    }

    protected boolean handleDirtyConflict() {
        return MessageDialog.openQuestion((Shell)this.getSite().getShell(), (String)"JsdlEditor_FileConflict_label", (String)"JsdlEditor_WARN_FileConflict");
    }

    public ISelection getSelection() {
        return this.editorSelection;
    }

    public void setSelection(ISelection iSelection) {
        this.editorSelection = iSelection;
    }

    public void doSave(IProgressMonitor iProgressMonitor) {
        WorkspaceModifyOperation workspaceModifyOperation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor iProgressMonitor) {
                boolean bl = true;
                for (Resource resource : JsdlEditor.this.editingDomain.getResourceSet().getResources()) {
                    if (!bl && resource.getContents().isEmpty() && !JsdlEditor.this.isPersisted(resource) || JsdlEditor.this.editingDomain.isReadOnly(resource)) continue;
                    try {
                        JsdlEditor.this.savedResources.add(resource);
                        resource.save(Collections.EMPTY_MAP);
                    }
                    catch (Exception exception) {
                        JsdlEditor.this.resourceToDiagnosticMap.put(resource, JsdlEditor.this.analyzeResourceProblems(resource, exception));
                        JsdlEditor.this.doTextEditorSave();
                        JsdlEditor.this.cleanDirtyState();
                        JsdlEditor.this.refreshEditor();
                    }
                    bl = false;
                }
            }
        };
        this.updateProblemIndication = false;
        try {
            new ProgressMonitorDialog(this.getSite().getShell()).run(true, false, (IRunnableWithProgress)workspaceModifyOperation);
            ((BasicCommandStack)this.editingDomain.getCommandStack()).saveIsDone();
            this.doTextEditorSave();
            this.cleanDirtyState();
            this.refreshEditor();
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        this.updateProblemIndication = true;
        this.updateProblemIndication();
    }

    public void doSaveAs() {
        IFile iFile;
        SaveAsDialog saveAsDialog = new SaveAsDialog(this.getSite().getShell());
        saveAsDialog.open();
        IPath iPath = saveAsDialog.getResult();
        if (iPath != null && (iFile = ResourcesPlugin.getWorkspace().getRoot().getFile(iPath)) != null) {
            this.doSaveAs(URI.createPlatformResourceURI((String)iFile.getFullPath().toString(), (boolean)false), (IEditorInput)new FileEditorInput(iFile));
        }
    }

    protected void doSaveAs(URI uRI, IEditorInput iEditorInput) {
        ((Resource)this.editingDomain.getResourceSet().getResources().get(0)).setURI(uRI);
        this.setInputWithNotify(iEditorInput);
        this.setPartName(iEditorInput.getName());
        NullProgressMonitor nullProgressMonitor = new NullProgressMonitor();
        this.doSave((IProgressMonitor)nullProgressMonitor);
    }

    protected void doTextEditorSave() {
        this.editor.doSave(null);
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    protected void updateProblemIndication() {
        if (this.updateProblemIndication) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(0, "eu.geclipse.jsdl.ui", 0, null, new Object[]{this.editingDomain.getResourceSet()});
            for (Diagnostic diagnostic : this.resourceToDiagnosticMap.values()) {
                if (diagnostic.getSeverity() == 0) continue;
                basicDiagnostic.add(diagnostic);
            }
            int n = this.getPageCount() - 1;
            if (n >= 0 && this.getEditor(n) instanceof ProblemEditorPart) {
                ((ProblemEditorPart)this.getEditor(n)).setDiagnostic((Diagnostic)basicDiagnostic);
                if (basicDiagnostic.getSeverity() != 0) {
                    this.setActivePage(n);
                }
            } else if (basicDiagnostic.getSeverity() != 0) {
                Diagnostic diagnostic;
                diagnostic = new ProblemEditorPart();
                diagnostic.setDiagnostic((Diagnostic)basicDiagnostic);
                diagnostic.setMarkerHelper(this.markerHelper);
                try {
                    this.addPage(++n, (IEditorPart)diagnostic, this.getEditorInput());
                    this.setPageText(n, diagnostic.getPartName());
                    this.setActivePage(n);
                }
                catch (PartInitException partInitException) {
                    Activator.logException(partInitException);
                }
            }
            if (this.markerHelper.hasMarkers((Object)this.editingDomain.getResourceSet())) {
                this.markerHelper.deleteMarkers((Object)this.editingDomain.getResourceSet());
                if (basicDiagnostic.getSeverity() != 0) {
                    try {
                        this.markerHelper.createMarkers((Diagnostic)basicDiagnostic);
                    }
                    catch (CoreException coreException) {
                        Activator.logException(coreException);
                    }
                }
            }
        }
    }

    public void getJsdlModel() {
        IFileEditorInput iFileEditorInput = (IFileEditorInput)this.getEditorInput();
        URI uRI = URI.createPlatformResourceURI((String)iFileEditorInput.getFile().getFullPath().toString(), (boolean)false);
        Exception exception = null;
        Resource resource = null;
        try {
            resource = this.editingDomain.getResourceSet().getResource(uRI, true);
        }
        catch (Exception exception2) {
            exception = exception2;
            resource = this.editingDomain.getResourceSet().getResource(uRI, false);
        }
        Diagnostic diagnostic = this.analyzeResourceProblems(resource, exception);
        if (diagnostic.getSeverity() != 0) {
            this.resourceToDiagnosticMap.put(resource, this.analyzeResourceProblems(resource, exception));
        }
        this.editingDomain.getResourceSet().eAdapters().add((Object)this.problemIndicationAdapter);
        this.getResourceRoot(resource);
        if (!this.changedResources.isEmpty()) {
            this.refreshEditor();
        }
    }

    protected void refreshEditor() {
        this.refreshedModel = true;
        this.pushContentToPages();
        this.refreshedModel = false;
    }

    private void getResourceRoot(Resource resource) {
        TreeIterator treeIterator = resource.getAllContents();
        while (treeIterator.hasNext()) {
            EObject eObject = (EObject)treeIterator.next();
            if (!(eObject instanceof JobDefinitionType)) continue;
            this.jobDefType = (JobDefinitionType)eObject;
        }
    }

    public Diagnostic analyzeResourceProblems(Resource resource, Exception exception) {
        if (!resource.getErrors().isEmpty() || !resource.getWarnings().isEmpty()) {
            BasicDiagnostic basicDiagnostic = new BasicDiagnostic(4, "eu.geclipse.jsdl.ui", 0, Messages.getString("JsdlMultiPageEditor.CreateModelErrorMessage"), new Object[]{exception == null ? resource : exception});
            basicDiagnostic.merge(EcoreUtil.computeDiagnostic((Resource)resource, (boolean)true));
            return basicDiagnostic;
        }
        if (exception != null) {
            return new BasicDiagnostic(4, "eu.geclipse.jsdl.ui", 0, Messages.getString("JsdlMultiPageEditor.CreateModelErrorMessage"), new Object[]{exception});
        }
        return Diagnostic.OK_INSTANCE;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    protected boolean isPersisted(Resource resource) {
        boolean bl = false;
        try {
            InputStream inputStream = this.editingDomain.getResourceSet().getURIConverter().createInputStream(resource.getURI());
            if (inputStream != null) {
                bl = true;
                inputStream.close();
            }
        }
        catch (IOException iOException) {}
        return bl;
    }

    protected void pageChange(int n) {
        super.pageChange(n);
    }
}

