/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.core.model.IGridComputing;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;

public class CandidateHostsDialog
extends Dialog {
    protected CheckboxTableViewer hostsViewer = null;
    protected Composite panel = null;
    protected String title = null;
    protected List<MultipleInputDialog.Validator> validators = new ArrayList<MultipleInputDialog.Validator>();
    private IGridElement gridElement = null;
    private JSDLJobDescription jobDescription = null;
    private List<String> existingHosts = new ArrayList<String>();
    private String[] selectedHosts = null;

    public CandidateHostsDialog(Shell shell, String string) {
        super(shell);
        this.title = string;
        this.setShellStyle(this.getShellStyle() | 0x10 | 0x10000);
    }

    protected void configureShell(Shell shell) {
        shell.setSize(600, 300);
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.getButton(0).setEnabled(false);
        return control;
    }

    private void enableOKButton(boolean bl) {
        this.getButton(0).setEnabled(bl);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.panel = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.panel.setLayout((Layout)gridLayout);
        this.panel.setLayoutData((Object)new GridData(768));
        Label label = new Label(this.panel, 0);
        label.setText(Messages.getString("ResourcesPage_NewHostsDialogDescr"));
        label.setLayoutData((Object)new GridData(32));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalSpan = 3;
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        gridData.heightHint = 100;
        Table table = new Table(this.panel, 2848);
        table.setLayoutData((Object)gridData);
        this.hostsViewer = new CheckboxTableViewer(table);
        this.hostsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.hostsViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        this.hostsViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent checkStateChangedEvent) {
                CandidateHostsDialog.this.setValue(CandidateHostsDialog.this.hostsViewer.getCheckedElements());
            }
        });
        try {
            ArrayList<String> arrayList = new ArrayList<String>();
            IGridComputing[] iGridComputingArray = this.jobDescription.getProject().getVO().getComputing();
            int n = 0;
            while (n < iGridComputingArray.length) {
                if (this.existingHosts != null) {
                    if (!this.existingHosts.contains(iGridComputingArray[n].getName())) {
                        arrayList.add(iGridComputingArray[n].getName());
                    }
                } else {
                    arrayList.add(iGridComputingArray[n].getName());
                }
                ++n;
            }
            this.hostsViewer.setInput(arrayList);
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
        Dialog.applyDialogFont((Control)composite2);
        return composite;
    }

    protected void okPressed() {
        super.okPressed();
    }

    public int open() {
        CandidateHostsDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.CANDIDATE_HOSTS_DIALOG";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getDialogSettingsSectionName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getDialogSettingsSectionName());
        }
        return iDialogSettings2;
    }

    public void setDialogInput(IGridElement iGridElement) {
        this.gridElement = iGridElement;
        this.getJobDescription(this.gridElement);
    }

    public void setExistingCandidateHosts(Object object) {
        this.existingHosts = (List)object;
    }

    protected void setValue(Object[] objectArray) {
        Object[] objectArray2 = objectArray;
        if (objectArray2 != null && objectArray2.length > 0) {
            this.enableOKButton(true);
            this.selectedHosts = new String[objectArray2.length];
            int n = 0;
            while (n < objectArray2.length) {
                this.selectedHosts[n] = (String)objectArray2[n];
                ++n;
            }
        } else {
            this.enableOKButton(false);
        }
    }

    public Object[] getValue() {
        return this.selectedHosts;
    }

    private JSDLJobDescription getJobDescription(IGridElement iGridElement) {
        this.jobDescription = iGridElement instanceof JSDLJobDescription ? (JSDLJobDescription)iGridElement : null;
        return this.jobDescription;
    }
}

