/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.dialogs;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.Messages;
import eu.geclipse.ui.dialogs.GridFileDialog;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.widgets.StoredCombo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MultipleInputDialog
extends Dialog {
    protected static final String FIELD_NAME = "FIELD_NAME";
    protected static final int TEXT = 100;
    protected static final int BROWSE = 101;
    protected static final int VARIABLE = 102;
    protected static final int COMBO = 103;
    protected Composite panel;
    protected List<FieldSummary> fieldList = new ArrayList<FieldSummary>();
    protected List<Text> controlList = new ArrayList<Text>();
    protected List<Validator> validators = new ArrayList<Validator>();
    protected List<Combo> combosList = new ArrayList<Combo>();
    protected Map<Object, String> valueMap = new HashMap<Object, String>();
    protected Map<String, ArrayList<String>> combosData = new HashMap<String, ArrayList<String>>();
    private String title;
    private Map<String, String> connectedFields = new HashMap<String, String>();

    public MultipleInputDialog(Shell shell, String string) {
        super(shell);
        this.title = string;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    protected Control createButtonBar(Composite composite) {
        Control control = super.createButtonBar(composite);
        this.validateFields();
        return control;
    }

    public void addBrowseField(String string, String string2, boolean bl, boolean bl2) {
        this.fieldList.add(new FieldSummary(101, string, string2, bl, bl2));
    }

    public void addComboField(String string, ArrayList<String> arrayList, String string2) {
        this.combosData.put(string, arrayList);
        this.fieldList.add(new FieldSummary(103, string, string2, false));
    }

    private boolean checkReadyToConnect(String string, int n) {
        boolean bl = false;
        if (this.connectedFields.containsKey(string)) {
            String string2 = this.connectedFields.get(string);
            int n2 = this.fieldList.size();
            int n3 = 0;
            while (n3 < n) {
                if (this.fieldList.get((int)n3).name.equals(string2)) {
                    n2 = n3;
                }
                ++n3;
            }
            if (n2 < n) {
                bl = true;
            }
        } else if (this.connectedFields.containsValue(string)) {
            String string3 = "";
            for (String string4 : this.connectedFields.keySet()) {
                if (!this.connectedFields.get(string4).equals(string)) continue;
                string3 = string4;
            }
            int n4 = this.fieldList.size();
            int n5 = 0;
            while (n5 < n) {
                if (this.fieldList.get((int)n5).name.equals(string3)) {
                    n4 = n5;
                }
                ++n5;
            }
            if (n4 < n) {
                bl = true;
            }
        }
        return bl;
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        composite2.setLayout((Layout)new GridLayout(2, false));
        composite2.setLayoutData((Object)new GridData(1808));
        this.panel = new Composite(composite2, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        this.panel.setLayout((Layout)gridLayout);
        this.panel.setLayoutData((Object)new GridData(768));
        for (FieldSummary fieldSummary : this.fieldList) {
            boolean bl = this.checkReadyToConnect(fieldSummary.name, this.fieldList.indexOf(fieldSummary));
            switch (fieldSummary.type) {
                case 100: {
                    this.createTextField(fieldSummary.name, fieldSummary.initialValue, fieldSummary.allowsEmpty, bl);
                    break;
                }
                case 101: {
                    this.createBrowseField(fieldSummary.name, fieldSummary.initialValue, fieldSummary.allowsEmpty, bl, fieldSummary.allowLocal);
                    break;
                }
                case 102: {
                    this.createVariablesField(fieldSummary.name, fieldSummary.initialValue, fieldSummary.allowsEmpty);
                    break;
                }
                case 103: {
                    this.createComboField(fieldSummary.name, fieldSummary.initialValue, fieldSummary.allowsEmpty);
                }
            }
        }
        this.fieldList = null;
        Dialog.applyDialogFont((Control)composite2);
        return composite2;
    }

    public void validateFields() {
        for (Validator validator : this.validators) {
            if (validator.validate()) continue;
            this.getButton(0).setEnabled(false);
            return;
        }
        this.getButton(0).setEnabled(true);
    }

    protected void createTextField(String string, String string2, boolean bl, boolean bl2) {
        Label label = new Label(this.panel, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(32));
        final Text text = new Text(this.panel, 2052);
        text.setLayoutData((Object)new GridData(768));
        text.setData(FIELD_NAME, (Object)string);
        label.setSize(label.getSize().x, text.getSize().y);
        if (string2 != null) {
            text.setText(string2);
        }
        if (!bl) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add(text);
        if (bl2) {
            if (this.connectedFields.containsKey(string)) {
                int control;
                String string3 = this.connectedFields.get(string);
                Text text2 = null;
                int n = -1;
                int n2 = -1;
                for (Control n3 : this.controlList) {
                    if (n3.getData(FIELD_NAME).equals(string3)) {
                        text2 = (Text)n3;
                        n = this.controlList.indexOf(n3);
                        continue;
                    }
                    if (!n3.getData(FIELD_NAME).equals(string)) continue;
                    control = this.controlList.indexOf(n3);
                }
                void var11_22 = control;
                final int n3 = n;
                text2.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent modifyEvent) {
                    }
                });
                text2.addFocusListener(new FocusListener((int)var11_22){
                    private final /* synthetic */ int val$targetPosition;
                    {
                        this.val$targetPosition = n2;
                    }

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        String string = "";
                        Path path = new Path(MultipleInputDialog.this.controlList.get(n3).getText());
                        string = path.lastSegment();
                        if (MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText() != null && MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText().length() == 0) {
                            MultipleInputDialog.this.controlList.get(this.val$targetPosition).setText(string);
                        }
                    }
                });
            } else {
                String string4 = null;
                for (String string5 : this.connectedFields.keySet()) {
                    if (!this.connectedFields.get(string5).equals(string)) continue;
                    string4 = string5;
                }
                int n = -1;
                int n5 = -1;
                for (Control n6 : this.controlList) {
                    if (n6.getData(FIELD_NAME).equals(string4)) {
                        Text cfr_ignored_0 = (Text)n6;
                        n5 = this.controlList.indexOf(n6);
                        continue;
                    }
                    if (!n6.getData(FIELD_NAME).equals(string)) continue;
                    n = this.controlList.indexOf(n6);
                }
                final int n4 = n;
                final int n6 = n5;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent modifyEvent) {
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        String string = "";
                        Path path = new Path(MultipleInputDialog.this.controlList.get(n4).getText());
                        string = path.lastSegment();
                        if (MultipleInputDialog.this.controlList.get(n6).getText() != null && MultipleInputDialog.this.controlList.get(n6).getText().length() == 0) {
                            MultipleInputDialog.this.controlList.get(n6).setText(string);
                        }
                    }
                });
            }
        }
    }

    public void setConnectedFields(String string, String string2) {
        this.connectedFields.put(string2, string);
    }

    protected void createBrowseField(String string, String string2, boolean bl, boolean bl2, final boolean bl3) {
        Label label = new Label(this.panel, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(32));
        Composite composite = new Composite(this.panel, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        final Text text = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        text.setLayoutData((Object)gridData);
        text.setData(FIELD_NAME, (Object)string);
        label.setSize(label.getSize().x, text.getSize().y);
        if (string2 != null) {
            text.setText(string2);
        }
        if (!bl) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        Button button = this.createButton(composite, 9, Messages.getString("MultilpeInputDialog.browse_button"), false);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                IGridConnectionElement iGridConnectionElement = GridFileDialog.openFileDialog((Shell)MultipleInputDialog.this.getShell(), (String)"Choose a file", null, (boolean)bl3);
                if (iGridConnectionElement != null) {
                    try {
                        String string = iGridConnectionElement.getConnectionFileStore().toString();
                        if (iGridConnectionElement.getConnectionFileStore().getFileSystem().getScheme().equalsIgnoreCase("file")) {
                            string = "file://" + string;
                        }
                        if (string != null) {
                            text.setText(string);
                        }
                    }
                    catch (CoreException coreException) {
                        NewProblemDialog.openProblem((Shell)MultipleInputDialog.this.getShell(), (String)"error", (String)"error", (Throwable)coreException);
                    }
                }
            }
        });
        this.controlList.add(text);
        if (bl2) {
            if (this.connectedFields.containsKey(string)) {
                int control;
                String string3 = this.connectedFields.get(string);
                Text text2 = null;
                int n = -1;
                int n2 = -1;
                for (Control n3 : this.controlList) {
                    if (n3.getData(FIELD_NAME).equals(string3)) {
                        text2 = (Text)n3;
                        n = this.controlList.indexOf(n3);
                        continue;
                    }
                    if (!n3.getData(FIELD_NAME).equals(string)) continue;
                    control = this.controlList.indexOf(n3);
                }
                void var16_27 = control;
                final int n3 = n;
                if (text2 != null) {
                    text2.addModifyListener(new ModifyListener(){

                        public void modifyText(ModifyEvent modifyEvent) {
                        }
                    });
                    text2.addFocusListener(new FocusListener((int)var16_27){
                        private final /* synthetic */ int val$targetPosition;
                        {
                            this.val$targetPosition = n2;
                        }

                        public void focusGained(FocusEvent focusEvent) {
                        }

                        public void focusLost(FocusEvent focusEvent) {
                            String string = "";
                            Path path = new Path(MultipleInputDialog.this.controlList.get(n3).getText());
                            string = path.lastSegment();
                            if (MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText() != null && MultipleInputDialog.this.controlList.get(this.val$targetPosition).getText().length() == 0) {
                                MultipleInputDialog.this.controlList.get(this.val$targetPosition).setText(string);
                            }
                        }
                    });
                }
            } else {
                String string4 = null;
                for (String string5 : this.connectedFields.keySet()) {
                    if (!this.connectedFields.get(string5).equals(string)) continue;
                    string4 = string5;
                }
                int n = -1;
                int n5 = -1;
                for (Control n6 : this.controlList) {
                    if (n6.getData(FIELD_NAME).equals(string4)) {
                        n5 = this.controlList.indexOf(n6);
                        continue;
                    }
                    if (!n6.getData(FIELD_NAME).equals(string)) continue;
                    n = this.controlList.indexOf(n6);
                }
                final int n4 = n;
                final int n6 = n5;
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent modifyEvent) {
                    }
                });
                text.addFocusListener(new FocusListener(){

                    public void focusGained(FocusEvent focusEvent) {
                    }

                    public void focusLost(FocusEvent focusEvent) {
                        String string = "";
                        Path path = new Path(MultipleInputDialog.this.controlList.get(n4).getText());
                        string = path.lastSegment();
                        if (MultipleInputDialog.this.controlList.get(n6).getText() != null && MultipleInputDialog.this.controlList.get(n6).getText().length() == 0) {
                            MultipleInputDialog.this.controlList.get(n6).setText(string);
                        }
                    }
                });
            }
        }
    }

    public void createVariablesField(String string, String string2, boolean bl) {
        Label label = new Label(this.panel, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(32));
        Composite composite = new Composite(this.panel, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        final Text text = new Text(composite, 2052);
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        text.setLayoutData((Object)gridData);
        text.setData(FIELD_NAME, (Object)string);
        label.setSize(label.getSize().x, text.getSize().y);
        if (string2 != null) {
            text.setText(string2);
        }
        if (!bl) {
            this.validators.add(new Validator(){

                public boolean validate() {
                    return !text.getText().equals("");
                }
            });
            text.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.controlList.add(text);
    }

    protected void createComboField(String string, String string2, boolean bl) {
        Label label = new Label(this.panel, 0);
        label.setText(string);
        label.setLayoutData((Object)new GridData(32));
        Composite composite = new Composite(this.panel, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite.setLayout((Layout)gridLayout);
        composite.setLayoutData((Object)new GridData(768));
        StoredCombo storedCombo = new StoredCombo(composite, 2052);
        for (String string3 : this.combosData.get(string)) {
            storedCombo.add(string3);
        }
        if (string2 != null) {
            int n = 0;
            while (n < storedCombo.getItemCount()) {
                if (storedCombo.getItem(n).equals(string2)) {
                    storedCombo.select(n);
                }
                ++n;
            }
        } else {
            storedCombo.select(0);
        }
        GridData gridData = new GridData(768);
        gridData.widthHint = 200;
        storedCombo.setLayoutData((Object)gridData);
        storedCombo.setData(FIELD_NAME, (Object)string);
        label.setSize(label.getSize().x, storedCombo.getSize().y);
        if (string2 != null) {
            storedCombo.setText(string2);
        }
        if (!bl) {
            this.validators.add(new Validator((Combo)storedCombo){
                private final /* synthetic */ Combo val$combo;
                {
                    this.val$combo = combo;
                }

                public boolean validate() {
                    return !this.val$combo.getText().equals("");
                }
            });
            storedCombo.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent modifyEvent) {
                    MultipleInputDialog.this.validateFields();
                }
            });
        }
        this.combosList.add((Combo)storedCombo);
    }

    protected void okPressed() {
        for (Control control : this.controlList) {
            if (!(control instanceof Text)) continue;
            this.valueMap.put(control.getData(FIELD_NAME), ((Text)control).getText());
        }
        for (Control control : this.combosList) {
            if (!(control instanceof Combo)) continue;
            this.valueMap.put(control.getData(FIELD_NAME), ((Combo)control).getText());
        }
        this.controlList = null;
        this.combosList = null;
        super.okPressed();
    }

    public int open() {
        MultipleInputDialog.applyDialogFont((Control)this.panel);
        return super.open();
    }

    public Object getValue(String string) {
        return this.valueMap.get(string);
    }

    public String getStringValue(String string) {
        return (String)this.getValue(string);
    }

    private String getDialogSettingsSectionName() {
        return "org.eclipse.debug.ui.MULTIPLE_INPUT_DIALOG_2";
    }

    protected IDialogSettings getDialogBoundsSettings() {
        IDialogSettings iDialogSettings = Activator.getDefault().getDialogSettings();
        IDialogSettings iDialogSettings2 = iDialogSettings.getSection(this.getDialogSettingsSectionName());
        if (iDialogSettings2 == null) {
            iDialogSettings2 = iDialogSettings.addNewSection(this.getDialogSettingsSectionName());
        }
        return iDialogSettings2;
    }

    public void addTextField(String string, String string2, boolean bl) {
        this.fieldList.add(new FieldSummary(100, string, string2, bl));
    }

    public void addVariablesField(String string, String string2, boolean bl) {
        this.fieldList.add(new FieldSummary(102, string, string2, bl));
    }

    protected class FieldSummary {
        int type;
        String name;
        String initialValue;
        boolean allowsEmpty;
        boolean allowLocal;

        public FieldSummary(int n, String string, String string2, boolean bl) {
            this(n, string, string2, bl, true);
        }

        public FieldSummary(int n, String string, String string2, boolean bl, boolean bl2) {
            this.type = n;
            this.name = string;
            this.initialValue = string2;
            this.allowsEmpty = bl;
            this.allowLocal = bl2;
        }
    }

    protected class Validator {
        protected Validator() {
        }

        boolean validate() {
            return true;
        }
    }
}

