/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages;

import eu.geclipse.jsdl.model.DataStagingType;
import eu.geclipse.jsdl.ui.adapters.jsdl.DataStageTypeAdapter;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.FormLayoutFactory;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.providers.DataStageInLabelProvider;
import eu.geclipse.jsdl.ui.providers.DataStageOutLabelProvider;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import eu.geclipse.jsdl.ui.widgets.DataStagingInDialog;
import eu.geclipse.jsdl.ui.widgets.DataStagingOutDialog;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class DataStagingPage
extends FormPage
implements INotifyChangedListener {
    protected Composite body = null;
    protected Composite stageInSection = null;
    protected Composite stageOutSection = null;
    protected List lstStageInFileName = null;
    protected Text txtStageInFileSystemName = null;
    protected Text txtSource = null;
    protected Text txtTarget = null;
    protected Text txtStageInName = null;
    protected Label lblStageInFileName = null;
    protected Label lblStageInFileSystemName = null;
    protected Label lblCreationFlag = null;
    protected Label lblDelOnTerm = null;
    protected Label lblSource = null;
    protected Label lblTarget = null;
    protected Label lblStageInName = null;
    protected Button btnStageInAdd = null;
    protected Button btnStageInEdit = null;
    protected Button btnStageInDel = null;
    protected Button btnStageOutAdd = null;
    protected Button btnStageOutEdit = null;
    protected Button btnStageOutDel = null;
    protected Combo cmbCreationFlag = null;
    protected Combo cmbDelOnTerm = null;
    protected Table tblStageIn = null;
    protected Table tblStageOut = null;
    protected TableViewer stageInViewer = null;
    protected TableViewer stageOutViewer = null;
    protected Object[] value = null;
    protected DataStageTypeAdapter dataStageTypeAdapter;
    protected FeatureContentProvider featureContentProvider = new FeatureContentProvider();
    protected FeatureLabelProvider featureLabelProvider = new FeatureLabelProvider();
    private ImageDescriptor helpDesc = null;
    private TableColumn column;
    private final int WIDGET_HEIGHT = 100;
    private boolean contentRefreshed = false;
    private boolean dirtyFlag = false;

    public DataStagingPage(FormEditor formEditor) {
        super(formEditor, "", Messages.getString("DataStagingPage_PageTitle"));
    }

    public void notifyChanged(Notification notification) {
        this.setDirty(true);
    }

    public void setDirty(boolean bl) {
        if (this.dirtyFlag != bl) {
            this.dirtyFlag = bl;
            this.getEditor().editorDirtyStateChanged();
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void setActive(boolean bl) {
        if (bl && this.isContentRefreshed()) {
            this.dataStageTypeAdapter.load();
        }
    }

    private boolean isContentRefreshed() {
        return this.contentRefreshed;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(Messages.getString("DataStagingPage_DataStagingPageTitle"));
        this.body = scrolledForm.getBody();
        this.body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(false, 2));
        this.stageInSection = formToolkit.createComposite(this.body);
        this.stageInSection.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.stageInSection.setLayoutData((Object)new TableWrapData(256));
        this.createStageInSection(this.stageInSection, formToolkit);
        this.stageOutSection = formToolkit.createComposite(this.body);
        this.stageOutSection.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.stageOutSection.setLayoutData((Object)new TableWrapData(256));
        this.createStageOutSection(this.stageInSection, formToolkit);
        this.dataStageTypeAdapter.load();
        this.addFormPageHelp(scrolledForm);
    }

    public void setPageContent(EObject eObject, boolean bl) {
        if (bl) {
            this.contentRefreshed = true;
            this.dataStageTypeAdapter.setContent(eObject);
        } else {
            this.dataStageTypeAdapter = new DataStageTypeAdapter(eObject);
            this.dataStageTypeAdapter.addListener(this);
        }
    }

    private void createStageInSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("DataStagingPage_StageInSection");
        String string2 = Messages.getString("DataStagingPage_StageInDescr");
        Composite composite2 = FormSectionFactory.createGridStaticSection(formToolkit, composite, string, string2, 3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 600;
        gridData.heightHint = 100;
        this.stageInViewer = new TableViewer(composite2, 67584);
        this.tblStageIn = this.stageInViewer.getTable();
        this.tblStageIn.setHeaderVisible(true);
        this.tblStageIn.setLinesVisible(true);
        this.stageInViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.stageInViewer.setLabelProvider((IBaseLabelProvider)new DataStageInLabelProvider());
        this.column = new TableColumn(this.tblStageIn, 16384);
        this.column.setText(Messages.getString("DataStagingPage_Source"));
        this.column.setWidth(200);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_FileName"));
        this.column.setWidth(150);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_CreationFlag"));
        this.column.setWidth(100);
        this.column = new TableColumn(this.tblStageIn, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_DeleteOnTermination"));
        this.column.setWidth(100);
        this.dataStageTypeAdapter.attachToStageIn(this.stageInViewer);
        this.stageInViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DataStagingPage.this.updateButtons((TableViewer)selectionChangedEvent.getSource());
            }
        });
        this.tblStageIn.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.tblStageIn.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        this.btnStageInAdd = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_AddButton"), 8);
        this.btnStageInAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataStagingPage.this.handleEventDialog(DataStagingPage.this.stageInViewer, null);
                DataStagingPage.this.dataStageTypeAdapter.performAdd(DataStagingPage.this.stageInViewer, DataStagingPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnStageInAdd.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        this.btnStageInEdit = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_EditButton"), 8);
        this.btnStageInEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataStagingPage.this.handleEventDialog(DataStagingPage.this.stageInViewer, DataStagingPage.this.getViewerSelectionObject(DataStagingPage.this.stageInViewer));
                DataStagingPage.this.dataStageTypeAdapter.performEdit(DataStagingPage.this.stageInViewer, DataStagingPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnStageInEdit.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        gridData.verticalAlignment = 1;
        this.btnStageInDel = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_RemoveButton"), 8);
        this.dataStageTypeAdapter.attachToDelete(this.btnStageInDel, this.stageInViewer);
        this.btnStageInDel.setLayoutData((Object)gridData);
        this.updateButtons(this.stageInViewer);
        formToolkit.paintBordersFor(composite2);
    }

    private void createStageOutSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("DataStagingPage_StageOutSection");
        String string2 = Messages.getString("DataStagingPage_StageOutDescr");
        Composite composite2 = FormSectionFactory.createGridStaticSection(formToolkit, composite, string, string2, 3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 4;
        gridData.verticalSpan = 3;
        gridData.horizontalSpan = 1;
        gridData.widthHint = 600;
        gridData.heightHint = 100;
        this.stageOutViewer = new TableViewer(composite2, 67584);
        this.tblStageOut = this.stageOutViewer.getTable();
        this.tblStageOut.setHeaderVisible(true);
        this.tblStageOut.setLinesVisible(true);
        this.stageOutViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.stageOutViewer.setLabelProvider((IBaseLabelProvider)new DataStageOutLabelProvider());
        this.column = new TableColumn(this.tblStageOut, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_FileName"));
        this.column.setWidth(150);
        this.column = new TableColumn(this.tblStageOut, 16384);
        this.column.setText(Messages.getString("DataStagingPage_Target"));
        this.column.setWidth(200);
        this.column = new TableColumn(this.tblStageOut, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_CreationFlag"));
        this.column.setWidth(100);
        this.column = new TableColumn(this.tblStageOut, 0x1000000);
        this.column.setText(Messages.getString("DataStagingPage_DeleteOnTermination"));
        this.column.setWidth(100);
        this.stageOutViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                DataStagingPage.this.updateButtons((TableViewer)selectionChangedEvent.getSource());
            }
        });
        this.dataStageTypeAdapter.attachToStageOut(this.stageOutViewer);
        this.tblStageOut.setData("FormWidgetFactory.drawBorder", (Object)"textBorder");
        this.tblStageOut.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        this.btnStageOutAdd = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_AddButton"), 8);
        this.btnStageOutAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataStagingPage.this.handleEventDialog(DataStagingPage.this.stageOutViewer, null);
                DataStagingPage.this.dataStageTypeAdapter.performAdd(DataStagingPage.this.stageOutViewer, DataStagingPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnStageOutAdd.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        this.btnStageOutEdit = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_EditButton"), 8);
        this.btnStageOutEdit.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DataStagingPage.this.handleEventDialog(DataStagingPage.this.stageOutViewer, DataStagingPage.this.getViewerSelectionObject(DataStagingPage.this.stageOutViewer));
                DataStagingPage.this.dataStageTypeAdapter.performEdit(DataStagingPage.this.stageOutViewer, DataStagingPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnStageOutEdit.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.verticalSpan = 1;
        gridData.widthHint = 60;
        gridData.verticalAlignment = 1;
        this.btnStageOutDel = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_RemoveButton"), 8);
        this.dataStageTypeAdapter.attachToDelete(this.btnStageOutDel, this.stageOutViewer);
        this.btnStageOutDel.setLayoutData((Object)gridData);
        this.updateButtons(this.stageOutViewer);
        formToolkit.paintBordersFor(composite2);
    }

    private void addFormPageHelp(final ScrolledForm scrolledForm) {
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)scrolledForm.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                        }
                    });
                }
            };
            action.setToolTipText(Messages.getString("DataStagingPage_Help"));
            URL uRL = Activator.getDefault().getBundle().getEntry("icons/help.gif");
            this.helpDesc = ImageDescriptor.createFromURL((URL)uRL);
            action.setImageDescriptor(this.helpDesc);
            iToolBarManager.add((IAction)action);
            scrolledForm.updateToolBar();
        }
    }

    protected String getHelpResource() {
        return "/eu.geclipse.doc.user/html/concepts/jobmanagement/editorpages/datastaging.html";
    }

    protected void updateButtons(TableViewer tableViewer) {
        boolean bl;
        ISelection iSelection = tableViewer.getSelection();
        boolean bl2 = bl = !iSelection.isEmpty();
        if (tableViewer == this.stageInViewer) {
            this.btnStageInAdd.setEnabled(true);
            this.btnStageInDel.setEnabled(bl);
            this.btnStageInEdit.setEnabled(bl);
        } else {
            this.btnStageOutAdd.setEnabled(true);
            this.btnStageOutDel.setEnabled(bl);
            this.btnStageOutEdit.setEnabled(bl);
        }
    }

    protected DataStagingType getViewerSelectionObject(TableViewer tableViewer) {
        DataStagingType dataStagingType = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)tableViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof DataStagingType) {
            dataStagingType = (DataStagingType)object;
        }
        return dataStagingType;
    }

    protected void handleEventDialog(TableViewer tableViewer, DataStagingType dataStagingType) {
        this.value = new Object[4];
        if (tableViewer == this.stageInViewer) {
            if (dataStagingType == null) {
                DataStagingInDialog dataStagingInDialog = new DataStagingInDialog(this.body.getShell(), 1);
                if (dataStagingInDialog.open() == 0) {
                    this.value[0] = dataStagingInDialog.getPath();
                    this.value[1] = dataStagingInDialog.getName();
                    this.value[2] = dataStagingInDialog.getCreationFlag();
                    this.value[3] = dataStagingInDialog.getDeleteOnTermination();
                }
            } else {
                DataStagingInDialog dataStagingInDialog = new DataStagingInDialog(this.body.getShell(), 1, dataStagingType.getFileName(), dataStagingType.getSource().getURI(), dataStagingType.getCreationFlag().toString(), dataStagingType.isDeleteOnTermination());
                if (dataStagingInDialog.open() == 0) {
                    this.value[0] = dataStagingInDialog.getPath();
                    this.value[1] = dataStagingInDialog.getName();
                    this.value[2] = dataStagingInDialog.getCreationFlag();
                    this.value[3] = dataStagingInDialog.getDeleteOnTermination();
                }
            }
        } else if (dataStagingType == null) {
            DataStagingOutDialog dataStagingOutDialog = new DataStagingOutDialog(this.body.getShell(), 1);
            if (dataStagingOutDialog.open() == 0) {
                this.value[0] = dataStagingOutDialog.getName();
                this.value[1] = dataStagingOutDialog.getPath();
                this.value[2] = dataStagingOutDialog.getCreationFlag();
                this.value[3] = dataStagingOutDialog.getDeleteOnTermination();
            }
        } else {
            DataStagingOutDialog dataStagingOutDialog = new DataStagingOutDialog(this.body.getShell(), 1, dataStagingType.getFileName(), dataStagingType.getTarget().getURI(), dataStagingType.getCreationFlag().toString(), dataStagingType.isDeleteOnTermination());
            if (dataStagingOutDialog.open() == 0) {
                this.value[0] = dataStagingOutDialog.getName();
                this.value[1] = dataStagingOutDialog.getPath();
                this.value[2] = dataStagingOutDialog.getCreationFlag();
                this.value[3] = dataStagingOutDialog.getDeleteOnTermination();
            }
        }
    }
}

