/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages;

import eu.geclipse.jsdl.ui.adapters.jsdl.ApplicationTypeAdapter;
import eu.geclipse.jsdl.ui.adapters.posix.PosixApplicationTypeAdapter;
import eu.geclipse.jsdl.ui.editors.JsdlEditor;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import java.net.URL;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormText;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.forms.widgets.TableWrapData;
import org.eclipse.ui.forms.widgets.TableWrapLayout;

public final class OverviewPage
extends FormPage
implements INotifyChangedListener,
IHyperlinkListener {
    protected static final String PAGE_ID = "OVERVIEW";
    protected ApplicationTypeAdapter applicationTypeAdapter;
    protected PosixApplicationTypeAdapter posixApplicationTypeAdapter;
    protected Composite composite = null;
    protected Label lblApplicationName = null;
    protected Label lblExecutable = null;
    protected Label lblInput = null;
    protected Label lblOutput = null;
    protected Label lblError = null;
    protected FormText sectionContent = null;
    protected Text txtApplicationName = null;
    protected Text txtExecutable = null;
    protected Text txtInput = null;
    protected Text txtOutput = null;
    protected Text txtError = null;
    private FormToolkit toolkit;
    private boolean contentRefreshed = false;
    private boolean dirtyFlag = false;
    private final int WIDGET_MAX_WIDTH = 100;
    private ImageDescriptor helpDesc;

    public OverviewPage(JsdlEditor jsdlEditor) {
        super((FormEditor)jsdlEditor, "", Messages.getString("OverviewPage_PageTitle"));
    }

    public void notifyChanged(Notification notification) {
        this.setDirty(true);
    }

    public void setActive(boolean bl) {
        if (bl && this.isContentRefreshed()) {
            this.applicationTypeAdapter.load();
            this.posixApplicationTypeAdapter.load();
        }
    }

    public void setDirty(boolean bl) {
        if (this.dirtyFlag != bl) {
            this.dirtyFlag = bl;
            this.getEditor().editorDirtyStateChanged();
        }
    }

    public void setPageContent(EObject eObject, boolean bl) {
        if (bl) {
            this.contentRefreshed = true;
            this.applicationTypeAdapter.setContent(eObject);
            this.posixApplicationTypeAdapter.setContent(eObject);
        } else {
            this.applicationTypeAdapter = new ApplicationTypeAdapter(eObject);
            this.applicationTypeAdapter.addListener(this);
            this.posixApplicationTypeAdapter = new PosixApplicationTypeAdapter(eObject);
            this.posixApplicationTypeAdapter.addListener(this);
        }
    }

    private boolean isContentRefreshed() {
        return this.contentRefreshed;
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        scrolledForm.setText(Messages.getString("OverviewPage_PageTitle"));
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.verticalSpacing = 8;
        tableWrapLayout.horizontalSpacing = 8;
        tableWrapLayout.leftMargin = 10;
        tableWrapLayout.rightMargin = 10;
        tableWrapLayout.topMargin = 10;
        tableWrapLayout.bottomMargin = 10;
        tableWrapLayout.numColumns = 2;
        tableWrapLayout.makeColumnsEqualWidth = false;
        scrolledForm.getBody().setLayout((Layout)tableWrapLayout);
        this.composite = this.createGeneralInfoSection(iManagedForm, Messages.getString("OverviewPage_GeneralInfoTitle"), Messages.getString("OverviewPage_GeneralInfoDescription"));
        this.applicationTypeAdapter.load();
        this.posixApplicationTypeAdapter.load();
        this.composite = this.createJobDefSection(iManagedForm, Messages.getString("OverviewPage_JobDefTitle"), Messages.getString("OverviewPage_JobDefDescription"));
        this.composite = this.createApplicationSection(iManagedForm, Messages.getString("OverviewPage_ApplicationTitle"), Messages.getString("OverviewPage_ApplicationDescription"));
        this.composite = this.createResourcesSection(iManagedForm, Messages.getString("OverviewPage_ResourcesTitle"), Messages.getString("OverviewPage_ResourcesDescription"));
        this.composite = this.createDataStageSection(iManagedForm, Messages.getString("OverviewPage_DataStagingTitle"), Messages.getString("OverviewPage_DataStagingDescription"));
        this.addFormPageHelp(scrolledForm);
    }

    protected String getHelpResource() {
        return "/eu.geclipse.doc.user/html/concepts/jobmanagement/editingJSDL.html";
    }

    private Composite createSection(IManagedForm iManagedForm, String string, String string2, int n) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        this.toolkit = iManagedForm.getToolkit();
        Section section = this.toolkit.createSection(scrolledForm.getBody(), 448);
        section.clientVerticalSpacing = 5;
        section.setText(string);
        section.setDescription(string2);
        this.toolkit.createCompositeSeparator((Composite)section);
        Composite composite = this.toolkit.createComposite((Composite)section);
        TableWrapLayout tableWrapLayout = new TableWrapLayout();
        tableWrapLayout.verticalSpacing = 8;
        tableWrapLayout.horizontalSpacing = 8;
        tableWrapLayout.leftMargin = 10;
        tableWrapLayout.rightMargin = 10;
        tableWrapLayout.topMargin = 10;
        tableWrapLayout.bottomMargin = 10;
        tableWrapLayout.numColumns = n;
        tableWrapLayout.makeColumnsEqualWidth = false;
        composite.setLayout((Layout)tableWrapLayout);
        TableWrapData tableWrapData = new TableWrapData(256);
        section.setLayoutData((Object)tableWrapData);
        section.setClient((Control)composite);
        return composite;
    }

    private Composite createGeneralInfoSection(IManagedForm iManagedForm, String string, String string2) {
        Composite composite = this.createSection(iManagedForm, string, string2, 2);
        this.lblApplicationName = this.toolkit.createLabel(composite, Messages.getString("OverviewPage_ApplName"));
        TableWrapData tableWrapData = new TableWrapData(256);
        tableWrapData.maxWidth = 100;
        this.txtApplicationName = this.toolkit.createText(composite, "", 0);
        this.applicationTypeAdapter.attachToApplicationName(this.txtApplicationName);
        this.txtApplicationName.setLayoutData((Object)tableWrapData);
        this.lblExecutable = this.toolkit.createLabel(composite, Messages.getString("OverviewPage_Executable"));
        tableWrapData = new TableWrapData(256);
        tableWrapData.maxWidth = 100;
        this.txtExecutable = this.toolkit.createText(composite, "", 0);
        this.posixApplicationTypeAdapter.attachPosixApplicationExecutable(this.txtExecutable);
        this.txtExecutable.setLayoutData((Object)tableWrapData);
        this.lblInput = this.toolkit.createLabel(composite, Messages.getString("OverviewPage_Input"));
        tableWrapData = new TableWrapData(256);
        tableWrapData.maxWidth = 100;
        this.txtInput = this.toolkit.createText(composite, "", 0);
        this.posixApplicationTypeAdapter.attachPosixApplicationInput(this.txtInput);
        this.txtInput.setLayoutData((Object)tableWrapData);
        this.lblOutput = this.toolkit.createLabel(composite, Messages.getString("OverviewPage_Output"));
        tableWrapData = new TableWrapData(256);
        tableWrapData.maxWidth = 100;
        this.txtOutput = this.toolkit.createText(composite, "", 0);
        this.posixApplicationTypeAdapter.attachPosixApplicationOutput(this.txtOutput);
        this.txtOutput.setLayoutData((Object)tableWrapData);
        this.lblError = this.toolkit.createLabel(composite, Messages.getString("OverviewPage_Error"));
        tableWrapData = new TableWrapData(256);
        tableWrapData.maxWidth = 100;
        this.txtError = this.toolkit.createText(composite, "", 0);
        this.posixApplicationTypeAdapter.attachPosixApplicationError(this.txtError);
        this.txtError.setLayoutData((Object)tableWrapData);
        this.toolkit.paintBordersFor(composite);
        return composite;
    }

    private Composite createJobDefSection(IManagedForm iManagedForm, String string, String string2) {
        Composite composite = this.createSection(iManagedForm, string, string2, 2);
        this.sectionContent = this.toolkit.createFormText(composite, true);
        try {
            this.sectionContent.setText(Messages.getString("OverviewPage_JobDefContent"), true, false);
        }
        catch (SWTException sWTException) {
            this.sectionContent.setText(sWTException.getMessage(), false, false);
        }
        this.sectionContent.addHyperlinkListener((IHyperlinkListener)this);
        return composite;
    }

    private Composite createApplicationSection(IManagedForm iManagedForm, String string, String string2) {
        Composite composite = this.createSection(iManagedForm, string, string2, 2);
        this.sectionContent = this.toolkit.createFormText(composite, true);
        try {
            this.sectionContent.setText(Messages.getString("OverviewPage_ApplicationContent"), true, false);
        }
        catch (SWTException sWTException) {
            this.sectionContent.setText(sWTException.getMessage(), false, false);
        }
        this.sectionContent.addHyperlinkListener((IHyperlinkListener)this);
        return composite;
    }

    private Composite createResourcesSection(IManagedForm iManagedForm, String string, String string2) {
        Composite composite = this.createSection(iManagedForm, string, string2, 2);
        this.sectionContent = this.toolkit.createFormText(composite, true);
        try {
            this.sectionContent.setText(Messages.getString("OverviewPage_ResourcesContent"), true, false);
        }
        catch (SWTException sWTException) {
            this.sectionContent.setText(sWTException.getMessage(), false, false);
        }
        this.sectionContent.addHyperlinkListener((IHyperlinkListener)this);
        return composite;
    }

    private Composite createDataStageSection(IManagedForm iManagedForm, String string, String string2) {
        Composite composite = this.createSection(iManagedForm, string, string2, 2);
        this.sectionContent = this.toolkit.createFormText(composite, true);
        try {
            this.sectionContent.setText(Messages.getString("OverviewPage_DataStagingContent"), true, false);
        }
        catch (SWTException sWTException) {
            this.sectionContent.setText(sWTException.getMessage(), false, false);
        }
        this.sectionContent.addHyperlinkListener((IHyperlinkListener)this);
        return composite;
    }

    public void linkActivated(HyperlinkEvent hyperlinkEvent) {
        String string = (String)hyperlinkEvent.getHref();
        this.getEditor().setActivePage(string);
    }

    public void linkEntered(HyperlinkEvent hyperlinkEvent) {
        IStatusLineManager iStatusLineManager = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        iStatusLineManager.setMessage(hyperlinkEvent.getLabel());
    }

    public void linkExited(HyperlinkEvent hyperlinkEvent) {
        IStatusLineManager iStatusLineManager = this.getEditor().getEditorSite().getActionBars().getStatusLineManager();
        iStatusLineManager.setMessage(null);
    }

    private void addFormPageHelp(final ScrolledForm scrolledForm) {
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)scrolledForm.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                        }
                    });
                }
            };
            action.setToolTipText(Messages.getString("OverviewPage_Help"));
            URL uRL = Activator.getDefault().getBundle().getEntry("icons/help.gif");
            this.helpDesc = ImageDescriptor.createFromURL((URL)uRL);
            action.setImageDescriptor(this.helpDesc);
            iToolBarManager.add((IAction)action);
            scrolledForm.updateToolBar();
        }
    }
}

