/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.pages;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridRoot;
import eu.geclipse.jsdl.ui.adapters.jsdl.ResourcesTypeAdapter;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.dialogs.CandidateHostsDialog;
import eu.geclipse.jsdl.ui.internal.pages.FormLayoutFactory;
import eu.geclipse.jsdl.ui.internal.pages.FormSectionFactory;
import eu.geclipse.jsdl.ui.internal.pages.Messages;
import eu.geclipse.jsdl.ui.providers.FeatureContentProvider;
import eu.geclipse.jsdl.ui.providers.FeatureLabelProvider;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.INotifyChangedListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.editor.FormPage;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.forms.widgets.TableWrapData;

public final class ResourcesPage
extends FormPage
implements INotifyChangedListener {
    protected static final String PAGE_ID = "RESOURCES";
    protected ResourcesTypeAdapter resourcesTypeAdapter;
    protected Object[] value = null;
    protected Composite body = null;
    protected Composite jobRescComposite = null;
    protected Composite left = null;
    protected Composite right = null;
    protected Label lblMountPoint = null;
    protected Label lblMountSource = null;
    protected Label lblDiskSpace = null;
    protected Label lblFileSystemType = null;
    protected Label lblFileSystemDescr = null;
    protected Label lblOperSystType = null;
    protected Label lblOperSystVer = null;
    protected Label lblOSDescr = null;
    protected Label lblCPUArchName = null;
    protected Label lblIndCPUSpl = null;
    protected Label lblIndCPUTime = null;
    protected Label lblIndCPUCount = null;
    protected Label lblIndNetBand = null;
    protected Label lblPhysMem = null;
    protected Label lblVirtMem = null;
    protected Label lblIndDiskSpac = null;
    protected Label lblCPUTime = null;
    protected Label lblCPUCount = null;
    protected Label lblTotPhMem = null;
    protected Label lblTotVirtMem = null;
    protected Label lblTotDiskSp = null;
    protected Label lblTotResCount = null;
    protected Label lblFileSystemName = null;
    protected Button btnAdd = null;
    protected Button btnDel = null;
    protected Button btnEdit = null;
    protected TableViewer hostsViewer = null;
    private Text txtFileSystemName = null;
    private Text txtFileSystemDescr = null;
    private Text txtMountPoint = null;
    private Text txtDiskSpace = null;
    private Text txtOperSystVer = null;
    private Text txtOSDescr = null;
    private Text txtIndCPUSp = null;
    private Text txtIndCPUTime = null;
    private Text txtIndCPUCount = null;
    private Text txtIndNetBand = null;
    private Text txtVirtMem = null;
    private Text txtPhysMem = null;
    private Text txtIndDiskSpac = null;
    private Text txtCPUTime = null;
    private Text txtCPUCount = null;
    private Text txtTotPhMem = null;
    private Text txtTotVirtMem = null;
    private Text txtTotDiskSp = null;
    private Text txtTotResCount = null;
    private Combo cmbOperSystType = null;
    private Combo cmbCPUArchName = null;
    private Combo cmbFileSystemType = null;
    private Combo cmbDiskSpaceRange = null;
    private ImageDescriptor helpDesc = null;
    private boolean contentRefreshed = false;
    private boolean dirtyFlag = false;
    private final int TXT_LENGTH = 300;
    private final int WIDGET_HEIGHT = 100;

    public ResourcesPage(FormEditor formEditor) {
        super(formEditor, PAGE_ID, Messages.getString("ResourcesPage_PageTitle"));
    }

    public void setActive(boolean bl) {
        if (bl && this.isContentRefreshed()) {
            this.resourcesTypeAdapter.load();
        }
    }

    private boolean isContentRefreshed() {
        return this.contentRefreshed;
    }

    public void setPageContent(EObject eObject, boolean bl) {
        if (bl) {
            this.contentRefreshed = true;
            this.resourcesTypeAdapter.setContent(eObject);
        } else {
            this.resourcesTypeAdapter = new ResourcesTypeAdapter(eObject);
            this.resourcesTypeAdapter.addListener(this);
        }
    }

    public boolean isDirty() {
        return this.dirtyFlag;
    }

    public void setDirty(boolean bl) {
        if (this.dirtyFlag != bl) {
            this.dirtyFlag = bl;
            this.getEditor().editorDirtyStateChanged();
        }
    }

    protected void createFormContent(IManagedForm iManagedForm) {
        ScrolledForm scrolledForm = iManagedForm.getForm();
        FormToolkit formToolkit = iManagedForm.getToolkit();
        scrolledForm.setText(Messages.getString("ResourcesPage_ResourcePageTitle"));
        this.body = scrolledForm.getBody();
        this.body.setLayout((Layout)FormLayoutFactory.createFormTableWrapLayout(false, 2));
        this.left = formToolkit.createComposite(this.body);
        this.left.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.left.setLayoutData((Object)new TableWrapData(256));
        this.right = formToolkit.createComposite(this.body);
        this.right.setLayout((Layout)FormLayoutFactory.createFormPaneTableWrapLayout(false, 1));
        this.right.setLayoutData((Object)new TableWrapData(256));
        this.createCandidateHostsSection(this.left, formToolkit);
        this.createFileSystemSection(this.right, formToolkit);
        this.createOSSection(this.left, formToolkit);
        this.createCPUArch(this.right, formToolkit);
        this.createAddElementsSection(this.left, formToolkit);
        this.resourcesTypeAdapter.load();
        scrolledForm.setBackgroundImage(Activator.getDefault().getImageRegistry().get("formsbackground"));
        this.addFormPageHelp(scrolledForm);
    }

    private void createCandidateHostsSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("ResourcesPage_CanHost");
        String string2 = Messages.getString("ResourcesPage_CandHostDesc");
        Composite composite2 = FormSectionFactory.createGridStaticSection(formToolkit, composite, string, string2, 3);
        GridData gridData = new GridData();
        Label label = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_HostName"));
        gridData.verticalSpan = 5;
        gridData.verticalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Table table = new Table(composite2, 2816);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalSpan = 5;
        gridData.horizontalSpan = 1;
        gridData.heightHint = 100;
        gridData.widthHint = 300;
        table.setLayoutData((Object)gridData);
        this.hostsViewer = new TableViewer(table);
        table = this.hostsViewer.getTable();
        this.hostsViewer.setContentProvider((IContentProvider)new FeatureContentProvider());
        this.hostsViewer.setLabelProvider((IBaseLabelProvider)new FeatureLabelProvider());
        this.hostsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ResourcesPage.this.updateButtons((TableViewer)selectionChangedEvent.getSource());
            }
        });
        table.setData((Object)"FormWidgetFactory.drawBorder");
        this.resourcesTypeAdapter.attachToHostName(this.hostsViewer);
        gridData = new GridData();
        gridData.verticalSpan = 2;
        gridData.verticalAlignment = 3;
        gridData.horizontalAlignment = 4;
        this.btnAdd = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_AddButton"), 524288);
        this.btnAdd.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ResourcesPage.this.handleAddDialog(Messages.getString("ResourcesPage_NewHostNameDialog"), (Button)selectionEvent.getSource());
                ResourcesPage.this.resourcesTypeAdapter.performAdd(ResourcesPage.this.hostsViewer, ResourcesPage.this.value);
            }

            public void widgetDefaultSelected(SelectionEvent selectionEvent) {
            }
        });
        this.btnAdd.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalSpan = 1;
        gridData.verticalAlignment = 1;
        gridData.horizontalAlignment = 4;
        this.btnDel = formToolkit.createButton(composite2, Messages.getString("JsdlEditor_RemoveButton"), 524288);
        this.btnDel.setEnabled(true);
        this.resourcesTypeAdapter.attachToDelete(this.btnDel, this.hostsViewer);
        this.btnDel.setLayoutData((Object)gridData);
        formToolkit.paintBordersFor(composite2);
    }

    private void createFileSystemSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("ResourcesPage_FileSystem");
        String string2 = Messages.getString("ResourcesPage_FileSystemDesc");
        Composite composite2 = FormSectionFactory.createGridStaticSection(formToolkit, composite, string, string2, 3);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 1;
        this.lblFileSystemName = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_FileSystemName"));
        this.lblFileSystemName.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.txtFileSystemName = formToolkit.createText(composite2, "", 0);
        this.resourcesTypeAdapter.attachToFileSystemName(this.txtFileSystemName);
        this.txtFileSystemName.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.lblFileSystemDescr = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_Description"));
        this.lblFileSystemDescr.setLayoutData((Object)gridData);
        this.txtFileSystemDescr = formToolkit.createText(composite2, "", 832);
        this.resourcesTypeAdapter.attachToFileSystemDescription(this.txtFileSystemDescr);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 285;
        gridData.heightHint = 100;
        this.txtFileSystemDescr.setLayoutData((Object)gridData);
        gridData = new GridData();
        this.lblMountPoint = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_MountPoint"));
        this.lblMountPoint.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 300;
        this.txtMountPoint = formToolkit.createText(composite2, "", 0);
        this.resourcesTypeAdapter.attachToFileSystemMountPoint(this.txtMountPoint);
        this.txtMountPoint.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.widthHint = 120;
        this.lblDiskSpace = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_DiskSpace"));
        this.lblDiskSpace.setLayoutData((Object)gridData);
        this.txtDiskSpace = formToolkit.createText(composite2, "", 0);
        this.txtDiskSpace.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.widthHint = 175;
        this.cmbDiskSpaceRange = new Combo(composite2, 8);
        this.cmbDiskSpaceRange.setData((Object)"FormWidgetFactory.drawBorder");
        this.cmbDiskSpaceRange.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.horizontalSpan = 1;
        gridData.widthHint = 300 + 5;
        this.lblFileSystemType = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_FileSysType"));
        gridData.widthHint = 120;
        this.lblFileSystemType.setLayoutData((Object)gridData);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        this.cmbFileSystemType = new Combo(composite2, 8);
        this.cmbFileSystemType.setData((Object)"FormWidgetFactory.drawBorder");
        this.resourcesTypeAdapter.attachToFileSystemType(this.cmbFileSystemType);
        this.cmbFileSystemType.setLayoutData((Object)gridData);
        this.resourcesTypeAdapter.attachToFileSystemDiskSpace(this.txtDiskSpace, this.cmbDiskSpaceRange);
        formToolkit.paintBordersFor(composite2);
    }

    private void createOSSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("ResourcesPage_OperSyst");
        String string2 = Messages.getString("ResourcesPage_OperSystDescr");
        Composite composite2 = FormSectionFactory.createGridStaticSection(formToolkit, composite, string, string2, 2);
        GridData gridData = new GridData();
        gridData.widthHint = 280;
        this.lblOperSystType = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_OperSystType"));
        this.cmbOperSystType = new Combo(composite2, 76);
        this.cmbOperSystType.setData((Object)"FormWidgetFactory.drawBorder");
        this.resourcesTypeAdapter.attachToOSType(this.cmbOperSystType);
        this.cmbOperSystType.setLayoutData((Object)gridData);
        this.lblOperSystVer = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_OperSystVersion"));
        this.txtOperSystVer = formToolkit.createText(composite2, "", 0);
        this.resourcesTypeAdapter.attachToOSVersion(this.txtOperSystVer);
        this.txtOperSystVer.setLayoutData((Object)gridData);
        gridData = new GridData();
        gridData.verticalAlignment = 1;
        this.lblOSDescr = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_DEscr"));
        this.lblOSDescr.setLayoutData((Object)gridData);
        gridData = new GridData();
        this.txtOSDescr = formToolkit.createText(composite2, "", 832);
        this.resourcesTypeAdapter.attachToOSDescription(this.txtOSDescr);
        gridData.widthHint = 265;
        gridData.heightHint = 100;
        this.txtOSDescr.setLayoutData((Object)gridData);
        formToolkit.paintBordersFor(composite2);
    }

    private void createCPUArch(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("ResourcesPage_CPUArch");
        String string2 = Messages.getString("ResourcesPage_CPUArchDescr");
        Composite composite2 = FormSectionFactory.createStaticSection(formToolkit, composite, string, string2, 2);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.lblCPUArchName = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_CPUArchName"));
        this.cmbCPUArchName = new Combo(composite2, 76);
        this.cmbCPUArchName.setData((Object)"FormWidgetFactory.drawBorder");
        this.resourcesTypeAdapter.attachToCPUArchitecture(this.cmbCPUArchName);
        this.cmbCPUArchName.setLayoutData((Object)tableWrapData);
        formToolkit.paintBordersFor(composite2);
    }

    private void createAddElementsSection(Composite composite, FormToolkit formToolkit) {
        String string = Messages.getString("ResourcesPage_AddElementRangeVal");
        String string2 = Messages.getString("ResourcesPage_AddElementsRangeValueDescr");
        Composite composite2 = FormSectionFactory.createExpandableSection(formToolkit, composite, string, string2, 3, false);
        TableWrapData tableWrapData = new TableWrapData(256);
        this.lblIndCPUSpl = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_IndCPUSpeed"));
        this.createCombo(composite2);
        this.txtIndCPUSp = formToolkit.createText(composite2, "", 0);
        this.txtIndCPUSp.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblIndCPUTime = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_IndCPUTime"));
        this.createCombo(composite2);
        this.txtIndCPUTime = formToolkit.createText(composite2, "", 0);
        this.txtIndCPUTime.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblIndCPUCount = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_IndCPUCount"));
        this.createCombo(composite2);
        this.txtIndCPUCount = formToolkit.createText(composite2, "", 0);
        this.txtIndCPUCount.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblIndNetBand = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_IndNetwBandwidth"));
        this.createCombo(composite2);
        this.txtIndNetBand = formToolkit.createText(composite2, "", 0);
        this.txtIndNetBand.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblPhysMem = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_PhysMem"));
        this.createCombo(composite2);
        this.txtPhysMem = formToolkit.createText(composite2, "", 0);
        this.txtPhysMem.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblVirtMem = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_VirtualMem"));
        this.createCombo(composite2);
        this.txtVirtMem = formToolkit.createText(composite2, "", 0);
        this.txtVirtMem.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblIndDiskSpac = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_IndDiskSpace"));
        this.createCombo(composite2);
        this.txtIndDiskSpac = formToolkit.createText(composite2, "", 0);
        this.txtIndDiskSpac.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblCPUTime = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_CPUTime"));
        this.createCombo(composite2);
        this.txtCPUTime = formToolkit.createText(composite2, "", 0);
        this.txtCPUTime.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblCPUCount = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_TotCPUCount"));
        this.createCombo(composite2);
        this.txtCPUCount = formToolkit.createText(composite2, "", 0);
        this.txtCPUCount.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblTotPhMem = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_TotPhysMem"));
        this.createCombo(composite2);
        this.txtTotPhMem = formToolkit.createText(composite2, "", 0);
        this.txtTotPhMem.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblTotVirtMem = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_TotVirtualMem"));
        this.createCombo(composite2);
        this.txtTotVirtMem = formToolkit.createText(composite2, "", 0);
        this.txtTotVirtMem.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblTotDiskSp = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_TotDiskSpace"));
        this.createCombo(composite2);
        this.txtTotDiskSp = formToolkit.createText(composite2, "", 0);
        this.txtTotDiskSp.setLayoutData((Object)tableWrapData);
        tableWrapData = new TableWrapData(256);
        this.lblTotResCount = formToolkit.createLabel(composite2, Messages.getString("ResourcesPage_TotRescCount"));
        this.createCombo(composite2);
        this.txtTotResCount = formToolkit.createText(composite2, "", 0);
        this.txtTotResCount.setLayoutData((Object)tableWrapData);
        formToolkit.paintBordersFor(composite2);
    }

    private Combo createCombo(Composite composite) {
        Combo combo = new Combo(composite, 4);
        combo.add(Messages.getString("ResourcesPage_LowBoundRange"));
        combo.add(Messages.getString("ResourcesPage_UpBoundRange"));
        combo.add(Messages.getString("ResourcesPage_Exact"));
        TableWrapData tableWrapData = new TableWrapData(256);
        combo.setLayoutData((Object)tableWrapData);
        return combo;
    }

    private void addFormPageHelp(final ScrolledForm scrolledForm) {
        final String string = this.getHelpResource();
        if (string != null) {
            IToolBarManager iToolBarManager = scrolledForm.getToolBarManager();
            Action action = new Action("help"){

                public void run() {
                    BusyIndicator.showWhile((Display)scrolledForm.getDisplay(), (Runnable)new Runnable(){

                        public void run() {
                            PlatformUI.getWorkbench().getHelpSystem().displayHelpResource(string);
                        }
                    });
                }
            };
            action.setToolTipText(Messages.getString("ResourcesPage_Help"));
            URL uRL = Activator.getDefault().getBundle().getEntry("icons/help.gif");
            this.helpDesc = ImageDescriptor.createFromURL((URL)uRL);
            action.setImageDescriptor(this.helpDesc);
            iToolBarManager.add((IAction)action);
            scrolledForm.updateToolBar();
        }
    }

    protected void handleAddDialog(String string, Button button) {
        this.value = null;
        CandidateHostsDialog candidateHostsDialog = new CandidateHostsDialog(this.body.getShell(), string);
        IFile iFile = ((IFileEditorInput)this.getEditor().getEditorInput()).getFile();
        IGridRoot iGridRoot = GridModel.getRoot();
        IGridElement iGridElement = iGridRoot.findElement((IResource)iFile);
        candidateHostsDialog.setDialogInput(iGridElement);
        candidateHostsDialog.setExistingCandidateHosts(this.hostsViewer.getInput());
        if (candidateHostsDialog.open() != 0) {
            return;
        }
        this.value = candidateHostsDialog.getValue();
    }

    public void notifyChanged(Notification notification) {
        this.setDirty(true);
    }

    protected String getHelpResource() {
        return "/eu.geclipse.doc.user/html/concepts/jobmanagement/editorpages/resources.html";
    }

    protected void updateButtons(TableViewer tableViewer) {
        ISelection iSelection = tableViewer.getSelection();
        boolean bl = !iSelection.isEmpty();
        this.btnAdd.setEnabled(true);
        this.btnDel.setEnabled(bl);
    }
}

