/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.preference;

import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.preference.ApplicationSpecificObject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Path;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationSpecificRegistry
implements IContentChangeNotifier {
    private static final String DIRECTORY_NAME = ".appsData";
    private static final String APP_NAME_PREFIX = "appName=";
    private static final String APP_PATH_PREFIX = "appPath=";
    private static final String XML_PATH_PREFIX = "XMLPath=";
    private static final String JSDL_PATH_PEFIX = "JSDLPath=";
    private static ApplicationSpecificRegistry instance;
    private int currentIdPointer = 0;
    private List<ApplicationSpecificObject> apps;
    private ListenerList ccListeners = new ListenerList();
    private Map<ApplicationSpecificObject, String> appSpecObjectsToFiles = new HashMap<ApplicationSpecificObject, String>();

    private ApplicationSpecificRegistry() {
        this.apps = new ArrayList<ApplicationSpecificObject>();
        IPath iPath = Activator.getDefault().getStateLocation();
        iPath = iPath.append(DIRECTORY_NAME);
        File file = iPath.toFile();
        if (file.exists()) {
            String[] stringArray;
            String[] stringArray2 = stringArray = file.list();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                ApplicationSpecificObject applicationSpecificObject = this.readDataFile(new Path(file.getAbsolutePath()).append(string));
                if (applicationSpecificObject != null) {
                    this.apps.add(applicationSpecificObject);
                }
                ++n2;
            }
        }
    }

    private ApplicationSpecificObject readDataFile(IPath iPath) {
        ApplicationSpecificObject applicationSpecificObject = null;
        File file = iPath.toFile();
        if (file.isFile()) {
            try {
                String string;
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                String string2 = null;
                String string3 = null;
                Path path = null;
                Path path2 = null;
                while ((string = bufferedReader.readLine()) != null) {
                    if (string.startsWith(APP_NAME_PREFIX)) {
                        string2 = string.substring(APP_NAME_PREFIX.length()).trim();
                    }
                    if (string.startsWith(APP_PATH_PREFIX)) {
                        string3 = string.substring(APP_PATH_PREFIX.length()).trim();
                    }
                    if (string.startsWith(XML_PATH_PREFIX)) {
                        path = new Path(string.substring(XML_PATH_PREFIX.length()).trim());
                    }
                    if (!string.startsWith(JSDL_PATH_PEFIX)) continue;
                    path2 = new Path(string.substring(JSDL_PATH_PEFIX.length()).trim());
                }
                if (string2 != null && string3 != null && path != null) {
                    applicationSpecificObject = new ApplicationSpecificObject(this.currentIdPointer, string2, string3, (IPath)path, (IPath)path2);
                    this.appSpecObjectsToFiles.put(applicationSpecificObject, iPath.lastSegment());
                    ++this.currentIdPointer;
                }
            }
            catch (FileNotFoundException fileNotFoundException) {
                Activator.logException(fileNotFoundException);
            }
            catch (IOException iOException) {
                Activator.logException(iOException);
            }
        }
        return applicationSpecificObject;
    }

    public static ApplicationSpecificRegistry getInstance() {
        if (instance == null) {
            instance = new ApplicationSpecificRegistry();
        }
        return instance;
    }

    public ApplicationSpecificObject getApplicationData(int n) {
        ApplicationSpecificObject applicationSpecificObject = null;
        for (ApplicationSpecificObject applicationSpecificObject2 : this.apps) {
            if (applicationSpecificObject2.getId() != n) continue;
            applicationSpecificObject = applicationSpecificObject2;
        }
        return applicationSpecificObject;
    }

    public List<ApplicationSpecificObject> getApplicationDataList() {
        return this.apps;
    }

    public void addApplicationSpecificData(String string, String string2, IPath iPath, Path path) {
        ApplicationSpecificObject applicationSpecificObject = new ApplicationSpecificObject(this.currentIdPointer, string, string2, iPath, (IPath)path);
        ++this.currentIdPointer;
        if (!this.apps.contains(applicationSpecificObject)) {
            try {
                this.saveObjectToDisc(applicationSpecificObject);
                this.apps.add(applicationSpecificObject);
                this.notifyListeners();
            }
            catch (IOException iOException) {
                Activator.logException(iOException);
            }
        }
    }

    private void saveObjectToDisc(ApplicationSpecificObject applicationSpecificObject) throws IOException {
        IPath iPath = Activator.getDefault().getStateLocation();
        File file = (iPath = iPath.append(DIRECTORY_NAME)).toFile();
        if (!file.exists()) {
            file.mkdir();
        }
        int n = applicationSpecificObject.getId();
        boolean bl = false;
        while (!bl) {
            if (iPath.append(Integer.valueOf(n).toString()).toFile().exists()) {
                ++n;
                continue;
            }
            iPath = iPath.append(Integer.valueOf(n).toString());
            bl = true;
        }
        File file2 = iPath.toFile();
        file2.createNewFile();
        FileWriter fileWriter = new FileWriter(file2, true);
        fileWriter.write(APP_NAME_PREFIX + applicationSpecificObject.getAppName() + "\n");
        fileWriter.write(APP_PATH_PREFIX + applicationSpecificObject.getAppPath() + "\n");
        fileWriter.write(XML_PATH_PREFIX + applicationSpecificObject.getXmlPath() + "\n");
        fileWriter.write(JSDL_PATH_PEFIX + applicationSpecificObject.getJsdlPath());
        fileWriter.close();
        this.appSpecObjectsToFiles.put(applicationSpecificObject, Integer.valueOf(n).toString());
    }

    public Map<String, Integer> getApplicationDataMapping() {
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        HashMap<String, Integer> hashMap2 = new HashMap<String, Integer>();
        for (ApplicationSpecificObject applicationSpecificObject : this.apps) {
            if (hashMap2.containsKey(applicationSpecificObject.getAppName())) {
                hashMap2.put(applicationSpecificObject.getAppName(), new Integer((Integer)hashMap2.get(applicationSpecificObject.getAppName()) + 1));
                continue;
            }
            hashMap2.put(applicationSpecificObject.getAppName(), new Integer(1));
        }
        for (ApplicationSpecificObject applicationSpecificObject : this.apps) {
            String string = applicationSpecificObject.getAppName();
            int n = (Integer)hashMap2.get(applicationSpecificObject.getAppName());
            if (n != 1) {
                hashMap2.put(applicationSpecificObject.getAppName(), n - 1);
                string = String.valueOf(string) + "(" + (n - 1) + ")";
            }
            hashMap.put(string, new Integer(applicationSpecificObject.getId()));
        }
        return hashMap;
    }

    public void addContentChangeListener(IContentChangeListener iContentChangeListener) {
        if (this.ccListeners == null) {
            this.ccListeners = new ListenerList();
        }
        this.ccListeners.add((Object)iContentChangeListener);
    }

    public void removeContentChangeListener(IContentChangeListener iContentChangeListener) {
        if (this.ccListeners != null) {
            this.ccListeners.remove((Object)iContentChangeListener);
        }
    }

    protected void notifyListeners() {
        Object[] objectArray = this.ccListeners.getListeners();
        int n = 0;
        while (n < objectArray.length) {
            if (objectArray[n] instanceof IContentChangeListener) {
                IContentChangeListener iContentChangeListener = (IContentChangeListener)objectArray[n];
                iContentChangeListener.contentChanged((IContentChangeNotifier)this);
            }
            ++n;
        }
    }

    public void removeApplicationSpecificData(ApplicationSpecificObject applicationSpecificObject) {
        String string = this.appSpecObjectsToFiles.get(applicationSpecificObject);
        IPath iPath = Activator.getDefault().getStateLocation();
        iPath = iPath.append(DIRECTORY_NAME);
        File file = (iPath = iPath.append(string)).toFile();
        if (file.delete()) {
            this.apps.remove(applicationSpecificObject);
            this.notifyListeners();
        }
    }

    public void editApplicationSpecificData(ApplicationSpecificObject applicationSpecificObject, String string, String string2, String string3, String string4) {
        IPath iPath = Activator.getDefault().getStateLocation();
        iPath = iPath.append(DIRECTORY_NAME);
        iPath = iPath.append(this.appSpecObjectsToFiles.get(applicationSpecificObject));
        try {
            FileWriter fileWriter = new FileWriter(iPath.toFile(), false);
            fileWriter.write(APP_NAME_PREFIX + string + "\n");
            fileWriter.write(APP_PATH_PREFIX + string2 + "\n");
            fileWriter.write(XML_PATH_PREFIX + string3 + "\n");
            fileWriter.write(JSDL_PATH_PEFIX + string4);
            fileWriter.close();
            applicationSpecificObject.setAppName(string);
            applicationSpecificObject.setAppPath(string2);
            applicationSpecificObject.setXmlPath((IPath)new Path(string3));
            applicationSpecificObject.setJSDLPath((IPath)new Path(string4));
            this.notifyListeners();
        }
        catch (IOException iOException) {
            Activator.logException(iOException);
        }
    }
}

