/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.internal.wizards;

import eu.geclipse.jsdl.ui.internal.dialogs.MultipleInputDialog;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.internal.wizards.Messages;
import eu.geclipse.jsdl.ui.internal.wizards.Range;
import eu.geclipse.ui.widgets.TabComponent;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLRangesTab
extends TabComponent {
    public JSDLRangesTab(IStructuredContentProvider iStructuredContentProvider, ITableLabelProvider iTableLabelProvider, List<String> list, int n, int n2) {
        super(iStructuredContentProvider, iTableLabelProvider, list, n, n2);
    }

    protected void handleAddButtonSelected() {
        MultipleInputDialog multipleInputDialog = new MultipleInputDialog(this.getShell(), Messages.getString("JSDLRangesTab.new_value"));
        multipleInputDialog.addTextField(Messages.getString("JSDLRangesTab.range_start"), null, false);
        multipleInputDialog.addTextField(Messages.getString("JSDLRangesTab.range_end"), null, false);
        if (multipleInputDialog.open() != 0) {
            return;
        }
        String string = multipleInputDialog.getStringValue(Messages.getString("JSDLRangesTab.range_start"));
        String string2 = multipleInputDialog.getStringValue(Messages.getString("JSDLRangesTab.range_end"));
        try {
            Range range = new Range(Double.valueOf(string), Double.valueOf(string2));
            this.addVariable(range);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.bad_range_format"), (String)Messages.getString("JSDLRangesTab.bad_range_format"));
        }
    }

    protected void handleEditButtonSelected() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.table.getSelection();
        Range range = (Range)iStructuredSelection.getFirstElement();
        if (range != null) {
            Object object;
            String string = Double.valueOf(range.getStart()).toString();
            String string2 = Double.valueOf(range.getEnd()).toString();
            MultipleInputDialog multipleInputDialog = new MultipleInputDialog(this.getShell(), Messages.getString("OutputFilesTab.edit_output_file_settings_dialog_title"));
            ArrayList<String> arrayList = new ArrayList<String>();
            FileType[] fileTypeArray = FileType.values();
            int n = fileTypeArray.length;
            int n2 = 0;
            while (n2 < n) {
                object = fileTypeArray[n2];
                arrayList.add(object.toString());
                ++n2;
            }
            multipleInputDialog.addTextField("Range start", string, false);
            multipleInputDialog.addTextField(Messages.getString("JSDLRangesTab.range_end"), string2, false);
            if (multipleInputDialog.open() == 0) {
                try {
                    object = multipleInputDialog.getStringValue(Messages.getString("JSDLRangesTab.range_start"));
                    String string3 = multipleInputDialog.getStringValue(Messages.getString("JSDLRangesTab.range_end"));
                    if (!string.equals(object) || !string2.equals(string3)) {
                        Range range2 = new Range(Double.valueOf((String)object), Double.valueOf(string3));
                        if (this.addVariable(range2)) {
                            this.table.remove((Object)range);
                        }
                    } else {
                        range.setStart(Double.valueOf((String)object));
                        range.setEnd(Double.valueOf(string3));
                        this.table.update((Object)range, null);
                        this.updateLaunchConfigurationDialog();
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.bad_range_format"), (String)Messages.getString("JSDLRangesTab.bad_range_format"));
                }
            }
        }
    }

    protected void handleRemoveButtonSelected() {
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.table.getSelection();
        this.table.getControl().setRedraw(false);
        for (Range range : iStructuredSelection) {
            this.table.remove((Object)range);
        }
        this.table.getControl().setRedraw(true);
        this.updateLaunchConfigurationDialog();
    }

    protected void setLabels() {
        this.addButton.setText(Messages.getString("JSDLRangesTab.add_button"));
        this.editButton.setText(Messages.getString("JSDLRangesTab.edit_button"));
        this.removeButton.setText(Messages.getString("JSDLRangesTab.remove_button"));
    }

    protected boolean addVariable(Range range) {
        boolean bl = true;
        TableItem[] tableItemArray = this.table.getTable().getItems();
        int n = 0;
        while (n < tableItemArray.length) {
            Range range2 = (Range)tableItemArray[n].getData();
            if (range2.equals(range)) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.rnage_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message")) + range2.getStart() + ", " + range2.getEnd() + ")"));
                bl = false;
                break;
            }
            if (range2.getStart() >= range.getStart() && range2.getStart() < range.getEnd()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.range_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message_1")) + range2.getStart() + ", " + range2.getEnd() + ")"));
                bl = false;
                break;
            }
            if (range.getStart() >= range2.getStart() && range.getStart() < range2.getEnd()) {
                MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("JSDLRangesTab.range_conflict"), (String)(String.valueOf(Messages.getString("JSDLRangesTab.conflict_message_1")) + range2.getStart() + ", " + range2.getEnd() + ")"));
                bl = false;
                break;
            }
            ++n;
        }
        if (bl) {
            this.table.add((Object)range);
        }
        return bl;
    }
}

