/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.preference;

import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.preference.ApplicationSpecificObject;
import eu.geclipse.jsdl.ui.internal.preference.ApplicationSpecificRegistry;
import eu.geclipse.jsdl.ui.preference.Messages;
import org.eclipse.compare.IContentChangeListener;
import org.eclipse.compare.IContentChangeNotifier;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.PlatformUI;

public class ApplicationSpecificPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage,
IContentChangeListener {
    private Button addButton;
    private Button editButton;
    private Button removeButton;
    private TableViewer appsViewer;
    private Table appsTable;

    public ApplicationSpecificPreferencePage() {
        this.setDescription(Messages.getString("ApplicationSpecificPreferencePage.description"));
        ApplicationSpecificRegistry.getInstance().addContentChangeListener(this);
    }

    public void dispose() {
        ApplicationSpecificRegistry.getInstance().removeContentChangeListener(this);
        super.dispose();
    }

    protected Control createContents(Composite composite) {
        this.initializeDialogUnits((Control)composite);
        this.noDefaultAndApplyButton();
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite2.setLayout((Layout)gridLayout);
        this.initializeDialogUnits((Control)composite2);
        this.appsTable = new Table(composite2, 268503042);
        this.appsTable.setHeaderVisible(true);
        this.appsTable.setLinesVisible(true);
        GridData gridData = new GridData(1808);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        gridData.heightHint = 100;
        this.appsTable.setLayoutData((Object)gridData);
        TableLayout tableLayout = new TableLayout();
        this.appsTable.setLayout((Layout)tableLayout);
        TableColumn tableColumn = new TableColumn(this.appsTable, 0x1000000);
        ColumnWeightData columnWeightData = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        columnWeightData = new ColumnWeightData(100);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        columnWeightData = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        columnWeightData = new ColumnWeightData(150);
        tableLayout.addColumnData((ColumnLayoutData)columnWeightData);
        tableColumn.setText("Name");
        TableColumn tableColumn2 = new TableColumn(this.appsTable, 16384);
        tableColumn2.setText("Path");
        TableColumn tableColumn3 = new TableColumn(this.appsTable, 16384);
        tableColumn3.setText("XML file");
        TableColumn tableColumn4 = new TableColumn(this.appsTable, 16384);
        tableColumn4.setText("JSDL file");
        this.appsViewer = new TableViewer(this.appsTable);
        ApplicationSpecificPageContentProvider applicationSpecificPageContentProvider = new ApplicationSpecificPageContentProvider();
        this.appsViewer.setContentProvider((IContentProvider)applicationSpecificPageContentProvider);
        this.appsViewer.setLabelProvider((IBaseLabelProvider)new ApplicationSpecificLabelProvider());
        this.appsViewer.setInput((Object)applicationSpecificPageContentProvider.getElements(null));
        this.appsViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ApplicationSpecificPreferencePage.this.updateButtons();
            }
        });
        Composite composite3 = new Composite(composite2, 0);
        gridLayout = new GridLayout(3, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(130);
        gridData.horizontalSpan = 1;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        this.addButton = new Button(composite3, 8);
        gridData = new GridData(1808);
        this.addButton.setLayoutData((Object)gridData);
        this.addButton.setText(Messages.getString("ApplicationSpecificPreferencePage.add_button"));
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApplicationSpecificPreferencePage.this.editAppliactionSpecificData(null);
            }
        });
        this.editButton = new Button(composite3, 8);
        gridData = new GridData(1808);
        this.editButton.setLayoutData((Object)gridData);
        this.editButton.setText(Messages.getString("ApplicationSpecificPreferencePage.edit_button"));
        this.editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApplicationSpecificPreferencePage.this.editAppliactionSpecificData(ApplicationSpecificPreferencePage.this.getSelectedAppSpecificObject());
            }
        });
        this.removeButton = new Button(composite3, 8);
        gridData = new GridData(1808);
        this.removeButton.setLayoutData((Object)gridData);
        this.removeButton.setText(Messages.getString("ApplicationSpecificPreferencePage.delete_button"));
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                ApplicationSpecificRegistry.getInstance().removeApplicationSpecificData(ApplicationSpecificPreferencePage.this.getSelectedAppSpecificObject());
            }
        });
        this.updateButtons();
        return composite2;
    }

    void editAppliactionSpecificData(ApplicationSpecificObject applicationSpecificObject) {
        if (applicationSpecificObject == null) {
            EditDialog editDialog = new EditDialog(this.getShell());
            if (editDialog.open() == 0) {
                ApplicationSpecificRegistry.getInstance().addApplicationSpecificData(editDialog.getAppName(), editDialog.getAppPath(), (IPath)new Path(editDialog.getXMLPath()), new Path(editDialog.getJSDLPath()));
            }
        } else {
            EditDialog editDialog;
            String string = null;
            if (applicationSpecificObject.getJsdlPath() != null) {
                string = applicationSpecificObject.getJsdlPath().toOSString();
            }
            if ((editDialog = new EditDialog(this.getShell(), applicationSpecificObject.getAppName(), applicationSpecificObject.getAppPath(), applicationSpecificObject.getXmlPath().toOSString(), string)).open() == 0) {
                ApplicationSpecificRegistry.getInstance().editApplicationSpecificData(applicationSpecificObject, editDialog.getAppName(), editDialog.getAppPath(), editDialog.getXMLPath(), editDialog.getJSDLPath());
            }
        }
    }

    public ApplicationSpecificObject getSelectedAppSpecificObject() {
        ApplicationSpecificObject applicationSpecificObject = null;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.appsViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (object instanceof ApplicationSpecificObject) {
            applicationSpecificObject = (ApplicationSpecificObject)object;
        }
        return applicationSpecificObject;
    }

    protected void updateButtons() {
        ISelection iSelection = this.appsViewer.getSelection();
        boolean bl = !iSelection.isEmpty();
        this.addButton.setEnabled(true);
        this.removeButton.setEnabled(bl);
        this.editButton.setEnabled(bl);
    }

    public void init(IWorkbench iWorkbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
    }

    public void contentChanged(IContentChangeNotifier iContentChangeNotifier) {
        this.appsViewer.refresh();
    }

    class ApplicationSpecificLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ApplicationSpecificLabelProvider() {
        }

        public Image getColumnImage(Object object, int n) {
            return null;
        }

        public String getColumnText(Object object, int n) {
            String string = null;
            ApplicationSpecificObject applicationSpecificObject = (ApplicationSpecificObject)object;
            switch (n) {
                case 0: {
                    string = applicationSpecificObject.getAppName();
                    break;
                }
                case 1: {
                    string = applicationSpecificObject.getAppPath();
                    break;
                }
                case 2: {
                    string = applicationSpecificObject.getXmlPath().toOSString();
                    break;
                }
                case 3: {
                    if (applicationSpecificObject.getJsdlPath() == null) break;
                    string = applicationSpecificObject.getJsdlPath().toOSString();
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }
    }

    class ApplicationSpecificPageContentProvider
    implements IStructuredContentProvider {
        ApplicationSpecificPageContentProvider() {
        }

        public Object[] getElements(Object object) {
            Object[] objectArray = new ApplicationSpecificObject[]{};
            objectArray = ApplicationSpecificRegistry.getInstance().getApplicationDataList().toArray(objectArray);
            return objectArray;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object object, Object object2) {
        }
    }

    class EditDialog
    extends Dialog {
        Text xmlPath;
        Text jsdlPath;
        private Text appName;
        private Text appPath;
        private String appNameInit;
        private String appPathInit;
        private String xmlPathInit;
        private String jsdlPathInit;
        private String returnAppName;
        private String returnXMLPath;
        private String returnAppPath;
        private String returnJSDLPath;

        protected EditDialog(Shell shell) {
            super(shell);
        }

        protected EditDialog(Shell shell, String string, String string2, String string3, String string4) {
            super(shell);
            this.appNameInit = string;
            this.appPathInit = string2;
            this.xmlPathInit = string3;
            this.jsdlPathInit = string4;
        }

        protected void createButtonsForButtonBar(Composite composite) {
            super.createButtonsForButtonBar(composite);
            this.updateButtons();
        }

        void updateButtons() {
            if (!(this.appName.getText().equals("") || this.appPath.getText().equals("") || this.xmlPath.getText().equals(""))) {
                super.getButton(0).setEnabled(true);
            } else {
                super.getButton(0).setEnabled(false);
            }
        }

        protected Control createDialogArea(Composite composite) {
            Composite composite2 = (Composite)super.createDialogArea(composite);
            composite2.setLayout((Layout)new GridLayout(1, false));
            composite2.setLayoutData((Object)new GridData(1808));
            Composite composite3 = new Composite(composite2, 0);
            this.initializeDialogUnits((Control)composite2);
            GridLayout gridLayout = new GridLayout(3, false);
            composite3.setLayout((Layout)gridLayout);
            GridData gridData = new GridData(768);
            composite3.setLayoutData((Object)gridData);
            Label label = new Label(composite3, 16384);
            label.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_application_name_label"));
            gridData = new GridData();
            label.setLayoutData((Object)gridData);
            this.appName = new Text(composite3, 2048);
            gridData = new GridData(1808);
            gridData.horizontalSpan = 2;
            this.appName.setLayoutData((Object)gridData);
            if (this.appNameInit != null) {
                this.appName.setText(this.appNameInit);
            }
            Label label2 = new Label(composite3, 16384);
            label2.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_application_path_label"));
            gridData = new GridData();
            label2.setLayoutData((Object)new GridData());
            this.appPath = new Text(composite3, 2048);
            gridData = new GridData(1808);
            gridData.widthHint = 250;
            gridData.horizontalSpan = 2;
            this.appPath.setLayoutData((Object)gridData);
            if (this.appPathInit != null) {
                this.appPath.setText(this.appPathInit);
            }
            Label label3 = new Label(composite3, 16384);
            label3.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_xml_label"));
            gridData = new GridData();
            label3.setLayoutData((Object)new GridData());
            this.xmlPath = new Text(composite3, 2048);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.xmlPath.setLayoutData((Object)gridData);
            this.xmlPath.setLayoutData((Object)gridData);
            if (this.xmlPathInit != null) {
                this.xmlPath.setText(this.xmlPathInit);
            }
            Button button = new Button(composite3, 8);
            gridData = new GridData();
            button.setLayoutData((Object)gridData);
            ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
            Image image = iSharedImages.getImage("IMG_OBJ_FILE");
            button.setImage(image);
            button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FileDialog fileDialog = new FileDialog(EditDialog.this.getShell());
                    String string = fileDialog.open();
                    if (string != null) {
                        EditDialog.this.xmlPath.setText(string);
                    }
                    EditDialog.this.updateButtons();
                }
            });
            Label label4 = new Label(composite3, 16384);
            label4.setText(Messages.getString("ApplicationSpecificPreferencePage.dialog_jsdl_label"));
            gridData = new GridData();
            label4.setLayoutData((Object)new GridData());
            this.jsdlPath = new Text(composite3, 2048);
            gridData = new GridData(768);
            gridData.grabExcessHorizontalSpace = true;
            this.jsdlPath.setLayoutData((Object)gridData);
            this.jsdlPath.setLayoutData((Object)gridData);
            if (this.jsdlPathInit != null) {
                this.jsdlPath.setText(this.jsdlPathInit);
            }
            Button button2 = new Button(composite3, 8);
            gridData = new GridData();
            button2.setLayoutData((Object)gridData);
            button2.setImage(image);
            button2.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    FileDialog fileDialog = new FileDialog(EditDialog.this.getShell());
                    String string = fileDialog.open();
                    if (string != null) {
                        EditDialog.this.jsdlPath.setText(string);
                    }
                    EditDialog.this.updateButtons();
                }
            });
            updateAdapter updateAdapter2 = new updateAdapter();
            this.appName.addModifyListener((ModifyListener)updateAdapter2);
            this.appPath.addModifyListener((ModifyListener)updateAdapter2);
            this.xmlPath.addModifyListener((ModifyListener)updateAdapter2);
            return composite2;
        }

        protected void okPressed() {
            this.returnAppName = this.appName.getText();
            this.returnAppPath = this.appPath.getText();
            this.returnXMLPath = this.xmlPath.getText();
            this.returnJSDLPath = this.jsdlPath.getText();
            super.okPressed();
        }

        public String getAppName() {
            return this.returnAppName;
        }

        public String getAppPath() {
            return this.returnAppPath;
        }

        public String getXMLPath() {
            return this.returnXMLPath;
        }

        public String getJSDLPath() {
            return this.returnJSDLPath;
        }

        class updateAdapter
        implements ModifyListener {
            updateAdapter() {
            }

            public void modifyText(ModifyEvent modifyEvent) {
                EditDialog.this.updateButtons();
            }
        }
    }
}

