/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.properties;

import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.model.RangeValueType;
import eu.geclipse.jsdl.ui.properties.Messages;
import eu.geclipse.ui.properties.AbstractProperty;
import eu.geclipse.ui.properties.AbstractPropertySource;
import eu.geclipse.ui.properties.IProperty;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsdlJobDescSource
extends AbstractPropertySource<JSDLJobDescription> {
    private static List<IProperty<JSDLJobDescription>> staticProperties;

    public JsdlJobDescSource(JSDLJobDescription jSDLJobDescription) {
        super((Object)jSDLJobDescription);
    }

    protected Class<? extends AbstractPropertySource<?>> getPropertySourceClass() {
        return JsdlJobDescSource.class;
    }

    protected List<IProperty<JSDLJobDescription>> getStaticProperties() {
        if (staticProperties == null) {
            staticProperties = JsdlJobDescSource.createProperties();
        }
        return staticProperties;
    }

    private static List<IProperty<JSDLJobDescription>> createProperties() {
        ArrayList<IProperty<JSDLJobDescription>> arrayList = new ArrayList<IProperty<JSDLJobDescription>>(10);
        arrayList.add(JsdlJobDescSource.createCpuArchitecture());
        arrayList.add(JsdlJobDescSource.createFSMountPoint());
        arrayList.add(JsdlJobDescSource.createFSDiskSpace());
        arrayList.add(JsdlJobDescSource.createFSFileSystemType());
        arrayList.add(JsdlJobDescSource.createOSType());
        arrayList.add(JsdlJobDescSource.createOSVersion());
        return arrayList;
    }

    private static IProperty<JSDLJobDescription> createCpuArchitecture() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_CpuArchitecture, Messages.JsdlJobDescSource_Requirements, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                return jSDLJobDescription.getCpuArchitectureName();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createFSMountPoint() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_MountPoint, Messages.JsdlJobDescSource_RequirementsFS, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                return jSDLJobDescription.getFilesystemMountPoint();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createFSDiskSpace() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_DiskSpace, Messages.JsdlJobDescSource_RequirementsFS, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                StringBuilder stringBuilder = new StringBuilder();
                RangeValueType rangeValueType = jSDLJobDescription.getFilesystemDiskSpace();
                if (rangeValueType != null) {
                    if (rangeValueType.getLowerBoundedRange() != null) {
                        stringBuilder.append(Messages.JsdlJobDescSource_Min);
                        stringBuilder.append(this.getBytesFormattedString(rangeValueType.getLowerBoundedRange().getValue()));
                    }
                    if (rangeValueType.getUpperBoundedRange() != null) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(" - ");
                        }
                        stringBuilder.append(Messages.JsdlJobDescSource_Max);
                        stringBuilder.append(this.getBytesFormattedString(rangeValueType.getUpperBoundedRange().getValue()));
                    }
                }
                return stringBuilder.length() > 0 ? stringBuilder.toString() : null;
            }
        };
    }

    private static IProperty<JSDLJobDescription> createFSFileSystemType() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_FileSystem, Messages.JsdlJobDescSource_RequirementsFS, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                return jSDLJobDescription.getFilesystemType();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createOSType() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_OS, Messages.JsdlJobDescSource_RequirementsOS, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                return jSDLJobDescription.getOSTypeName();
            }
        };
    }

    private static IProperty<JSDLJobDescription> createOSVersion() {
        return new AbstractProperty<JSDLJobDescription>(Messages.JsdlJobDescSource_OSVersion, Messages.JsdlJobDescSource_RequirementsOS, false){

            public Object getValue(JSDLJobDescription jSDLJobDescription) {
                return jSDLJobDescription.getOSVersion();
            }
        };
    }
}

