/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.providers;

import eu.geclipse.jsdl.model.DataStagingType;
import eu.geclipse.jsdl.ui.internal.Activator;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class DataStageOutLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private Image stageOutImage;
    private Image stageInOutImage;

    public DataStageOutLabelProvider() {
        this.loadImages();
    }

    public Image getColumnImage(Object object, int n) {
        Image image = null;
        if (object instanceof DataStagingType) {
            DataStagingType dataStagingType = (DataStagingType)object;
            switch (n) {
                case 0: {
                    if (dataStagingType.getSource() != null && dataStagingType.getTarget() != null) {
                        image = this.stageInOutImage;
                        break;
                    }
                    if (dataStagingType.getTarget() == null) break;
                    image = this.stageOutImage;
                    break;
                }
            }
        }
        return image;
    }

    public String getColumnText(Object object, int n) {
        DataStagingType dataStagingType;
        String string = null;
        if (object instanceof DataStagingType && (dataStagingType = (DataStagingType)object).getTarget() != null) {
            switch (n) {
                case 0: {
                    string = dataStagingType.getFileName();
                    break;
                }
                case 1: {
                    string = dataStagingType.getTarget().getURI();
                    break;
                }
                case 2: {
                    string = dataStagingType.getCreationFlag().getName();
                    break;
                }
                case 3: {
                    string = Boolean.toString(dataStagingType.isDeleteOnTermination());
                    break;
                }
            }
        }
        return string;
    }

    void loadImages() {
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/stage-out.gif");
        URL uRL2 = Activator.getDefault().getBundle().getEntry("icons/stage-in-out.gif");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        ImageDescriptor imageDescriptor2 = ImageDescriptor.createFromURL((URL)uRL2);
        this.stageOutImage = imageDescriptor.createImage();
        this.stageInOutImage = imageDescriptor2.createImage();
    }
}

