/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl.ui.wizards;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.jsdl.JSDLJobDescription;
import eu.geclipse.jsdl.model.DataStagingType;
import eu.geclipse.jsdl.ui.internal.Activator;
import eu.geclipse.jsdl.ui.internal.wizards.FileType;
import eu.geclipse.jsdl.ui.wizards.DataStagingNewJobWizardPage;
import eu.geclipse.jsdl.ui.wizards.ExecutableNewJobWizardPage;
import eu.geclipse.jsdl.ui.wizards.Messages;
import eu.geclipse.jsdl.ui.wizards.specific.IApplicationSpecificPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.INewWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.WizardNewFileCreationPage;
import org.eclipse.ui.ide.IDE;

public class NewJobWizard
extends Wizard
implements INewWizard {
    private IStructuredSelection selection;
    private WizardNewFileCreationPage firstPage;
    private IFile file;
    private ExecutableNewJobWizardPage executablePage;
    private DataStagingNewJobWizardPage outputFilesPage;
    private JSDLJobDescription basicJSDL;
    private String appName = "";

    public void addPages() {
        this.firstPage = new FirstPage(Messages.getString("NewJobWizard.first_page_name"), this.selection);
        this.firstPage.setTitle(Messages.getString("NewJobWizard.first_page_title"));
        this.firstPage.setDescription(Messages.getString("NewJobWizard.first_page_description"));
        this.firstPage.setFileName(Messages.getString("NewJobWizard.first_page_default_new_file_name"));
        this.addPage((IWizardPage)this.firstPage);
        ArrayList<WizardPage> arrayList = new ArrayList<WizardPage>();
        this.outputFilesPage = new DataStagingNewJobWizardPage(Messages.getString("NewJobWizard.files_output_new_job_page_name"));
        arrayList.add(this.outputFilesPage);
        this.executablePage = new ExecutableNewJobWizardPage(Messages.getString("NewJobWizard.executablePageName"), arrayList);
        this.addPage((IWizardPage)this.executablePage);
    }

    public void init(IWorkbench iWorkbench, IStructuredSelection iStructuredSelection) {
        this.setWindowTitle(Messages.getString("NewJobWizard.windowTitle"));
        this.selection = iStructuredSelection;
    }

    public boolean performFinish() {
        boolean bl = false;
        IRunnableWithProgress iRunnableWithProgress = new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException {
                try {
                    NewJobWizard.this.createFile(iProgressMonitor);
                }
                finally {
                    iProgressMonitor.done();
                }
            }
        };
        try {
            this.getContainer().run(false, true, iRunnableWithProgress);
            bl = true;
            this.openFile();
        }
        catch (InterruptedException interruptedException) {
            bl = false;
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getTargetException();
            MessageDialog.openError((Shell)this.getShell(), (String)Messages.getString("NewJobWizard.error_title"), (String)throwable.getMessage());
            bl = false;
        }
        return bl;
    }

    private void openFile() {
        try {
            IDE.openEditor((IWorkbenchPage)Activator.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)this.file, (boolean)true);
        }
        catch (PartInitException partInitException) {
            Activator.logException(partInitException);
        }
    }

    IPath getProject() {
        return this.firstPage.getContainerFullPath();
    }

    protected void createFile(IProgressMonitor iProgressMonitor) {
        iProgressMonitor.beginTask(String.valueOf(Messages.getString("NewJobWizard.creating_task")) + this.firstPage.getFileName(), 2);
        this.file = this.firstPage.createNewFile();
        JSDLJobDescription jSDLJobDescription = null;
        IGridElement iGridElement = GridModel.getRoot().findElement((IResource)this.file);
        if (iGridElement instanceof JSDLJobDescription) {
            jSDLJobDescription = (JSDLJobDescription)iGridElement;
        }
        iProgressMonitor.worked(1);
        iProgressMonitor.setTaskName(String.valueOf(Messages.getString("NewJobWizard.setting_contents_task")) + this.firstPage.getFileName());
        if (jSDLJobDescription != null) {
            this.setInitialModel(jSDLJobDescription);
            jSDLJobDescription.save(this.file);
        }
        iProgressMonitor.worked(1);
    }

    void setInitialModel(JSDLJobDescription jSDLJobDescription) {
        List<DataStagingType> list2;
        String string;
        Object object;
        this.executablePage.getApplicationSpecificPage();
        if (this.getContainer().getCurrentPage() != this.outputFilesPage) {
            object = this.executablePage.getBasicJSDL();
            string = this.executablePage.getApplicationName();
            if (!string.equals(this.appName)) {
                this.updateBasicJSDL((JSDLJobDescription)object, string);
                if (this.basicJSDL != null) {
                    jSDLJobDescription.setRoot(this.basicJSDL.getRoot());
                } else {
                    jSDLJobDescription.createRoot();
                    jSDLJobDescription.addJobDescription();
                }
            } else if (this.basicJSDL != null) {
                this.basicJSDL.removeDataStaging();
                jSDLJobDescription.setRoot(this.basicJSDL.getRoot());
            } else {
                jSDLJobDescription.createRoot();
                jSDLJobDescription.addJobDescription();
            }
        } else if (this.basicJSDL != null) {
            this.basicJSDL.removeDataStaging();
            jSDLJobDescription.setRoot(this.basicJSDL.getRoot());
        } else {
            jSDLJobDescription.createRoot();
            jSDLJobDescription.addJobDescription();
        }
        jSDLJobDescription.addJobIdentification(this.executablePage.getApplicationName(), null);
        object = "";
        object = this.executablePage.getApplicationName().equals("") ? "example_name" : this.executablePage.getApplicationName();
        jSDLJobDescription.addApplication();
        string = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        string = this.executablePage.getStdin();
        string2 = this.executablePage.getStdout();
        string3 = this.executablePage.getStderr();
        if (string.equals("")) {
            string = null;
        } else {
            string4 = "stdIn";
        }
        if (string2.equals("")) {
            string2 = null;
        } else {
            string5 = "stdOut";
        }
        if (string3.equals("")) {
            string3 = null;
        } else {
            string6 = "stdErr";
        }
        String object2 = this.executablePage.getExecutableFile();
        if (!object2.equals("")) {
            try {
                list2 = new URI(object2);
                if (((URI)((Object)list2)).getScheme() != null) {
                    String list3 = ((URI)((Object)list2)).toString().substring(((URI)((Object)list2)).toString().lastIndexOf("/") + 1, ((URI)((Object)list2)).toString().length());
                    jSDLJobDescription.setInDataStaging(list3, object2);
                    object2 = list3;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            jSDLJobDescription.addPOSIXApplicationDetails((String)object, object2, string, string4, string2, string5, string3, string6);
        }
        if (this.outputFilesPage.isCreated()) {
            list2 = this.outputFilesPage.getFiles(FileType.OUTPUT);
            if (!list2.isEmpty()) {
                for (DataStagingType dataStagingType : list2) {
                    jSDLJobDescription.addDataStagingType(dataStagingType);
                }
            }
            if (!(list2 = this.outputFilesPage.getFiles(FileType.INPUT)).isEmpty()) {
                for (DataStagingType dataStagingType : list2) {
                    jSDLJobDescription.addDataStagingType(dataStagingType);
                }
            }
        }
        list2 = this.executablePage.getArgumentsList();
        for (String string7 : list2) {
            jSDLJobDescription.addArgument(string7);
        }
        List<IApplicationSpecificPage> list = this.executablePage.getApplicationSpecificPages();
        if (list != null) {
            for (IApplicationSpecificPage iApplicationSpecificPage : list) {
                Object object3;
                Object object4;
                Object object5;
                Object object62;
                Map<String, ArrayList<String>> map = iApplicationSpecificPage.getParametersValues();
                if (map != null) {
                    for (Object object62 : map.keySet()) {
                        jSDLJobDescription.addArgumentForPosixApplication((String)object62, (ArrayList)map.get(object62));
                    }
                }
                if ((object62 = iApplicationSpecificPage.getStageInFiles()) == null) continue;
                for (String string8 : object62.keySet()) {
                    Enumeration<?> enumeration = ((Properties)object62.get(string8)).propertyNames();
                    object5 = new ArrayList<String>();
                    while (enumeration.hasMoreElements()) {
                        ((ArrayList)object5).add((String)enumeration.nextElement());
                    }
                    jSDLJobDescription.addArgumentForPosixApplication(string8, object5);
                    object4 = ((ArrayList)object5).iterator();
                    while (object4.hasNext()) {
                        object3 = (String)object4.next();
                        jSDLJobDescription.setInDataStaging((String)object3, ((Properties)object62.get(string8)).getProperty((String)object3));
                    }
                }
                Map<String, Properties> map2 = iApplicationSpecificPage.getStageOutFiles();
                if (map2 == null) continue;
                for (Object object7 : map2.keySet()) {
                    object5 = map2.get(object7).propertyNames();
                    object3 = new ArrayList<String>();
                    while (object5.hasMoreElements()) {
                        ((ArrayList)object3).add((String)object5.nextElement());
                    }
                    jSDLJobDescription.addArgumentForPosixApplication((String)object7, (ArrayList)object3);
                    Iterator iterator = ((ArrayList)object3).iterator();
                    while (iterator.hasNext()) {
                        object4 = (String)iterator.next();
                        jSDLJobDescription.setOutDataStaging((String)object4, map2.get(object7).getProperty((String)object4));
                    }
                }
            }
        }
        jSDLJobDescription.getDataStagingIn();
        jSDLJobDescription.getLocalDataStagingIn();
        jSDLJobDescription.getStdInputDataType();
    }

    void updateBasicJSDL(JSDLJobDescription jSDLJobDescription, String string) {
        boolean bl = false;
        if (this.basicJSDL != null) {
            bl = true;
        }
        this.basicJSDL = jSDLJobDescription;
        this.appName = string;
        if (this.basicJSDL != null) {
            this.outputFilesPage.setInitialStagingOutModel(this.basicJSDL.getDataStagingOut());
            this.outputFilesPage.setInitialStagingInModel(this.basicJSDL.getDataStagingIn());
        } else if (!bl) {
            this.outputFilesPage.setInitialStagingInModel(this.outputFilesPage.getFiles(FileType.INPUT));
            this.outputFilesPage.setInitialStagingOutModel(this.outputFilesPage.getFiles(FileType.OUTPUT));
        } else {
            this.outputFilesPage.setInitialStagingOut(null);
            this.outputFilesPage.setInitialStagingIn(null);
        }
    }

    public boolean canFinish() {
        return super.canFinish();
    }

    class FirstPage
    extends WizardNewFileCreationPage {
        private IStructuredSelection iniSelection;

        public FirstPage(String string, IStructuredSelection iStructuredSelection) {
            super(string, iStructuredSelection);
            this.iniSelection = iStructuredSelection;
        }

        protected boolean validatePage() {
            boolean bl = true;
            if (!super.validatePage()) {
                bl = false;
            }
            if (!this.getFilePath().toString().endsWith(".jsdl")) {
                this.setErrorMessage(Messages.getString("NewJobWizard.wrong_file_extension_error_message"));
                bl = false;
            }
            return bl;
        }

        protected IPath getFilePath() {
            String string;
            IPath iPath = this.getContainerFullPath();
            if (iPath == null) {
                iPath = new Path("");
            }
            if ((string = this.getFileName()) != null) {
                iPath = iPath.append(string);
            }
            return iPath;
        }

        protected void initialPopulateContainerNameField() {
            Object object = this.iniSelection.getFirstElement();
            if (object instanceof IGridContainer) {
                IPath iPath;
                IPath iPath2;
                IGridElement iGridElement;
                IGridElement iGridElement2 = (IGridElement)object;
                IGridProject iGridProject = iGridElement2.getProject();
                if (iGridProject != null && (iGridElement = iGridProject.findChild(IGridProject.DIR_JOBDESCRIPTIONS)) != null && !(iPath2 = iGridElement.getPath()).isPrefixOf(iPath = iGridElement2.getPath())) {
                    iGridElement2 = iGridElement;
                }
                super.setContainerFullPath(iGridElement2.getPath());
            } else {
                super.initialPopulateContainerNameField();
            }
        }
    }
}

