/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.jsdl;

import eu.geclipse.core.model.IGridJobDescription;
import eu.geclipse.core.model.impl.ResourceGridContainer;
import eu.geclipse.jsdl.internal.JsdlAdaptersPlugin;
import eu.geclipse.jsdl.model.ApplicationType;
import eu.geclipse.jsdl.model.BoundaryType;
import eu.geclipse.jsdl.model.CPUArchitectureType;
import eu.geclipse.jsdl.model.CandidateHostsType;
import eu.geclipse.jsdl.model.CreationFlagEnumeration;
import eu.geclipse.jsdl.model.DataStagingType;
import eu.geclipse.jsdl.model.DocumentRoot;
import eu.geclipse.jsdl.model.ExactType;
import eu.geclipse.jsdl.model.JobDefinitionType;
import eu.geclipse.jsdl.model.JobDescriptionType;
import eu.geclipse.jsdl.model.JobIdentificationType;
import eu.geclipse.jsdl.model.JsdlFactory;
import eu.geclipse.jsdl.model.JsdlPackage;
import eu.geclipse.jsdl.model.OperatingSystemType;
import eu.geclipse.jsdl.model.OperatingSystemTypeEnumeration;
import eu.geclipse.jsdl.model.OperatingSystemTypeType;
import eu.geclipse.jsdl.model.ProcessorArchitectureEnumeration;
import eu.geclipse.jsdl.model.RangeType;
import eu.geclipse.jsdl.model.RangeValueType;
import eu.geclipse.jsdl.model.ResourcesType;
import eu.geclipse.jsdl.model.SourceTargetType;
import eu.geclipse.jsdl.model.posix.ArgumentType;
import eu.geclipse.jsdl.model.posix.FileNameType;
import eu.geclipse.jsdl.model.posix.POSIXApplicationType;
import eu.geclipse.jsdl.model.posix.PosixFactory;
import eu.geclipse.jsdl.model.posix.PosixPackage;
import eu.geclipse.jsdl.model.posix.impl.POSIXApplicationTypeImpl;
import eu.geclipse.jsdl.model.util.JsdlResourceFactoryImpl;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xmi.impl.XMLMapImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JSDLJobDescription
extends ResourceGridContainer
implements IGridJobDescription {
    private static final String UTF_8 = "UTF-8";
    protected JsdlPackage jsdlPackage = JsdlPackage.eINSTANCE;
    protected PosixPackage posixPackage = PosixPackage.eINSTANCE;
    protected JsdlFactory jsdlFactory = this.jsdlPackage.getJsdlFactory();
    protected PosixFactory posixFactory = this.posixPackage.getPosixFactory();
    private Resource resource = null;
    private JobDefinitionType jobDefinition;
    private JobDescriptionType jobDescription;
    private JobIdentificationType jobIdentification;
    private DocumentRoot documentRoot;

    public JSDLJobDescription(IFile iFile) {
        super((IResource)iFile);
        try {
            if (iFile.getContents().read() != -1) {
                this.loadModel(iFile);
            }
        }
        catch (CoreException coreException) {
        }
        catch (IOException iOException) {}
    }

    public void loadModel(IFile iFile) {
        String string = iFile.getFullPath().toString();
        URI uRI = URI.createPlatformResourceURI((String)string, (boolean)false);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource resource = resourceSetImpl.createResource(uRI);
        XMLMapImpl xMLMapImpl = new XMLMapImpl();
        xMLMapImpl.setNoNamespacePackage((EPackage)JsdlPackage.eINSTANCE);
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("XML_MAP", xMLMapImpl);
        hashMap.put("ENCODING", "UTF8");
        try {
            resource.load(hashMap);
            this.documentRoot = (DocumentRoot)resource.getContents().get(0);
            this.jobDefinition = this.documentRoot.getJobDefinition();
            this.jobDescription = this.jobDefinition.getJobDescription();
            this.jobIdentification = this.documentRoot.getJobIdentification();
        }
        catch (IOException iOException) {
            JsdlAdaptersPlugin.logException(iOException);
        }
    }

    public DocumentRoot getRoot() {
        return this.documentRoot;
    }

    public void setRoot(DocumentRoot documentRoot) {
        this.documentRoot = documentRoot;
        if (documentRoot.getJobDefinition() != null) {
            this.jobDefinition = documentRoot.getJobDefinition();
            if (this.jobDefinition.getJobDescription() != null) {
                this.jobDescription = this.jobDefinition.getJobDescription();
            }
        }
    }

    public void save(IFile iFile) {
        this.writeModelToFile((EObject)this.documentRoot, iFile);
    }

    public String getJSDLString() throws IOException {
        String string;
        String string2 = null;
        File file = this.getPath().toFile();
        FileInputStream fileInputStream = null;
        fileInputStream = new FileInputStream(file);
        InputStreamReader inputStreamReader = new InputStreamReader(fileInputStream);
        BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
        while ((string = bufferedReader.readLine()) != null) {
            string2 = String.valueOf(string2) + string;
        }
        return string2;
    }

    private void writeModelToFile(EObject eObject, IFile iFile) {
        String string = iFile.getFullPath().toString();
        URI uRI = URI.createPlatformResourceURI((String)string, (boolean)false);
        ResourceSetImpl resourceSetImpl = new ResourceSetImpl();
        Resource.Factory.Registry registry = resourceSetImpl.getResourceFactoryRegistry();
        Map map = registry.getExtensionToFactoryMap();
        map.put("jsdl", new JsdlResourceFactoryImpl());
        this.resource = resourceSetImpl.createResource(uRI);
        if (eObject != null) {
            this.resource.getContents().add((Object)eObject);
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("ENCODING", UTF_8);
        try {
            this.resource.save(hashMap);
        }
        catch (IOException iOException) {
            JsdlAdaptersPlugin.logException(iOException);
        }
    }

    protected void addContent() {
        this.jobIdentification = this.jsdlFactory.createJobIdentificationType();
        this.jobDescription = this.jsdlFactory.createJobDescriptionType();
        this.jobDefinition = this.jsdlFactory.createJobDefinitionType();
        this.jobDefinition.setJobDescription(this.jobDescription);
        this.jobDescription.setJobIdentification(this.jobIdentification);
    }

    public void createRoot() {
        this.documentRoot = this.jsdlFactory.createDocumentRoot();
        this.jobDefinition = this.jsdlFactory.createJobDefinitionType();
        this.documentRoot.setJobDefinition(this.jobDefinition);
    }

    public void addJobDescription() {
        this.jobDescription = this.jsdlFactory.createJobDescriptionType();
        this.jobDefinition.setJobDescription(this.jobDescription);
    }

    public void addJobIdentification(String string, String string2) {
        JobIdentificationType jobIdentificationType = this.jsdlFactory.createJobIdentificationType();
        if (!"".equals(string2)) {
            jobIdentificationType.setDescription(string2);
        } else {
            jobIdentificationType.setDescription("default description");
        }
        if (!"".equals(string)) {
            jobIdentificationType.setJobName(string);
        } else {
            jobIdentificationType.setJobName("default job name");
        }
        this.jobDescription.setJobIdentification(jobIdentificationType);
    }

    public void addApplication() {
        ApplicationType applicationType = this.jsdlFactory.createApplicationType();
        this.jobDescription.setApplication(applicationType);
    }

    public void addPOSIXApplicationDetails(String string, String string2, String string3, String string4, String string5, String string6, String string7, String string8) {
        SourceTargetType sourceTargetType;
        DataStagingType dataStagingType;
        FileNameType fileNameType;
        this.jobDescription.getApplication().setApplicationName(string);
        POSIXApplicationType pOSIXApplicationType = this.posixFactory.createPOSIXApplicationType();
        FileNameType fileNameType2 = this.posixFactory.createFileNameType();
        fileNameType2.setValue(string2);
        pOSIXApplicationType.setExecutable(fileNameType2);
        if (string3 != null) {
            fileNameType = this.posixFactory.createFileNameType();
            fileNameType.setValue(string4);
            pOSIXApplicationType.setInput(fileNameType);
        }
        if (string5 != null) {
            fileNameType = this.posixFactory.createFileNameType();
            fileNameType.setValue(string6);
            pOSIXApplicationType.setOutput(fileNameType);
        }
        if (string7 != null) {
            fileNameType = this.posixFactory.createFileNameType();
            fileNameType.setValue(string8);
            pOSIXApplicationType.setError(fileNameType);
        }
        fileNameType = this.jobDescription.getApplication();
        EClass eClass = ExtendedMetaData.INSTANCE.getDocumentRoot((EPackage)this.posixPackage);
        FeatureMap.Entry entry = FeatureMapUtil.createEntry((EStructuralFeature)eClass.getEStructuralFeature("pOSIXApplication"), (Object)pOSIXApplicationType);
        fileNameType.getAny().add((Object)entry);
        if (string3 != null) {
            dataStagingType = this.jsdlFactory.createDataStagingType();
            dataStagingType.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataStagingType.setDeleteOnTermination(false);
            dataStagingType.setFileName(string4);
            sourceTargetType = this.jsdlFactory.createSourceTargetType();
            sourceTargetType.setURI(string3);
            dataStagingType.setSource(sourceTargetType);
            this.jobDescription.getDataStaging().add((Object)dataStagingType);
        }
        if (string5 != null) {
            dataStagingType = this.jsdlFactory.createDataStagingType();
            dataStagingType.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataStagingType.setDeleteOnTermination(false);
            dataStagingType.setFileName(string6);
            sourceTargetType = this.jsdlFactory.createSourceTargetType();
            sourceTargetType.setURI(string5);
            dataStagingType.setTarget(sourceTargetType);
            this.jobDescription.getDataStaging().add((Object)dataStagingType);
        }
        if (string7 != null) {
            dataStagingType = this.jsdlFactory.createDataStagingType();
            dataStagingType.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
            dataStagingType.setDeleteOnTermination(false);
            dataStagingType.setFileName(string8);
            sourceTargetType = this.jsdlFactory.createSourceTargetType();
            sourceTargetType.setURI(string7);
            dataStagingType.setTarget(sourceTargetType);
            this.jobDescription.getDataStaging().add((Object)dataStagingType);
        }
    }

    public void setOutDataStaging(String string, String string2) {
        DataStagingType dataStagingType = this.jsdlFactory.createDataStagingType();
        dataStagingType.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
        dataStagingType.setDeleteOnTermination(true);
        dataStagingType.setFileName(string);
        SourceTargetType sourceTargetType = this.jsdlFactory.createSourceTargetType();
        sourceTargetType.setURI(string2);
        dataStagingType.setTarget(sourceTargetType);
        this.jobDescription.getDataStaging().add((Object)dataStagingType);
    }

    public void setInDataStaging(String string, String string2) {
        DataStagingType dataStagingType = this.jsdlFactory.createDataStagingType();
        dataStagingType.setCreationFlag(CreationFlagEnumeration.OVERWRITE_LITERAL);
        dataStagingType.setDeleteOnTermination(true);
        dataStagingType.setFileName(string);
        SourceTargetType sourceTargetType = this.jsdlFactory.createSourceTargetType();
        sourceTargetType.setURI(string2);
        dataStagingType.setSource(sourceTargetType);
        this.jobDescription.getDataStaging().add((Object)dataStagingType);
    }

    protected DocumentRoot getDocumentRoot() {
        if (this.documentRoot == null) {
            this.loadModel((IFile)this.getResource());
        }
        return this.documentRoot;
    }

    protected POSIXApplicationType getPosixApplication() {
        POSIXApplicationTypeImpl pOSIXApplicationTypeImpl = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && this.getJobDescription(documentRoot).getApplication() != null) {
            FeatureMap featureMap = this.getJobDescription(documentRoot).getApplication().getAny();
            int n = 0;
            while (n < featureMap.size()) {
                if (featureMap.getValue(n) instanceof POSIXApplicationTypeImpl) {
                    pOSIXApplicationTypeImpl = (POSIXApplicationTypeImpl)featureMap.getValue(n);
                }
                ++n;
            }
        }
        return pOSIXApplicationTypeImpl;
    }

    public String getExecutable() {
        String string = null;
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (pOSIXApplicationType != null && pOSIXApplicationType.getExecutable() != null) {
            string = pOSIXApplicationType.getExecutable().getValue();
        }
        return string;
    }

    public String getDescription() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && this.getJobDescription(documentRoot).getJobIdentification() != null) {
            string = this.getJobDescription(documentRoot).getJobIdentification().getDescription();
        }
        return string;
    }

    public List<String> getExecutableArguments() {
        ArrayList<String> arrayList = null;
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (pOSIXApplicationType != null && !pOSIXApplicationType.getArgument().isEmpty()) {
            arrayList = new ArrayList<String>();
            for (Object e : pOSIXApplicationType.getArgument()) {
                arrayList.add(((ArgumentType)e).getValue());
            }
        }
        return arrayList;
    }

    public String getCpuArchitectureName() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && this.getJobDescription(documentRoot).getResources() != null && this.getJobDescription(documentRoot).getResources().getCPUArchitecture() != null && this.getJobDescription(documentRoot).getResources().getCPUArchitecture().getCPUArchitectureName() != null) {
            string = this.getJobDescription(documentRoot).getResources().getCPUArchitecture().getCPUArchitectureName().getName();
        }
        return string;
    }

    public String getFilesystemType() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getFileSystemType() != null) {
            string = documentRoot.getFileSystemType().getName();
        }
        return string;
    }

    public String getFilesystemMountPoint() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null) {
            string = this.getDocumentRoot().getMountPoint();
        }
        return string;
    }

    public RangeValueType getFilesystemDiskSpace() {
        RangeValueType rangeValueType = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getFileSystem() != null) {
            rangeValueType = documentRoot.getFileSystem().getDiskSpace();
        }
        return rangeValueType;
    }

    public String getOSTypeName() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null && documentRoot.getJobDefinition().getJobDescription().getResources() != null && documentRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem() != null && this.getJobDescription(documentRoot).getResources().getOperatingSystem().getOperatingSystemType() != null && documentRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemType().getOperatingSystemName() != null) {
            string = documentRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemType().getOperatingSystemName().getName();
        }
        return string;
    }

    public String getOSVersion() {
        String string = null;
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null && documentRoot.getJobDefinition().getJobDescription().getResources() != null && documentRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem() != null) {
            string = documentRoot.getJobDefinition().getJobDescription().getResources().getOperatingSystem().getOperatingSystemVersion();
        }
        return string;
    }

    public void addArgumentForPosixApplication(String string, ArrayList<String> arrayList) {
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (arrayList != null && !arrayList.isEmpty() && pOSIXApplicationType != null) {
            ArgumentType argumentType;
            EList eList = pOSIXApplicationType.getArgument();
            if (string != null && !string.equals("")) {
                argumentType = this.posixFactory.createArgumentType();
                argumentType.setValue(string);
                eList.add((Object)argumentType);
            }
            for (String string2 : arrayList) {
                if (string2.equals("")) continue;
                argumentType = this.posixFactory.createArgumentType();
                argumentType.setValue(string2);
                eList.add((Object)argumentType);
            }
        }
    }

    public void addArgument(String string) {
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (pOSIXApplicationType != null) {
            EList eList = pOSIXApplicationType.getArgument();
            if (string != null && !string.equals("")) {
                ArgumentType argumentType = this.posixFactory.createArgumentType();
                argumentType.setValue(string);
                eList.add((Object)argumentType);
            }
        }
    }

    public String getInput() {
        String string = null;
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (pOSIXApplicationType != null && pOSIXApplicationType.getInput() != null) {
            string = pOSIXApplicationType.getInput().getValue();
        }
        return string;
    }

    public String getOutput() {
        String string = null;
        POSIXApplicationType pOSIXApplicationType = this.getPosixApplication();
        if (pOSIXApplicationType != null && pOSIXApplicationType.getOutput() != null) {
            string = pOSIXApplicationType.getOutput().getValue();
        }
        return string;
    }

    public static List<String> getOSTypes() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : OperatingSystemTypeEnumeration.VALUES) {
            arrayList.add(e.toString());
        }
        return arrayList;
    }

    public static List<String> getCPUArchitectures() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (Object e : ProcessorArchitectureEnumeration.VALUES) {
            arrayList.add(e.toString());
        }
        return arrayList;
    }

    public void setCPUArchitecture(String string) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            CPUArchitectureType cPUArchitectureType = this.jsdlFactory.createCPUArchitectureType();
            cPUArchitectureType.setCPUArchitectureName(ProcessorArchitectureEnumeration.getByName((String)string));
            resourcesType.setCPUArchitecture(cPUArchitectureType);
        }
    }

    public void setTotalCPUCount(double d, double d2, boolean bl) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getTotalCPUCount()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setTotalCPUCount(rangeValueType);
            }
            RangeType rangeType = this.jsdlFactory.createRangeType();
            BoundaryType boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d);
            rangeType.setLowerBound(boundaryType);
            boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d2);
            rangeType.setUpperBound(boundaryType);
            rangeValueType.getRange().add((Object)rangeType);
        }
    }

    public void addCandidateHosts(List<String> list) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            CandidateHostsType candidateHostsType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((candidateHostsType = resourcesType.getCandidateHosts()) == null) {
                candidateHostsType = this.jsdlFactory.createCandidateHostsType();
                resourcesType.setCandidateHosts(candidateHostsType);
            }
            for (String string : list) {
                candidateHostsType.getHostName().add((Object)string);
            }
        }
    }

    public void setOS(String string) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            OperatingSystemType operatingSystemType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((operatingSystemType = resourcesType.getOperatingSystem()) == null) {
                operatingSystemType = this.jsdlFactory.createOperatingSystemType();
                resourcesType.setOperatingSystem(operatingSystemType);
            }
            OperatingSystemTypeType operatingSystemTypeType = this.jsdlFactory.createOperatingSystemTypeType();
            operatingSystemTypeType.setOperatingSystemName(OperatingSystemTypeEnumeration.getByName((String)string));
            operatingSystemType.setOperatingSystemType(operatingSystemTypeType);
        }
    }

    public void setInidividialCPUSpeedRange(double d, double d2, boolean bl) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getIndividualCPUSpeed()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setIndividualCPUSpeed(rangeValueType);
            }
            RangeType rangeType = this.jsdlFactory.createRangeType();
            BoundaryType boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d);
            rangeType.setLowerBound(boundaryType);
            boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d2);
            rangeType.setUpperBound(boundaryType);
            rangeValueType.getRange().add((Object)rangeType);
        }
    }

    public void setTotalPhysicalMemory(double d, double d2, boolean bl) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getTotalPhysicalMemory()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setTotalPhysicalMemory(rangeValueType);
            }
            RangeType rangeType = this.jsdlFactory.createRangeType();
            BoundaryType boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d);
            rangeType.setLowerBound(boundaryType);
            boundaryType = this.jsdlFactory.createBoundaryType();
            boundaryType.setExclusiveBound(bl);
            boundaryType.setValue(d2);
            rangeType.setUpperBound(boundaryType);
            rangeValueType.getRange().add((Object)rangeType);
        }
    }

    public void setIndividualCPUSpeedValue(double d, double d2) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getIndividualCPUSpeed()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setIndividualCPUSpeed(rangeValueType);
            }
            ExactType exactType = this.jsdlFactory.createExactType();
            exactType.setValue(d);
            exactType.setEpsilon(d2);
            rangeValueType.getExact().add((Object)exactType);
        }
    }

    public void setTotalCPUCountValue(double d, double d2) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getTotalCPUCount()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setTotalCPUCount(rangeValueType);
            }
            ExactType exactType = this.jsdlFactory.createExactType();
            exactType.setValue(d);
            exactType.setEpsilon(d2);
            rangeValueType.getExact().add((Object)exactType);
        }
    }

    public void setTotalPhysicalMemoryValue(double d, double d2) {
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (documentRoot != null && documentRoot.getJobDefinition() != null && documentRoot.getJobDefinition().getJobDescription() != null) {
            RangeValueType rangeValueType;
            ResourcesType resourcesType = documentRoot.getJobDefinition().getJobDescription().getResources();
            if (resourcesType == null) {
                resourcesType = this.jsdlFactory.createResourcesType();
                documentRoot.getJobDefinition().getJobDescription().setResources(resourcesType);
            }
            if ((rangeValueType = resourcesType.getTotalPhysicalMemory()) == null) {
                rangeValueType = this.jsdlFactory.createRangeValueType();
                resourcesType.setTotalPhysicalMemory(rangeValueType);
            }
            ExactType exactType = this.jsdlFactory.createExactType();
            exactType.setValue(d);
            exactType.setEpsilon(d2);
            rangeValueType.getExact().add((Object)exactType);
        }
    }

    private JobDescriptionType getJobDescription(DocumentRoot documentRoot) {
        JobDescriptionType jobDescriptionType = null;
        if (documentRoot != null && documentRoot.getJobDefinition() != null) {
            jobDescriptionType = documentRoot.getJobDefinition().getJobDescription();
        }
        return jobDescriptionType;
    }

    public List<DataStagingType> getDataStagingIn() {
        EList eList;
        ArrayList<DataStagingType> arrayList = new ArrayList<DataStagingType>();
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && (eList = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataStagingType : eList) {
                if (dataStagingType.getSource() == null) continue;
                arrayList.add(dataStagingType);
            }
        }
        return arrayList;
    }

    public Map<String, String> getDataStagingInStrings() {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && (eList = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataStagingType : eList) {
                if (dataStagingType.getSource() == null) continue;
                hashMap.put(dataStagingType.getFileName(), dataStagingType.getSource().getURI());
            }
        }
        return hashMap;
    }

    public Map<String, String> getDataStagingOutStrings() {
        EList eList;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && (eList = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataStagingType : eList) {
                if (dataStagingType.getTarget() == null) continue;
                hashMap.put(dataStagingType.getFileName(), dataStagingType.getTarget().getURI());
            }
        }
        return hashMap;
    }

    public List<DataStagingType> getDataStagingOut() {
        EList eList;
        ArrayList<DataStagingType> arrayList = new ArrayList<DataStagingType>();
        DocumentRoot documentRoot = this.getDocumentRoot();
        if (this.getJobDescription(documentRoot) != null && (eList = this.jobDescription.getDataStaging()) != null) {
            for (DataStagingType dataStagingType : eList) {
                if (dataStagingType.getTarget() == null) continue;
                arrayList.add(dataStagingType);
            }
        }
        return arrayList;
    }

    public List<DataStagingType> getLocalDataStagingIn() {
        ArrayList<DataStagingType> arrayList = new ArrayList<DataStagingType>();
        for (DataStagingType dataStagingType : this.getDataStagingIn()) {
            try {
                java.net.URI uRI = new java.net.URI(dataStagingType.getSource().getURI());
                if (uRI == null || !uRI.getScheme().equals("file")) continue;
                arrayList.add(dataStagingType);
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
        }
        return arrayList;
    }

    public DataStagingType getStdInputDataType() {
        DataStagingType dataStagingType = null;
        if (this.getInput() != null) {
            for (DataStagingType dataStagingType2 : this.getDataStagingIn()) {
                if (!dataStagingType2.getFileName().equals(this.getInput())) continue;
                dataStagingType = dataStagingType2;
            }
        }
        return dataStagingType;
    }

    public void removeDataStaging() {
        this.jobDescription.getDataStaging().removeAll((Collection)this.jobDescription.getDataStaging());
    }

    public void addDataStagingType(DataStagingType dataStagingType) {
        this.jobDescription.getDataStaging().add((Object)dataStagingType);
    }
}

