/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.GridModelException;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.util.HostnameChecker;
import eu.geclipse.info.glue.AbstractGlueTable;
import eu.geclipse.info.glue.GlueQuery;
import eu.geclipse.terminal.ssh.internal.Activator;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import eu.geclipse.ui.widgets.NumberVerifier;
import eu.geclipse.ui.widgets.StoredCombo;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

class SSHConnectionComposite
extends Composite {
    private static final String sshDefaultPort = "22";
    private static final String USERNAMES = "usernames";
    private static final String HOSTNAMES = "hostnames";
    private Label usernameLabel = null;
    private StoredCombo usernameCombo = null;
    private Label hostnameLabel = null;
    private StoredCombo hostnameCombo = null;
    private Label passwordLabel = null;
    private Text passwordText = null;
    private Label portLabel = null;
    private Text portText = null;

    SSHConnectionComposite(Composite composite, int n, Listener listener) {
        super(composite, n);
        this.initialize();
        Activator activator = Activator.getDefault();
        IPreferenceStore iPreferenceStore = activator.getPreferenceStore();
        this.usernameCombo.setPreferences(iPreferenceStore, USERNAMES);
        this.hostnameCombo.setPreferences(iPreferenceStore, HOSTNAMES);
        this.usernameCombo.addListener(24, listener);
        this.hostnameCombo.addListener(24, listener);
        this.passwordText.addListener(24, listener);
        this.portText.addListener(24, listener);
        this.portText.addListener(25, (Listener)new NumberVerifier());
        GridData gridData = (GridData)this.portText.getLayoutData();
        GC gC = new GC((Drawable)this.portText);
        FontMetrics fontMetrics = gC.getFontMetrics();
        gridData.widthHint = 7 * fontMetrics.getAverageCharWidth();
        gC.dispose();
        this.addComputingElements();
    }

    private void addComputingElements() {
        try {
            IGridElement[] iGridElementArray;
            IGridElement[] iGridElementArray2 = iGridElementArray = GridModel.getVoManager().getChildren(null);
            int n = iGridElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IGridElement iGridElement = iGridElementArray2[n2];
                ArrayList arrayList = GlueQuery.getGlueTable((String)"GlueCE", (String)iGridElement.getName());
                for (AbstractGlueTable abstractGlueTable : arrayList) {
                    try {
                        String string = (String)abstractGlueTable.getFieldByName("HostName");
                        if (string == null || this.hostnameCombo.indexOf(string) != -1) continue;
                        this.hostnameCombo.add(string);
                    }
                    catch (RuntimeException runtimeException) {
                        Activator.logException(runtimeException);
                    }
                    catch (IllegalAccessException illegalAccessException) {
                        Activator.logException(illegalAccessException);
                    }
                    catch (NoSuchFieldException noSuchFieldException) {
                        Activator.logException(noSuchFieldException);
                    }
                }
                ++n2;
            }
        }
        catch (GridModelException gridModelException) {
            Activator.logException((Exception)((Object)gridModelException));
        }
    }

    private void initialize() {
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = false;
        gridData.verticalAlignment = 2;
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.horizontalSpan = 3;
        gridData2.verticalAlignment = 2;
        GridData gridData3 = new GridData();
        gridData3.horizontalAlignment = 4;
        gridData3.grabExcessHorizontalSpace = true;
        gridData3.verticalAlignment = 2;
        GridData gridData4 = new GridData();
        gridData4.horizontalAlignment = 4;
        gridData4.grabExcessHorizontalSpace = true;
        gridData4.horizontalSpan = 3;
        gridData4.verticalAlignment = 2;
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 4;
        this.hostnameLabel = new Label((Composite)this, 0);
        this.hostnameLabel.setText(Messages.getString("SSHConnectionComposite.hostName"));
        this.hostnameCombo = new StoredCombo((Composite)this, 4);
        this.hostnameCombo.setLayoutData((Object)gridData3);
        this.portLabel = new Label((Composite)this, 0);
        this.portLabel.setText(Messages.getString("SSHConnectionComposite.port"));
        this.portText = new Text((Composite)this, 2048);
        this.portText.setTextLimit(5);
        this.portText.setText(sshDefaultPort);
        this.portText.setLayoutData((Object)gridData);
        this.usernameLabel = new Label((Composite)this, 0);
        this.usernameLabel.setText(Messages.getString("SSHConnectionComposite.userName"));
        this.usernameCombo = new StoredCombo((Composite)this, 4);
        this.usernameCombo.setLayoutData((Object)gridData4);
        this.passwordLabel = new Label((Composite)this, 0);
        this.passwordLabel.setText(Messages.getString("SSHConnectionComposite.password"));
        this.passwordText = new Text((Composite)this, 0x400800);
        this.passwordText.setLayoutData((Object)gridData2);
        this.setLayout((Layout)gridLayout);
        this.setSize(new Point(300, 200));
    }

    IStatus getStatus() {
        Integer n = null;
        boolean bl = true;
        try {
            n = new Integer(this.portText.getText());
        }
        catch (NumberFormatException numberFormatException) {}
        if (n == null || n < 1 || n > 65535) {
            bl = false;
        }
        Status status = new Status(0, "eu.geclipse.terminal.ssh", 0, "", null);
        if (this.usernameCombo.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.userNameMustNotBeEmpty"), null);
        } else if (this.hostnameCombo.getText().length() == 0) {
            status = new Status(4, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.hostNameMustNotBeEmpty"), null);
        } else if (!bl) {
            status = new Status(4, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.AValidPortNumberMustBeEntered"), null);
        } else if (!HostnameChecker.checkHostname((String)this.hostnameCombo.getText())) {
            status = new Status(2, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.invalidHostname"), null);
        } else if (this.passwordText.getText().length() == 0) {
            status = new Status(1, "eu.geclipse.terminal.ssh", 0, Messages.getString("SSHConnectionComposite.passwordIsRequiredIfYouAreNotUsingPubKeyAuth"), null);
        }
        return status;
    }

    SSHConnectionInfo getConnectionInfo() {
        return new SSHConnectionInfo(this.usernameCombo.getText(), this.hostnameCombo.getText(), this.passwordText.getText(), null, new Integer(this.portText.getText()));
    }
}

