/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import com.jcraft.jsch.UserInfo;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.ui.dialogs.PasswordDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;

class SSHConnectionInfo
implements UserInfo {
    private String user;
    private String host;
    private String passwd;
    private String passphrase;
    private int port;
    private boolean canceledPWValue;
    private boolean promptPasswd;
    private boolean promptPassphrase;

    SSHConnectionInfo(String string, String string2, String string3, String string4, int n) {
        this.user = string;
        this.host = string2;
        this.passwd = string3;
        this.promptPasswd = this.passwd == null || this.passwd.length() == 0;
        this.passphrase = string4;
        this.promptPassphrase = this.passphrase == null || this.passphrase.length() == 0;
        this.port = n;
        this.canceledPWValue = false;
    }

    public String getPassword() {
        this.promptPasswd = true;
        return this.passwd;
    }

    String getUsername() {
        return this.user;
    }

    String getHostname() {
        return this.host;
    }

    int getPort() {
        return this.port;
    }

    public boolean promptYesNo(String string) {
        return MessageDialog.openQuestion(null, (String)Messages.getString("SshShell.sshTerminal"), (String)string);
    }

    public String getPassphrase() {
        this.promptPassphrase = true;
        return this.passphrase;
    }

    public boolean promptPassphrase(String string) {
        int n = 0;
        if (this.promptPassphrase) {
            PasswordDialog passwordDialog = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SshShell.sshTerminal"), string, null, null);
            n = passwordDialog.open();
            if (n == 0) {
                this.passphrase = passwordDialog.getValue();
            } else {
                this.canceledPWValue = true;
            }
        }
        return n == 0;
    }

    public boolean promptPassword(String string) {
        int n = 0;
        if (this.promptPasswd) {
            PasswordDialog passwordDialog = new PasswordDialog(Display.getCurrent().getActiveShell(), Messages.getString("SshShell.sshTerminal"), string, null, null);
            n = passwordDialog.open();
            if (n == 0) {
                this.passwd = passwordDialog.getValue();
            } else {
                this.canceledPWValue = true;
            }
        }
        return n == 0;
    }

    public void showMessage(String string) {
        MessageDialog.openInformation(null, (String)Messages.getString("SshShell.sshTerminal"), (String)string);
    }

    public boolean getCanceledPWValue() {
        return this.canceledPWValue;
    }
}

