/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionComposite;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

class SSHConnectionWizardPage
extends WizardPage
implements Listener {
    private SSHConnectionComposite composite;

    protected SSHConnectionWizardPage(String string) {
        super(string);
    }

    public void createControl(Composite composite) {
        this.composite = new SSHConnectionComposite(composite, 0, this);
        this.setPageComplete(false);
        this.setControl((Control)this.composite);
        IStatus iStatus = this.composite.getStatus();
        this.setPageComplete(iStatus.getSeverity() != 4);
    }

    public String getTitle() {
        return Messages.getString("SSHConnectionWizardPage.ssh");
    }

    public String getDescription() {
        return Messages.getString("SSHConnectionWizardPage.description");
    }

    public void handleEvent(Event event) {
        this.validateInput();
        this.getWizard().getContainer().updateButtons();
    }

    private void validateInput() {
        IStatus iStatus = this.composite.getStatus();
        this.applyToStatusLine(iStatus);
        this.setPageComplete(iStatus.getSeverity() != 4);
    }

    private void applyToStatusLine(IStatus iStatus) {
        String string = iStatus.getMessage();
        if (string.length() == 0) {
            string = null;
        }
        switch (iStatus.getSeverity()) {
            case 0: {
                this.setErrorMessage(null);
                this.setMessage(string);
                break;
            }
            case 2: {
                this.setErrorMessage(null);
                this.setMessage(string, 2);
                break;
            }
            case 1: {
                this.setErrorMessage(null);
                this.setMessage(string, 1);
                break;
            }
            default: {
                this.setErrorMessage(string);
                this.setMessage(null);
            }
        }
    }

    SSHConnectionInfo getConnectionInfo() {
        return this.composite.getConnectionInfo();
    }
}

