/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.ssh.internal;

import com.jcraft.jsch.ChannelShell;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Session;
import com.jcraft.jsch.UserInfo;
import eu.geclipse.core.CoreProblems;
import eu.geclipse.core.GridException;
import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.core.IProblem;
import eu.geclipse.core.SolutionRegistry;
import eu.geclipse.core.portforward.ForwardType;
import eu.geclipse.core.portforward.IForward;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.ITerminalView;
import eu.geclipse.terminal.ssh.internal.Activator;
import eu.geclipse.terminal.ssh.internal.Messages;
import eu.geclipse.terminal.ssh.internal.SSHConnectionInfo;
import eu.geclipse.terminal.ssh.internal.SSHWizard;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.widgets.IDropDownEntry;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.jsch.core.IJSchService;
import org.eclipse.swt.widgets.Display;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SshShell
implements IDropDownEntry<ITerminalView>,
ITerminalListener {
    ChannelShell channel;
    private ITerminalPage terminal;
    private SSHConnectionInfo userInfo;
    private int preConnectCols = -1;
    private int preConnectLines;
    private int preConnectXPix;
    private int preConnectYPix;

    public void windowSizeChanged(int n, int n2, int n3, int n4) {
        if (this.channel.isConnected()) {
            this.channel.setPtySize(n, n2, n3, n4);
        } else {
            this.preConnectCols = n;
            this.preConnectLines = n2;
            this.preConnectXPix = n3;
            this.preConnectYPix = n4;
        }
    }

    public void action(ITerminalView iTerminalView) {
        SSHWizard sSHWizard = new SSHWizard();
        sSHWizard.init(iTerminalView);
        WizardDialog wizardDialog = new WizardDialog(Display.getCurrent().getActiveShell(), (IWizard)sSHWizard);
        wizardDialog.open();
    }

    public void createTerminal(ITerminalView iTerminalView, SSHConnectionInfo sSHConnectionInfo, List<IForward> list) {
        try {
            IJSchService iJSchService = Activator.getDefault().getJSchService();
            if (iJSchService == null) {
                GridException gridException = new GridException(CoreProblems.GET_SSH_SERVICE_FAILED);
                NewProblemDialog.openProblem(null, (String)Messages.getString("SshShell.sshTerminal"), (String)Messages.getString("SshShell.couldNotGetService"), (Throwable)gridException);
            } else {
                this.userInfo = sSHConnectionInfo;
                final Session session = iJSchService.createSession(this.userInfo.getHostname(), this.userInfo.getPort(), this.userInfo.getUsername());
                session.setUserInfo((UserInfo)this.userInfo);
                if (list != null) {
                    for (IForward iBidirectionalConnection2 : list) {
                        if (iBidirectionalConnection2.getType() == ForwardType.LOCAL) {
                            session.setPortForwardingL(iBidirectionalConnection2.getBindPort(), iBidirectionalConnection2.getHostname(), iBidirectionalConnection2.getPort());
                            continue;
                        }
                        session.setPortForwardingR(iBidirectionalConnection2.getBindPort(), iBidirectionalConnection2.getHostname(), iBidirectionalConnection2.getPort());
                    }
                }
                session.connect();
                IBidirectionalConnection iProblem = new IBidirectionalConnection(){

                    public void close() {
                        SshShell.this.channel.disconnect();
                        session.disconnect();
                    }

                    public InputStream getInputStream() throws IOException {
                        return SshShell.this.channel.getInputStream();
                    }

                    public OutputStream getOutputStream() throws IOException {
                        return SshShell.this.channel.getOutputStream();
                    }
                };
                this.channel = (ChannelShell)session.openChannel("shell");
                this.terminal = iTerminalView.addTerminal(iProblem, (ITerminalListener)this);
                this.terminal.setTabName(this.userInfo.getHostname());
                this.terminal.setDescription(Messages.formatMessage("SshShell.descriptionWithoutWinTitle", this.userInfo.getUsername(), this.userInfo.getHostname()));
                this.channel.connect();
                if (this.preConnectCols != -1) {
                    this.windowSizeChanged(this.preConnectCols, this.preConnectLines, this.preConnectXPix, this.preConnectYPix);
                }
            }
        }
        catch (JSchException jSchException) {
            if (!this.userInfo.getCanceledPWValue()) {
                GridException gridException = new GridException(CoreProblems.LOGIN_FAILED, (Throwable)jSchException);
                IProblem iProblem = gridException.getProblem();
                iProblem.addSolution(SolutionRegistry.CHECK_USERNAME_AND_PASSWORD);
                iProblem.addSolution(SolutionRegistry.CHECK_SSH_SERVER_CONFIG);
                NewProblemDialog.openProblem(null, (String)Messages.getString("SshShell.sshTerminal"), (String)Messages.getString("SshShell.authFailed"), (Throwable)gridException);
            }
        }
        catch (Exception exception) {
            Activator.logException(exception);
        }
    }

    public void windowTitleChanged(String string) {
        this.terminal.setDescription(Messages.formatMessage("SshShell.descriptionWithWinTitle", this.userInfo.getUsername(), this.userInfo.getHostname(), string));
    }

    public void terminated() {
    }
}

