/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.CharSet;
import eu.geclipse.terminal.internal.Cursor;
import eu.geclipse.terminal.internal.CursorKeyMode;
import eu.geclipse.terminal.internal.KeyPadMode;
import eu.geclipse.terminal.internal.LineHeightMode;
import eu.geclipse.terminal.internal.LineWidthMode;
import eu.geclipse.terminal.internal.Messages;
import eu.geclipse.terminal.internal.OriginMode;
import eu.geclipse.terminal.internal.ScrollMode;
import eu.geclipse.terminal.internal.TerminalPainter;
import eu.geclipse.terminal.internal.TerminalSelection;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PushbackInputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Terminal
extends Canvas
implements ISelectionProvider {
    private static final int BEL = 7;
    private static final int FF = 12;
    private static final int SO = 14;
    private static final int SI = 15;
    private static final int TAB_WIDTH = 8;
    OutputStream output;
    KeyPadMode keyPadMode;
    CursorKeyMode cursorKeyMode;
    ScrollMode scrollMode;
    boolean newLineMode;
    TerminalPainter terminalPainter;
    int topMargin;
    int bottomMargin;
    int historySize;
    private PushbackInputStream input;
    private Char[][] screenBuffer;
    private LineHeightMode[] lineHeightMode;
    private LineWidthMode[] lineWidthMode;
    private int fontHeight;
    private int fontWidth;
    private int numCols;
    private int numLines;
    private final boolean[] leds = new boolean[4];
    private Cursor cursor;
    private Cursor savedCursor;
    private Color[] systemColors;
    private Color defaultBgColor;
    private Color defaultFgColor;
    private OriginMode originMode;
    private final CharSet[] charSetG = new CharSet[4];
    private boolean reverseScreenMode;
    private String windowTitle;
    private final SortedSet<Integer> tabulatorPositons = new TreeSet<Integer>();
    private List<ITerminalListener> terminalListeners;
    private boolean wraparound;
    private boolean reverseWraparound;
    private boolean running;
    private Clipboard clipboard = new Clipboard(this.getDisplay());
    private List<ISelectionChangedListener> selectionListeners;
    private TerminalSelection terminalSelection;

    public Terminal(Composite composite, int n, Color color, Color color2, int n2) {
        super(composite, n | 0x40000 | 0x200);
        this.historySize = n2;
        this.initMenu();
        this.initSystemColorTable();
        if (color2 != null) {
            this.defaultBgColor = color2;
        }
        if (color != null) {
            this.defaultFgColor = color;
        }
        this.cursor = new Cursor(this.defaultFgColor, this.defaultBgColor);
        this.savedCursor = new Cursor(this.defaultFgColor, this.defaultBgColor);
        this.screenBuffer = new Char[0][];
        this.terminalListeners = new LinkedList<ITerminalListener>();
        this.selectionListeners = new LinkedList<ISelectionChangedListener>();
        this.changeScreenSize();
        this.terminalPainter = new TerminalPainter(this);
        this.terminalSelection = new TerminalSelection(this);
        this.addMouseListener(this.terminalSelection);
        this.addMouseMoveListener(this.terminalSelection);
        this.addPaintListener(this.terminalPainter);
        this.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Terminal.this.changeScreenSize();
            }
        });
        this.getVerticalBar().addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Terminal.this.triggerRedraw();
            }
        });
        this.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDown(MouseEvent mouseEvent) {
                if (mouseEvent.button == 2) {
                    Terminal.this.paste();
                }
            }
        });
        this.addListener(1, new Listener(){

            public void handleEvent(Event event) {
                byte[][] byArrayArray = new byte[][]{{27, 91, 65}, {27, 79, 65}};
                byte[][] byArrayArray2 = new byte[][]{{27, 91, 66}, {27, 79, 66}};
                byte[][] byArrayArray3 = new byte[][]{{27, 91, 67}, {27, 79, 67}};
                byte[][] byArrayArray4 = new byte[][]{{27, 91, 68}, {27, 79, 68}};
                byte[] byArray = new byte[]{127};
                byte[] byArray2 = new byte[]{27, 91, 72};
                byte[] byArray3 = new byte[]{27, 91, 70};
                byte[] byArray4 = new byte[]{27, 91, 50, 126};
                byte[] byArray5 = new byte[]{27, 91, 51, 126};
                byte[] byArray6 = new byte[]{27, 91, 53, 126};
                byte[] byArray7 = new byte[]{27, 91, 54, 126};
                byte[] byArray8 = new byte[]{27, 79, 80};
                byte[] byArray9 = new byte[]{27, 79, 81};
                byte[] byArray10 = new byte[]{27, 79, 82};
                byte[] byArray11 = new byte[]{27, 79, 83};
                byte[] byArray12 = new byte[]{27, 91, 49, 53, 126};
                byte[] byArray13 = new byte[]{27, 91, 49, 55, 126};
                byte[] byArray14 = new byte[]{27, 91, 49, 56, 126};
                byte[] byArray15 = new byte[]{27, 91, 49, 57, 126};
                byte[] byArray16 = new byte[]{27, 91, 50, 48, 126};
                byte[] byArray17 = new byte[]{27, 91, 50, 49, 126};
                byte[] byArray18 = new byte[]{27, 91, 50, 51, 126};
                byte[] byArray19 = new byte[]{27, 91, 50, 52, 126};
                byte[] byArray20 = new byte[]{27, 91, 50, 53, 126};
                byte[] byArray21 = new byte[]{27, 91, 50, 54, 126};
                byte[] byArray22 = new byte[]{27, 91, 50, 56, 126};
                int[] nArray = new int[]{65536, 131072, 262144, 16777298, 16777299, 16777300, 0x1000055};
                try {
                    OutputStream outputStream = Terminal.this.output;
                    if (outputStream != null) {
                        if (event.keyCode == 0x1000001) {
                            outputStream.write(byArrayArray[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000002) {
                            outputStream.write(byArrayArray2[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000004) {
                            outputStream.write(byArrayArray3[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000003) {
                            outputStream.write(byArrayArray4[Terminal.this.keyPadMode.getIndex()]);
                        } else if (event.keyCode == 0x1000007) {
                            outputStream.write(byArray2);
                        } else if (event.keyCode == 0x1000008) {
                            outputStream.write(byArray3);
                        } else if (event.keyCode == 0x1000009) {
                            outputStream.write(byArray4);
                        } else if (event.character == '\u007f') {
                            outputStream.write(byArray5);
                        } else if (event.character == '\b') {
                            outputStream.write(byArray);
                        } else if (event.keyCode == 0x1000005) {
                            if ((event.stateMask & 0x20000) != 0) {
                                Terminal.this.scrollHistoryPageUp();
                            } else {
                                outputStream.write(byArray6);
                            }
                        } else if (event.keyCode == 0x1000006) {
                            if ((event.stateMask & 0x20000) != 0) {
                                Terminal.this.scrollHistoryPageDown();
                            } else {
                                outputStream.write(byArray7);
                            }
                        } else if (event.keyCode == 0x100000A) {
                            outputStream.write(byArray8);
                        } else if (event.keyCode == 0x100000B) {
                            outputStream.write(byArray9);
                        } else if (event.keyCode == 0x100000C) {
                            outputStream.write(byArray10);
                        } else if (event.keyCode == 0x100000D) {
                            outputStream.write(byArray11);
                        } else if (event.keyCode == 0x100000E) {
                            outputStream.write(byArray12);
                        } else if (event.keyCode == 0x100000F) {
                            outputStream.write(byArray13);
                        } else if (event.keyCode == 0x1000010) {
                            outputStream.write(byArray14);
                        } else if (event.keyCode == 0x1000011) {
                            outputStream.write(byArray15);
                        } else if (event.keyCode == 0x1000012) {
                            outputStream.write(byArray16);
                        } else if (event.keyCode == 0x1000013) {
                            outputStream.write(byArray17);
                        } else if (event.keyCode == 0x1000014) {
                            outputStream.write(byArray18);
                        } else if (event.keyCode == 0x1000015) {
                            outputStream.write(byArray19);
                        } else if (event.keyCode == 0x1000016) {
                            outputStream.write(byArray20);
                        } else if (event.keyCode == 0x1000017) {
                            outputStream.write(byArray21);
                        } else if (event.keyCode == 0x1000018) {
                            outputStream.write(byArray22);
                        } else if (event.character == '\r') {
                            outputStream.write(13);
                            if (Terminal.this.newLineMode) {
                                outputStream.write(10);
                            }
                        } else if (event.character != '\u0000') {
                            outputStream.write(event.character);
                        } else if (Arrays.binarySearch(nArray, event.keyCode) < 0) {
                            Activator.logMessage(2, Messages.formatMessage("Terminal.unhandledKeycode", new Integer(event.keyCode), new Integer(event.character)));
                        }
                        outputStream.flush();
                    }
                }
                catch (IOException iOException) {
                    Activator.logException(iOException);
                }
            }
        });
        this.reset();
    }

    void scrollHistoryPageUp() {
        int n = this.getScrollbarPosLine();
        int n2 = n - this.numLines;
        if (n2 < 0) {
            n2 = 0;
        }
        if (n2 != n) {
            this.getVerticalBar().setSelection(n2);
            this.triggerRedraw();
        }
    }

    void scrollHistoryPageDown() {
        int n = this.getScrollbarPosLine();
        int n2 = n + this.numLines;
        if (n2 > this.historySize) {
            n2 = this.historySize;
        }
        if (n2 != n) {
            this.getVerticalBar().setSelection(n2);
            this.triggerRedraw();
        }
    }

    private void initMenu() {
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        Menu menu = new Menu((Decorations)this.getShell(), 8);
        final MenuItem menuItem = new MenuItem(menu, 8);
        menuItem.setText(Messages.getString("Terminal.copy"));
        ImageDescriptor imageDescriptor = iSharedImages.getImageDescriptor("IMG_TOOL_COPY");
        menuItem.setImage(imageDescriptor.createImage());
        menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Terminal.this.copy();
            }
        });
        MenuItem menuItem2 = new MenuItem(menu, 8);
        menuItem2.setText(Messages.getString("Terminal.paste"));
        ImageDescriptor imageDescriptor2 = iSharedImages.getImageDescriptor("IMG_TOOL_PASTE");
        menuItem2.setImage(imageDescriptor2.createImage());
        menuItem2.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                Terminal.this.paste();
            }
        });
        menu.addMenuListener((MenuListener)new MenuAdapter(){

            public void menuShown(MenuEvent menuEvent) {
                menuItem.setEnabled(!Terminal.this.getSelection().isEmpty());
            }
        });
        this.setMenu(menu);
    }

    void copy() {
        String string = ((ITextSelection)this.getSelection()).getText();
        TextTransfer textTransfer = TextTransfer.getInstance();
        this.clipboard.setContents((Object[])new String[]{string}, new Transfer[]{textTransfer});
    }

    private Object getClipboardContent(int n) {
        TextTransfer textTransfer = TextTransfer.getInstance();
        return this.clipboard.getContents((Transfer)textTransfer, n);
    }

    public void paste() {
        this.checkWidget();
        String string = (String)this.getClipboardContent(1);
        if (string != null && string.length() > 0) {
            int n = 0;
            while (n < string.length()) {
                Event event = new Event();
                event.character = string.charAt(n);
                this.notifyListeners(1, event);
                ++n;
            }
        }
    }

    public void addTerminalListener(ITerminalListener iTerminalListener) {
        this.terminalListeners.add(iTerminalListener);
    }

    public void removeTerminalListener(ITerminalListener iTerminalListener) {
        this.terminalListeners.remove(iTerminalListener);
    }

    private void bell() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Display.getDefault().beep();
            }
        });
    }

    private void carriageReturn() {
        if (this.cursor.col != 0) {
            int n = this.cursor.col;
            this.cursor.col = 0;
            this.triggerRedraw(n, this.cursor.line, 1, 1);
            this.triggerRedraw(0, this.cursor.line, 1, 1);
        }
    }

    private void backspace() {
        if (this.cursor.col > 0) {
            --this.cursor.col;
            this.triggerRedraw(this.cursor.col + 1, this.cursor.line, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        }
    }

    private void startReaderThread() {
        Thread thread = new Thread(new Runnable(){

            public void run() {
                Terminal.this.readerMainLoop();
            }
        }, "Terminal");
        thread.start();
    }

    void readerMainLoop() {
        try {
            this.running = true;
            while (this.running) {
                int n = this.read();
                if (n == 7) {
                    this.bell();
                    continue;
                }
                if (n == 13) {
                    this.carriageReturn();
                    continue;
                }
                if (n == 10) {
                    this.nextLine();
                    continue;
                }
                if (n == 15) {
                    this.cursor.charSet = this.charSetG[0];
                    continue;
                }
                if (n == 14) {
                    this.cursor.charSet = this.charSetG[1];
                    continue;
                }
                if (n == 9) {
                    this.tabulator();
                    continue;
                }
                if (n == 12) {
                    this.eraseScreen();
                    continue;
                }
                if (n == 8) {
                    this.backspace();
                    continue;
                }
                if (n == 27) {
                    this.parseEscSequence();
                    continue;
                }
                if (n < 32) {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unhandledCtrlChar", new Character((char)n)));
                    continue;
                }
                this.input.unread(n);
                this.readText();
            }
        }
        catch (IOException iOException) {
            Activator.logException(iOException);
        }
        for (ITerminalListener iTerminalListener : this.terminalListeners) {
            iTerminalListener.terminated();
        }
    }

    private void tabulator() {
        int n = this.cursor.col;
        Integer n2 = new Integer(this.cursor.col + 1);
        Object[] objectArray = this.tabulatorPositons.toArray(new Integer[0]);
        int n3 = Arrays.binarySearch(objectArray, n2);
        if (n3 < 0) {
            n3 = -n3 - 1;
        }
        if (objectArray.length > n3) {
            int n4 = (Integer)objectArray[n3];
            if (n4 < this.numColsInLine(this.cursor.line)) {
                this.cursor.col = n4;
            } else {
                Activator.logMessage(2, Messages.getString("Terminal.tabStopOutsideDisplay"));
            }
        } else {
            this.cursor.col = (this.cursor.col + 8 + 1) / 8 * 8;
            if (this.cursor.col >= this.numColsInLine(this.cursor.line)) {
                this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
            }
        }
        this.triggerRedraw(n, this.cursor.line, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void readText() throws IOException {
        int n = this.read();
        int n2 = this.cursor.line;
        int n3 = this.cursor.col;
        int n4 = 0;
        while (n >= 32) {
            Char char_ = this.screenBuffer[this.cursor.line + this.historySize][this.cursor.col];
            char_.ch = (char)n;
            char_.setToCursorFormat(this.cursor);
            ++this.cursor.col;
            ++n4;
            if (this.cursor.col >= this.numColsInLine(this.cursor.line)) {
                if (this.wraparound) {
                    this.cursor.col = 0;
                    if (this.cursor.line < this.numLines - 1) {
                        this.triggerRedraw(n3, n2, n4, 1);
                        n3 = 0;
                        n2 = ++this.cursor.line;
                        n4 = 0;
                    } else {
                        this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
                    }
                } else {
                    this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
                }
            }
            if (this.input.available() == 0 && n4 != 0) {
                this.triggerRedraw(n3, n2, n4, 1);
                this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
                n3 += n4;
                n4 = 0;
            }
            n = this.read();
        }
        this.triggerRedraw(n3, n2, n4, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        this.input.unread(n);
    }

    private int numColsInLine(int n) {
        int n2 = this.numCols;
        if (this.lineWidthMode[n] == LineWidthMode.DOUBLE) {
            n2 /= 2;
        }
        return n2;
    }

    void triggerRedraw(final int n, final int n2, final int n3, final int n4) {
        int n5 = 1;
        final int n6 = n2;
        while (n6 < n2 + n4 && n6 < this.lineWidthMode.length) {
            if (this.lineWidthMode[n6 + this.historySize] == LineWidthMode.DOUBLE) {
                n5 = 2;
                break;
            }
            ++n6;
        }
        n6 = n5;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                if (!Terminal.this.isDisposed()) {
                    Terminal.this.redraw(n * Terminal.this.getFontWidth() * n6, (n2 + Terminal.this.historySize - Terminal.this.getScrollbarPosLine()) * Terminal.this.getFontHeigth(), n3 * Terminal.this.getFontWidth() * n6, n4 * Terminal.this.getFontHeigth(), false);
                }
            }
        });
    }

    void triggerRedraw() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Terminal.this.redraw();
            }
        });
    }

    private void parseEscSequence() throws IOException {
        int n = this.read();
        LinkedList<Integer> linkedList = new LinkedList<Integer>();
        switch (n) {
            case 91: {
                do {
                    linkedList.add(new Integer(this.readNumber()));
                } while ((n = this.read()) == 59);
                this.executeControlSequence(Terminal.listToArray(linkedList), n);
                break;
            }
            case 93: {
                this.executeOperatingSystemCommand();
                break;
            }
            case 35: {
                this.executeDecCommand();
                break;
            }
            case 40: {
                this.selectCharacterSet(0);
                break;
            }
            case 41: {
                this.selectCharacterSet(1);
                break;
            }
            case 42: {
                this.selectCharacterSet(2);
                break;
            }
            case 43: {
                this.selectCharacterSet(3);
                break;
            }
            case 90: {
                this.deviceAttributes(new int[0]);
                break;
            }
            case 61: {
                this.keyPadMode = KeyPadMode.APPLICATION;
                break;
            }
            case 62: {
                this.keyPadMode = KeyPadMode.NUMERIC;
                break;
            }
            case 55: {
                this.saveCursor();
                break;
            }
            case 56: {
                this.restoreCursor();
                break;
            }
            case 72: {
                this.horizontalTabulationSet();
                break;
            }
            case 68: {
                this.index();
                break;
            }
            case 69: {
                this.nextLine();
                break;
            }
            case 77: {
                this.reverseIndex();
                break;
            }
            case 99: {
                this.reset();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEscSeq", new Character((char)n)));
            }
        }
    }

    private void horizontalTabulationSet() {
        Integer n = new Integer(this.cursor.col);
        if (!this.tabulatorPositons.contains(n)) {
            this.tabulatorPositons.add(n);
        }
    }

    private void selectCharacterSet(int n) throws IOException {
        int n2 = this.read();
        CharSet charSet = CharSet.USASCII;
        switch (n2) {
            case 65: {
                Activator.logMessage(2, Messages.getString("Terminal.ukCharSetNotSupported"));
                break;
            }
            case 66: {
                charSet = CharSet.USASCII;
                break;
            }
            case 48: {
                charSet = CharSet.SPECIAL;
                break;
            }
            case 49: {
                Activator.logMessage(2, Messages.getString("Terminal.alternateStdCharSetNotSupported"));
                break;
            }
            case 50: {
                Activator.logMessage(2, Messages.getString("Terminal.alternateSpecialCharSetNotSupported"));
                break;
            }
            default: {
                Activator.logMessage(2, Messages.getString("Terminal.unknownCharSet"));
            }
        }
        this.charSetG[n] = charSet;
    }

    private void nextLine() {
        int n = this.cursor.col;
        this.cursor.col = 0;
        this.triggerRedraw(n, this.cursor.line, 1, 1);
        this.index();
    }

    private void index() {
        if (this.cursor.line < this.bottomMargin) {
            int n = this.cursor.line++;
            this.triggerRedraw(this.cursor.col, n, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        } else {
            this.scrollUp();
        }
    }

    private void reverseIndex() {
        if (this.cursor.line > this.topMargin) {
            int n = this.cursor.line--;
            this.triggerRedraw(this.cursor.col, n, 1, 1);
            this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
        } else {
            this.scrollDown();
        }
    }

    private void saveCursor() {
        this.savedCursor = new Cursor(this.cursor);
    }

    private void restoreCursor() {
        int n = this.cursor.col;
        int n2 = this.cursor.line;
        this.cursor = this.savedCursor;
        this.triggerRedraw(n, n2, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private static int[] listToArray(List<Integer> list) {
        int[] nArray = new int[list.size()];
        int n = 0;
        while (n < list.size()) {
            nArray[n] = list.get(n);
            ++n;
        }
        return nArray;
    }

    private void executeDecCommand() throws IOException {
        int n = this.read();
        switch (n) {
            case 51: {
                this.doubleHeightLine(LineHeightMode.DOUBLE_TOP);
                break;
            }
            case 52: {
                this.doubleHeightLine(LineHeightMode.DOUBLE_BOTTOM);
                break;
            }
            case 53: {
                this.doubleWidthLine(LineWidthMode.NORMAL);
                break;
            }
            case 54: {
                this.doubleWidthLine(LineWidthMode.DOUBLE);
                break;
            }
            case 56: {
                this.screenAlignmentDisplay();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownDecCommand", new Character((char)n)));
            }
        }
    }

    private void doubleWidthLine(LineWidthMode lineWidthMode) {
        this.lineHeightMode[this.cursor.line + this.historySize] = LineHeightMode.NORMAL;
        this.lineWidthMode[this.cursor.line + this.historySize] = lineWidthMode;
        if (lineWidthMode == LineWidthMode.DOUBLE && this.cursor.col > this.numCols / 2) {
            this.cursor.col = this.numCols / 2;
        }
        this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
    }

    private void doubleHeightLine(LineHeightMode lineHeightMode) {
        if (lineHeightMode == LineHeightMode.DOUBLE_TOP || lineHeightMode == LineHeightMode.DOUBLE_BOTTOM) {
            this.lineWidthMode[this.cursor.line + this.historySize] = LineWidthMode.DOUBLE;
        }
        this.lineHeightMode[this.cursor.line + this.historySize] = lineHeightMode;
        this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
    }

    private void screenAlignmentDisplay() {
        int n = this.historySize;
        while (n < this.numLines + this.historySize) {
            this.lineHeightMode[n] = LineHeightMode.NORMAL;
            this.lineWidthMode[n] = LineWidthMode.NORMAL;
            ++n;
        }
        n = this.historySize;
        while (n < this.numLines + this.historySize) {
            Char[] charArray = this.screenBuffer[n];
            int n2 = charArray.length;
            int n3 = 0;
            while (n3 < n2) {
                Char char_ = charArray[n3];
                char_.ch = (char)69;
                ++n3;
            }
            ++n;
        }
        this.triggerRedraw();
    }

    private void executeOperatingSystemCommand() throws IOException {
        int n = this.readNumber();
        if (this.read() != 59) {
            Activator.logMessage(2, Messages.getString("Terminal.invalidOsCommand"));
        } else {
            switch (n) {
                case 0: {
                    this.windowTitle = this.readString();
                    for (ITerminalListener iTerminalListener : this.terminalListeners) {
                        iTerminalListener.windowTitleChanged(this.windowTitle);
                    }
                    break;
                }
                case 4: {
                    Color color;
                    int n2 = this.readNumber();
                    if (this.read() != 59) {
                        Activator.logMessage(2, Messages.getString("Terminal.invalidOsCommand"));
                        break;
                    }
                    this.systemColors[n2] = color = this.parseColorString(this.readString());
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownOsCommand", new Integer(n)));
                }
            }
        }
    }

    private Color parseColorString(String string) {
        StringTokenizer stringTokenizer;
        Color color = null;
        if (string.startsWith("rgb:") && (stringTokenizer = new StringTokenizer(string.substring(4), "/")).countTokens() == 3) {
            int n = Integer.parseInt(stringTokenizer.nextToken(), 16);
            int n2 = Integer.parseInt(stringTokenizer.nextToken(), 16);
            int n3 = Integer.parseInt(stringTokenizer.nextToken(), 16);
            color = new Color((Device)Display.getDefault(), n, n2, n3);
        }
        if (color == null) {
            color = this.defaultFgColor;
            Activator.logMessage(2, Messages.getString("Terminal.unknownColorString"));
        }
        return color;
    }

    private String readString() throws IOException {
        char[] cArray = new char[]{'\u0007', '\u001b'};
        StringBuilder stringBuilder = new StringBuilder();
        char c = (char)this.read();
        while (Arrays.binarySearch(cArray, c) < 0) {
            stringBuilder.append(c);
            c = (char)this.read();
        }
        if (c == '\u001b' && this.read() != 92) {
            Activator.logMessage(2, Messages.getString("Terminal.stringTerminatorExpected"));
        }
        return stringBuilder.toString();
    }

    private void executeControlSequence(int[] nArray, int n) throws IOException {
        switch (n) {
            case 68: {
                this.cursorBackward(nArray);
                break;
            }
            case 66: {
                this.cursorDown(nArray);
                break;
            }
            case 67: {
                this.cursorForward(nArray);
                break;
            }
            case 72: {
                this.cursorPosition(nArray);
                break;
            }
            case 65: {
                this.cursorUp(nArray);
                break;
            }
            case 99: {
                this.deviceAttributes(nArray);
                break;
            }
            case 113: {
                this.loadLeds(nArray);
                break;
            }
            case 120: {
                this.requestTerminalParameters(nArray);
                break;
            }
            case 114: {
                this.setTopAndBottomMargins(nArray);
                break;
            }
            case 121: {
                Activator.logMessage(2, Messages.getString("Terminal.invokeConfidenceTestNotImplemented"));
                break;
            }
            case 110: {
                this.deviceStatusReport(nArray);
                break;
            }
            case 74: {
                this.eraseInDisplay(nArray);
                break;
            }
            case 75: {
                this.eraseInLine(nArray);
                break;
            }
            case 102: {
                this.cursorPosition(nArray);
                break;
            }
            case 108: {
                this.resetMode(nArray);
                break;
            }
            case 109: {
                this.selectGraphicRendition(nArray);
                break;
            }
            case 104: {
                this.setMode(nArray);
                break;
            }
            case 103: {
                this.tabulationClear(nArray);
                break;
            }
            case 100: {
                this.verticalLinePositionAbsolute(nArray);
                break;
            }
            case 88: {
                this.eraseCharacter(nArray);
                break;
            }
            case 80: {
                this.deleteCharacter(nArray);
                break;
            }
            case 71: {
                this.cursorHorizontalAbsolute(nArray);
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownCtrlSeq", new Character((char)n)));
            }
        }
    }

    private void deviceStatusReport(int[] nArray) throws IOException {
        byte[] byArray = new byte[]{27, 91, 48, 110};
        int n = 0;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        switch (n) {
            case 5: {
                this.output.write(byArray);
                this.output.flush();
                break;
            }
            case 6: {
                this.reportCursorPosition();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.getString("Terminal.invalidDeviceStatusReportParam"));
            }
        }
    }

    private void reportCursorPosition() throws IOException {
        this.output.write(27);
        this.output.write(91);
        this.output.write(Integer.toString(this.cursor.line + 1).getBytes("ASCII"));
        this.output.write(59);
        this.output.write(Integer.toString(this.cursor.col + 1).getBytes("ASCII"));
        this.output.write(82);
        this.output.flush();
    }

    private void requestTerminalParameters(int[] nArray) throws IOException {
        byte[] byArray = new byte[]{27, 91, 50, 59, 49, 59, 49, 59, 49, 50, 56, 59, 49, 50, 56, 59, 49, 59, 48, 120};
        if (nArray.length > 0 && nArray[0] != 0 && nArray[0] != 1) {
            Activator.logMessage(2, Messages.getString("Terminal.unknownTermParamReq"));
        } else {
            if (nArray[0] == 1) {
                byArray[2] = 51;
            }
            this.output.write(byArray);
            this.output.flush();
        }
    }

    private void eraseCharacter(int[] nArray) {
        int n = 1;
        int n2 = this.numColsInLine(this.cursor.line);
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        int n3 = this.cursor.col;
        while (n3 < this.cursor.col + n && n3 < n2) {
            this.screenBuffer[this.cursor.line + this.historySize][n3].erase(this.defaultFgColor, this.defaultBgColor);
            this.screenBuffer[this.cursor.line + this.historySize][n3].bgColor = this.cursor.bgColor;
            ++n3;
        }
        this.triggerRedraw(this.cursor.col, this.cursor.line, n, 1);
    }

    private void deleteCharacter(int[] nArray) {
        int n = 1;
        int n2 = this.numColsInLine(this.cursor.line);
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        if (n > n2 - this.cursor.col) {
            n = n2 - this.cursor.col;
        }
        int n3 = n2 - this.cursor.col - n;
        int n4 = this.cursor.col;
        while (n4 < this.cursor.col + n3) {
            this.screenBuffer[this.cursor.line + this.historySize][n4] = this.screenBuffer[this.cursor.line + this.historySize][n4 + n];
            ++n4;
        }
        n4 = this.cursor.col + n3;
        while (n4 < n2) {
            this.screenBuffer[this.cursor.line + this.historySize][n4] = new Char(this.defaultFgColor, this.defaultBgColor);
            ++n4;
        }
        this.triggerRedraw(this.cursor.col, this.cursor.line, n2 - this.cursor.col, 1);
    }

    private void setMode(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            switch (n3) {
                case 1: {
                    this.cursorKeyMode = CursorKeyMode.APPLICATION;
                    break;
                }
                case 3: {
                    this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
                    this.tabulatorPositons.clear();
                    this.eraseScreen();
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            Terminal.this.setSize(132 * Terminal.this.getFontWidth() + Terminal.this.getVerticalBar().getSize().x, 24 * Terminal.this.getFontHeigth());
                        }
                    });
                    break;
                }
                case 4: {
                    this.scrollMode = ScrollMode.SMOOTH;
                    break;
                }
                case 5: {
                    this.reverseScreenMode = true;
                    this.triggerRedraw();
                    break;
                }
                case 6: {
                    this.setOriginMode(OriginMode.RELATIVE);
                    break;
                }
                case 7: {
                    this.wraparound = true;
                    break;
                }
                case 8: {
                    Activator.logMessage(2, Messages.getString("Terminal.autoRepeatOnNotSupported"));
                    break;
                }
                case 9: {
                    Activator.logMessage(2, Messages.getString("Terminal.interlaceOnNotSupported"));
                    break;
                }
                case 20: {
                    this.newLineMode = true;
                    break;
                }
                case 45: {
                    this.reverseWraparound = true;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownSetModeParam", new Integer(n3)));
                }
            }
            ++n2;
        }
    }

    private void resetMode(int[] nArray) {
        int[] nArray2 = nArray;
        int n = nArray.length;
        int n2 = 0;
        while (n2 < n) {
            int n3 = nArray2[n2];
            switch (n3) {
                case 1: {
                    this.cursorKeyMode = CursorKeyMode.CURSOR;
                    break;
                }
                case 2: {
                    Activator.logMessage(2, Messages.getString("Terminal.vt52ModeNotSupported"));
                    break;
                }
                case 3: {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            Terminal.this.setSize(80 * Terminal.this.getFontWidth() + Terminal.this.getVerticalBar().getSize().x, 24 * Terminal.this.getFontHeigth());
                        }
                    });
                    this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
                    this.tabulatorPositons.clear();
                    this.eraseScreen();
                    break;
                }
                case 4: {
                    this.scrollMode = ScrollMode.JUMP;
                    break;
                }
                case 5: {
                    this.reverseScreenMode = false;
                    this.triggerRedraw();
                    break;
                }
                case 6: {
                    this.setOriginMode(OriginMode.ABSOLUTE);
                    break;
                }
                case 7: {
                    this.wraparound = false;
                    break;
                }
                case 8: {
                    Activator.logMessage(2, Messages.getString("Terminal.autoRepeatOffNotSupported"));
                    break;
                }
                case 9: {
                    Activator.logMessage(2, Messages.getString("Terminal.interlaceOffNotSupported"));
                    break;
                }
                case 20: {
                    this.newLineMode = false;
                    break;
                }
                case 45: {
                    this.reverseWraparound = false;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownResetModeParam", new Integer(n3)));
                }
            }
            ++n2;
        }
    }

    private void tabulationClear(int[] nArray) {
        Integer n = new Integer(this.cursor.col);
        int n2 = 0;
        if (nArray.length > 0) {
            n2 = nArray[0];
        }
        switch (n2) {
            case 0: {
                this.tabulatorPositons.remove(n);
                break;
            }
            case 3: {
                this.tabulatorPositons.clear();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownTabClearParam", new Integer(n2)));
            }
        }
    }

    private void reset() {
        this.cursor.reset(this.defaultFgColor, this.defaultBgColor);
        this.tabulatorPositons.clear();
        this.wraparound = true;
        this.reverseWraparound = false;
        this.reverseScreenMode = false;
        this.newLineMode = false;
        this.keyPadMode = KeyPadMode.NUMERIC;
        int n = 0;
        while (n < this.charSetG.length) {
            this.charSetG[n] = CharSet.USASCII;
            ++n;
        }
        this.topMargin = 0;
        this.bottomMargin = this.numLines - 1;
        n = 0;
        while (n < this.leds.length) {
            this.leds[n] = false;
            ++n;
        }
        this.setOriginMode(OriginMode.ABSOLUTE);
        this.eraseScreen();
    }

    private void setOriginMode(OriginMode originMode) {
        int n = this.cursor.line;
        int n2 = this.cursor.col;
        if (originMode == OriginMode.ABSOLUTE) {
            this.cursor.col = 0;
            this.cursor.line = 0;
        } else {
            this.cursor.col = 0;
            this.cursor.line = this.topMargin;
        }
        this.originMode = originMode;
        this.triggerRedraw(n2, n, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void scrollUp() {
        Char[] charArray = this.topMargin == 0 ? this.scrollHistory() : this.screenBuffer[this.topMargin + this.historySize];
        int n = this.topMargin;
        while (n < this.bottomMargin) {
            this.lineHeightMode[n + this.historySize] = this.lineHeightMode[n + this.historySize + 1];
            this.lineWidthMode[n + this.historySize] = this.lineWidthMode[n + this.historySize + 1];
            this.screenBuffer[n + this.historySize] = this.screenBuffer[n + this.historySize + 1];
            ++n;
        }
        this.screenBuffer[this.bottomMargin + this.historySize] = charArray;
        this.eraseLine(this.bottomMargin);
        this.lineWidthMode[this.bottomMargin + this.historySize] = LineWidthMode.NORMAL;
        this.lineHeightMode[this.bottomMargin + this.historySize] = LineHeightMode.NORMAL;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Terminal.this.terminalPainter.scrollUp(Terminal.this.topMargin, Terminal.this.bottomMargin);
                Display.getDefault().update();
            }
        });
        this.triggerRedraw(0, this.bottomMargin, this.numCols, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line - 1, 1, 1);
    }

    private Char[] scrollHistory() {
        Char[] charArray = this.screenBuffer[0];
        int n = 0;
        while (n < this.historySize) {
            this.lineHeightMode[n] = this.lineHeightMode[n + 1];
            this.lineWidthMode[n] = this.lineWidthMode[n + 1];
            this.screenBuffer[n] = this.screenBuffer[n + 1];
            ++n;
        }
        return charArray;
    }

    private void scrollDown() {
        Char[] charArray = this.screenBuffer[this.bottomMargin + this.historySize];
        int n = this.bottomMargin;
        while (n > this.topMargin) {
            this.lineHeightMode[n + this.historySize] = this.lineHeightMode[n + this.historySize - 1];
            this.lineWidthMode[n + this.historySize] = this.lineWidthMode[n + this.historySize - 1];
            this.screenBuffer[n + this.historySize] = this.screenBuffer[n + this.historySize - 1];
            --n;
        }
        this.screenBuffer[this.topMargin + this.historySize] = charArray;
        this.eraseLine(this.topMargin);
        this.lineWidthMode[this.topMargin + this.historySize] = LineWidthMode.NORMAL;
        this.lineHeightMode[this.topMargin + this.historySize] = LineHeightMode.NORMAL;
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                Terminal.this.terminalPainter.scrollDown(Terminal.this.topMargin, Terminal.this.bottomMargin);
                Display.getDefault().update();
            }
        });
        this.triggerRedraw(0, this.topMargin, this.numCols, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line + 1, 1, 1);
    }

    private void setTopAndBottomMargins(int[] nArray) {
        int n = 0;
        int n2 = this.numLines;
        if (nArray.length > 0) {
            n = nArray[0];
        }
        if (nArray.length > 1) {
            n2 = nArray[1];
        }
        if (n > 0) {
            --n;
        }
        if (n2 > 0) {
            --n2;
        }
        if (n >= n2) {
            Activator.logMessage(2, Messages.getString("Terminal.topLargerEqualBottom"));
        } else if (n2 >= this.numLines) {
            Activator.logMessage(2, Messages.formatMessage("Terminal.bottomOutOfScreen", new Integer(n2), new Integer(this.numLines)));
        } else {
            this.topMargin = n;
            this.bottomMargin = n2;
            this.cursorPosition(new int[0]);
        }
    }

    private void selectGraphicRendition(int[] nArray) {
        int n = 0;
        int n2 = 0;
        do {
            if (nArray.length > n2) {
                n = nArray[n2];
            }
            if (n >= 30 && n <= 37) {
                if (this.cursor.bold) {
                    this.cursor.fgColor = this.systemColors[n - 30 + 8];
                    continue;
                }
                this.cursor.fgColor = this.systemColors[n - 30];
                continue;
            }
            if (n >= 40 && n <= 47) {
                this.cursor.bgColor = this.systemColors[n - 40];
                continue;
            }
            switch (n) {
                case 0: {
                    this.cursor.bold = false;
                    this.cursor.underscore = false;
                    this.cursor.blink = false;
                    this.cursor.negative = false;
                    this.cursor.italics = false;
                    this.cursor.strikethrough = false;
                    this.cursor.fgColor = this.defaultFgColor;
                    this.cursor.bgColor = this.defaultBgColor;
                    break;
                }
                case 1: {
                    this.cursor.bold = true;
                    break;
                }
                case 4: {
                    this.cursor.underscore = true;
                    break;
                }
                case 5: {
                    this.cursor.blink = true;
                    break;
                }
                case 7: {
                    this.cursor.negative = true;
                    break;
                }
                case 3: {
                    this.cursor.italics = true;
                    break;
                }
                case 9: {
                    this.cursor.strikethrough = true;
                    break;
                }
                case 22: {
                    this.cursor.bold = false;
                    break;
                }
                case 23: {
                    this.cursor.italics = false;
                    break;
                }
                case 24: {
                    this.cursor.underscore = false;
                    break;
                }
                case 27: {
                    this.cursor.negative = false;
                    break;
                }
                case 29: {
                    this.cursor.strikethrough = false;
                    break;
                }
                case 38: {
                    if (nArray.length >= n2 + 3 && nArray[n2 + 1] == 5 && nArray[n2 + 2] < 256) {
                        this.cursor.fgColor = this.systemColors[nArray[n2 + 2]];
                        n2 += 2;
                        break;
                    }
                    Activator.logMessage(2, Messages.getString("Terminal.invalidColorParams"));
                    break;
                }
                case 39: {
                    this.cursor.fgColor = this.defaultFgColor;
                    break;
                }
                case 48: {
                    if (nArray.length >= n2 + 3 && nArray[n2 + 1] == 5 && nArray[n2 + 2] < 256) {
                        this.cursor.bgColor = this.systemColors[nArray[n2 + 2]];
                        n2 += 2;
                        break;
                    }
                    Activator.logMessage(2, Messages.getString("Terminal.invalidColorParams"));
                    break;
                }
                case 49: {
                    this.cursor.bgColor = this.defaultBgColor;
                    break;
                }
                default: {
                    Activator.logMessage(2, Messages.formatMessage("Terminal.unknownGraphRendParam", new Integer(n)));
                }
            }
        } while (++n2 < nArray.length);
    }

    private void eraseScreen() {
        int[] nArray = new int[]{2};
        this.eraseInDisplay(nArray);
        this.resetLineModes();
    }

    private void resetLineModes() {
        int n = 0;
        while (n < this.lineHeightMode.length) {
            this.lineHeightMode[n] = LineHeightMode.NORMAL;
            this.lineWidthMode[n] = LineWidthMode.NORMAL;
            ++n;
        }
    }

    private void eraseInDisplay(int[] nArray) {
        int n = 0;
        if (nArray.length > 0) {
            n = nArray[0];
        }
        switch (n) {
            case 0: {
                this.eraseInLine(nArray);
                int n2 = this.cursor.line + 1;
                while (n2 < this.numLines) {
                    this.eraseLine(n2);
                    ++n2;
                }
                this.triggerRedraw(0, this.cursor.line + 1, this.numCols, this.numLines - this.cursor.line - 1);
                break;
            }
            case 1: {
                this.eraseInLine(nArray);
                int n3 = 0;
                while (n3 < this.cursor.line) {
                    this.eraseLine(n3);
                    ++n3;
                }
                this.triggerRedraw(0, 0, this.numCols, this.cursor.line);
                break;
            }
            case 2: {
                int n4 = 0;
                while (n4 < this.numLines) {
                    this.eraseLine(n4);
                    ++n4;
                }
                this.triggerRedraw();
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEraseInDispParam", new Integer(n)));
            }
        }
    }

    private void eraseInLine(int[] nArray) {
        int n = 0;
        if (nArray.length > 0) {
            n = nArray[0];
        }
        switch (n) {
            case 0: {
                int n2 = this.cursor.col;
                while (n2 < this.screenBuffer[this.cursor.line + this.historySize].length) {
                    this.screenBuffer[this.cursor.line + this.historySize][n2].erase(this.defaultFgColor, this.defaultBgColor);
                    ++n2;
                }
                this.triggerRedraw(this.cursor.col, this.cursor.line, this.numCols - this.cursor.col, 1);
                break;
            }
            case 1: {
                int n3 = 0;
                while (n3 <= this.cursor.col) {
                    this.screenBuffer[this.cursor.line + this.historySize][n3].erase(this.defaultFgColor, this.defaultBgColor);
                    ++n3;
                }
                this.triggerRedraw(0, this.cursor.line, this.cursor.col + 1, 1);
                break;
            }
            case 2: {
                this.eraseLine(this.cursor.line);
                this.triggerRedraw(0, this.cursor.line, this.numCols, 1);
                break;
            }
            default: {
                Activator.logMessage(2, Messages.formatMessage("Terminal.unknownEraseInLineParam", new Integer(n)));
            }
        }
    }

    private void eraseLine(int n) {
        Char[] charArray = this.screenBuffer[n + this.historySize];
        int n2 = charArray.length;
        int n3 = 0;
        while (n3 < n2) {
            Char char_ = charArray[n3];
            char_.erase(this.defaultFgColor, this.defaultBgColor);
            ++n3;
        }
    }

    private void loadLeds(int[] nArray) {
        int n = 0;
        if (nArray.length > 0) {
            n = nArray[0];
        }
        if (n == 0) {
            int n2 = 0;
            while (n2 < this.leds.length) {
                this.leds[n2] = false;
                ++n2;
            }
        } else if (n < this.leds.length) {
            this.leds[n - 1] = true;
        } else {
            Activator.logMessage(2, Messages.formatMessage("Terminal.invalidLoadLedsParam", new Integer(n)));
        }
    }

    private void cursorBackward(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.col;
        int n3 = this.cursor.line;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        if (this.reverseWraparound) {
            while (this.cursor.col - n < 0) {
                if (this.cursor.line != 0) {
                    n -= this.cursor.col + 1;
                    --this.cursor.line;
                    this.cursor.col = this.numColsInLine(this.cursor.line) - 1;
                    continue;
                }
                this.cursor.col = 0;
                n = 0;
                break;
            }
            this.cursor.col -= n;
        } else {
            this.cursor.col = this.cursor.col - n < 0 ? 0 : (this.cursor.col -= n);
        }
        this.triggerRedraw(n2, n3, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorDown(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.line;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        this.cursor.line = this.cursor.line + n >= this.bottomMargin ? this.bottomMargin - 1 : (this.cursor.line += n);
        this.triggerRedraw(this.cursor.col, n2, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorForward(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.col;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        this.cursor.col = this.cursor.col + n >= this.numCols ? this.numCols - 1 : (this.cursor.col += n);
        this.triggerRedraw(n2, this.cursor.line, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorUp(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.line;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        this.cursor.line = this.cursor.line - n < this.topMargin ? this.topMargin : (this.cursor.line -= n);
        this.triggerRedraw(this.cursor.col, n2, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void verticalLinePositionAbsolute(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.line;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        if (n >= this.numLines) {
            n = this.numLines - 1;
        }
        this.cursor.line = n;
        this.triggerRedraw(this.cursor.col, n2, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorHorizontalAbsolute(int[] nArray) {
        int n = 1;
        int n2 = this.cursor.col;
        if (nArray.length != 0) {
            n = nArray[0];
        }
        if (n == 0) {
            n = 1;
        }
        if (n >= this.numCols) {
            n = this.numCols - 1;
        }
        this.cursor.col = n;
        this.triggerRedraw(n2, this.cursor.col, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void cursorPosition(int[] nArray) {
        int n = 0;
        int n2 = 0;
        int n3 = this.numLines;
        if (nArray.length > 0) {
            n2 = nArray[0];
        }
        if (nArray.length > 1) {
            n = nArray[1];
        }
        if (n2 > 0) {
            --n2;
        }
        if (n > 0) {
            --n;
        }
        if (this.originMode == OriginMode.RELATIVE) {
            n2 += this.topMargin;
            n3 = this.bottomMargin;
        }
        if (n2 >= n3) {
            n2 = n3 - 1;
            Activator.logMessage(2, Messages.getString("Terminal.cursorPosOutOfRangeLine"));
        }
        if (n >= this.numCols) {
            n = this.numCols - 1;
            Activator.logMessage(2, Messages.getString("Terminal.cursorPosOutOfRangeCol"));
        }
        int n4 = this.cursor.line;
        int n5 = this.cursor.col;
        this.cursor.line = n2;
        this.cursor.col = n;
        this.triggerRedraw(n5, n4, 1, 1);
        this.triggerRedraw(this.cursor.col, this.cursor.line, 1, 1);
    }

    private void deviceAttributes(int[] nArray) throws IOException {
        byte[] byArray = new byte[]{27, 91, 63, 49, 59, 50, 99};
        if (nArray.length > 0 && nArray[0] != 0) {
            Activator.logMessage(2, Messages.getString("Terminal.unknownDevAttribReq"));
        } else {
            this.output.write(byArray);
            this.output.flush();
        }
    }

    private int readNumber() throws IOException {
        int n = this.read();
        int n2 = 0;
        while (n >= 48 && n <= 57 || n == 63) {
            if (n != 63) {
                n2 *= 10;
                n2 += n - 48;
            }
            n = this.read();
        }
        this.input.unread(n);
        return n2;
    }

    private int read() throws IOException {
        int n = this.input.read();
        if (n == -1) {
            this.running = false;
        }
        this.terminalSelection.clearSelection();
        return n;
    }

    private void initSystemColorTable() {
        Display display = Display.getDefault();
        this.defaultBgColor = Display.getDefault().getSystemColor(2);
        this.defaultFgColor = Display.getDefault().getSystemColor(15);
        this.systemColors = new Color[256];
        this.systemColors[0] = display.getSystemColor(2);
        this.systemColors[1] = display.getSystemColor(4);
        this.systemColors[2] = display.getSystemColor(6);
        this.systemColors[3] = display.getSystemColor(8);
        this.systemColors[4] = display.getSystemColor(10);
        this.systemColors[5] = display.getSystemColor(12);
        this.systemColors[6] = display.getSystemColor(14);
        this.systemColors[7] = display.getSystemColor(15);
        this.systemColors[8] = display.getSystemColor(16);
        this.systemColors[9] = display.getSystemColor(3);
        this.systemColors[10] = display.getSystemColor(5);
        this.systemColors[11] = display.getSystemColor(7);
        this.systemColors[12] = display.getSystemColor(9);
        this.systemColors[13] = display.getSystemColor(11);
        this.systemColors[14] = display.getSystemColor(13);
        this.systemColors[15] = display.getSystemColor(1);
        int n = 16;
        while (n < 256) {
            this.systemColors[n] = this.defaultBgColor;
            ++n;
        }
    }

    void changeScreenSize() {
        Font font = this.getFont();
        Point point = this.getSize();
        GC gC = new GC((Drawable)this);
        gC.setFont(font);
        this.fontWidth = gC.getFontMetrics().getAverageCharWidth();
        this.fontHeight = gC.getFontMetrics().getHeight();
        gC.dispose();
        this.numCols = (point.x - this.getVerticalBar().getSize().x) / this.fontWidth;
        this.numLines = point.y / this.fontHeight;
        if (this.numCols < 2) {
            this.numCols = 80;
        }
        if (this.numLines < 2) {
            this.numLines = 24;
        }
        Char[][] charArrayArray = new Char[this.numLines + this.historySize][];
        int n = 0;
        while (n < charArrayArray.length) {
            int n2;
            charArrayArray[n] = new Char[this.numCols];
            if (n < this.screenBuffer.length) {
                n2 = charArrayArray[n].length;
                if (this.screenBuffer[n].length < n2) {
                    n2 = this.screenBuffer[n].length;
                }
                int n3 = 0;
                while (n3 < n2) {
                    charArrayArray[n][n3] = this.screenBuffer[n][n3];
                    ++n3;
                }
            }
            n2 = 0;
            while (n2 < charArrayArray[n].length) {
                if (charArrayArray[n][n2] == null) {
                    charArrayArray[n][n2] = new Char(this.defaultFgColor, this.defaultBgColor);
                }
                ++n2;
            }
            ++n;
        }
        this.screenBuffer = charArrayArray;
        this.lineHeightMode = new LineHeightMode[this.numLines + this.historySize];
        this.lineWidthMode = new LineWidthMode[this.numLines + this.historySize];
        this.resetLineModes();
        this.setTopAndBottomMargins(new int[0]);
        if (this.cursor.line >= this.numLines) {
            this.cursor.line = this.numLines - 1;
        }
        if (this.cursor.col >= this.numCols) {
            this.cursor.col = this.numCols - 1;
        }
        if (this.numCols != 0 && this.numLines != 0) {
            for (ITerminalListener iTerminalListener : this.terminalListeners) {
                iTerminalListener.windowSizeChanged(this.numCols, this.numLines, this.numCols * this.fontWidth, this.numLines * this.fontHeight);
            }
        }
        this.getVerticalBar().setValues(this.historySize, 0, this.screenBuffer.length, this.numLines, 1, this.numLines);
    }

    public void setInputStream(InputStream inputStream) {
        this.input = new PushbackInputStream(inputStream);
        this.startReaderThread();
    }

    public void setOutputStream(OutputStream outputStream) {
        this.output = outputStream;
    }

    public void setFont(Font font) {
        this.terminalPainter.setFont(font);
        super.setFont(font);
    }

    public Color getForeground() {
        return this.defaultFgColor;
    }

    public Color getBackground() {
        return this.defaultBgColor;
    }

    boolean isInReverseScreenMode() {
        return this.reverseScreenMode;
    }

    int getFontHeigth() {
        return this.fontHeight;
    }

    int getFontWidth() {
        return this.fontWidth;
    }

    Char[][] getScreenBuffer() {
        return this.screenBuffer;
    }

    LineHeightMode[] getLineHeightMode() {
        return this.lineHeightMode;
    }

    LineWidthMode[] getLineWidthMode() {
        return this.lineWidthMode;
    }

    int getCursorLine() {
        return this.cursor.line;
    }

    int getCursorCol() {
        return this.cursor.col;
    }

    int getScrollbarPosLine() {
        return this.getVerticalBar().getSelection();
    }

    int getNumLines() {
        return this.numLines;
    }

    int getNumCols() {
        return this.numCols;
    }

    int getHistorySize() {
        return this.historySize;
    }

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.add(iSelectionChangedListener);
    }

    public ISelection getSelection() {
        return this.terminalSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.selectionListeners.remove(iSelectionChangedListener);
    }

    public void setSelection(ISelection iSelection) {
    }

    void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, (ISelection)this.terminalSelection);
        for (ISelectionChangedListener iSelectionChangedListener : this.selectionListeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }
}

