/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.Messages;
import eu.geclipse.terminal.internal.Terminal;
import java.io.IOException;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.themes.IThemeManager;

class TerminalPage
extends Composite
implements ITerminalPage {
    private static final String fgColorThemeEntry = "eu.geclipse.terminal.ForgroundColor";
    private static final String bgColorThemeEntry = "eu.geclipse.terminal.BackgroundColor";
    private static final String fontTextEntry = "eu.geclipse.terminal.TextFont";
    Label descLabel = null;
    CTabItem tabItem;
    private Terminal terminal;
    private IBidirectionalConnection connection;

    TerminalPage(Composite composite, int n, CTabItem cTabItem) {
        super(composite, n);
        this.tabItem = cTabItem;
        this.createPartControl();
    }

    void copy() {
        this.terminal.copy();
    }

    void paste() {
        this.terminal.paste();
    }

    public void setTabName(final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalPage.this.tabItem.setText(string);
            }
        });
    }

    public String getTabName() {
        return this.tabItem.getText();
    }

    public void setDescription(final String string) {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalPage.this.descLabel.setText(string);
            }
        });
    }

    public String getDescription() {
        return this.descLabel.getText();
    }

    public void setFont(Font font) {
        this.terminal.setFont(font);
    }

    public Font getFont() {
        return this.terminal.getFont();
    }

    void setConnection(IBidirectionalConnection iBidirectionalConnection) throws IOException {
        this.connection = iBidirectionalConnection;
        this.terminal.setInputStream(this.connection.getInputStream());
        this.terminal.setOutputStream(this.connection.getOutputStream());
    }

    void addTerminalListener(ITerminalListener iTerminalListener) {
        this.terminal.addTerminalListener(iTerminalListener);
    }

    void closeConnection() {
        this.connection.close();
    }

    private void createPartControl() {
        GridLayout gridLayout = new GridLayout();
        gridLayout.horizontalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.verticalSpacing = 0;
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 2;
        this.descLabel = new Label((Composite)this, 0);
        this.descLabel.setText(Messages.getString("TerminalPage.noDescription"));
        this.descLabel.setLayoutData((Object)gridData);
        GridData gridData2 = new GridData();
        gridData2.horizontalAlignment = 4;
        gridData2.grabExcessHorizontalSpace = true;
        gridData2.grabExcessVerticalSpace = true;
        gridData2.verticalAlignment = 4;
        IThemeManager iThemeManager = Activator.getDefault().getWorkbench().getThemeManager();
        Color color = iThemeManager.getCurrentTheme().getColorRegistry().get(fgColorThemeEntry);
        Color color2 = iThemeManager.getCurrentTheme().getColorRegistry().get(bgColorThemeEntry);
        Font font = iThemeManager.getCurrentTheme().getFontRegistry().get(fontTextEntry);
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        int n = iPreferenceStore.getInt("historySize");
        this.terminal = new Terminal(this, 0, color, color2, n);
        this.terminal.setFont(font);
        this.terminal.setLayoutData(gridData2);
        this.tabItem.setText(Messages.getString("TerminalPage.terminal"));
        this.setLayout((Layout)gridLayout);
    }

    Terminal getTerminal() {
        return this.terminal;
    }
}

