/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.CharSet;
import eu.geclipse.terminal.internal.LineHeightMode;
import eu.geclipse.terminal.internal.LineWidthMode;
import eu.geclipse.terminal.internal.Terminal;
import eu.geclipse.terminal.internal.TerminalSelection;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

class TerminalPainter
implements PaintListener {
    private Terminal terminal;
    private TerminalSelection selection;
    private Char startChar = null;
    private int startCharLine = 0;
    private int startCharCol = 0;
    private boolean selected;
    private StringBuilder buffer = new StringBuilder();
    private int numChars = 0;
    private LineHeightMode lineHeight;
    private LineWidthMode lineWidth;
    private LineHeightMode[] lineHeightMode;
    private LineWidthMode[] lineWidthMode;
    private Font normalFont;
    private Font boldFont;
    private Font normalDoubleFont;
    private Font boldDoubleFont;
    private final char[] specialChars = new char[]{'\u2591', '\u2409', '\u240c', '\u240d', '\u240a', '\u00b0', '\u00b1', '?', '?', '\u2518', '\u2510', '\u250c', '\u2514', '\u253c', '?', '?', '\u2500', '?', '?', '\u251c', '\u2524', '\u2534', '\u252c', '\u2502', '\u2264', '\u2265'};

    TerminalPainter(Terminal terminal) {
        this.terminal = terminal;
    }

    private void addToStringBuffer(StringBuilder stringBuilder, Char char_) {
        if (char_.charSet == CharSet.SPECIAL && char_.ch >= 'a' && char_.ch <= 'z') {
            stringBuilder.append(this.specialChars[char_.ch - 97]);
        } else {
            stringBuilder.append(char_.ch);
        }
    }

    private void paintBufferedArea(GC gC) {
        int n = this.terminal.getFontHeigth();
        int n2 = this.terminal.getFontWidth();
        if (this.lineWidth == LineWidthMode.DOUBLE) {
            n2 *= 2;
        }
        if (this.startChar.negative ^ this.terminal.isInReverseScreenMode() ^ this.selected) {
            gC.setBackground(this.startChar.fgColor);
            gC.setForeground(this.startChar.bgColor);
        } else {
            gC.setBackground(this.startChar.bgColor);
            gC.setForeground(this.startChar.fgColor);
        }
        if (this.startChar.ch == '\u0000') {
            gC.fillRectangle(n2 * this.startCharCol, n * this.startCharLine, n2 * this.numChars, n);
        } else {
            gC.fillRectangle(n2 * this.startCharCol, n * this.startCharLine, n2 * this.numChars, n);
            if (this.lineHeight != LineHeightMode.NORMAL && this.lineWidth == LineWidthMode.DOUBLE) {
                Rectangle rectangle = gC.getClipping();
                gC.setClipping(0, n * this.startCharLine, rectangle.width, n);
                if (this.startChar.bold) {
                    gC.setFont(this.boldDoubleFont);
                } else {
                    gC.setFont(this.normalDoubleFont);
                }
            } else {
                gC.setClipping(null);
                if (this.startChar.bold) {
                    gC.setFont(this.boldFont);
                } else {
                    gC.setFont(this.normalFont);
                }
            }
            if (this.lineWidth == LineWidthMode.NORMAL) {
                gC.drawText(this.buffer.toString(), n2 * this.startCharCol, n * this.startCharLine);
            } else {
                int n3 = 0;
                if (this.lineHeight == LineHeightMode.DOUBLE_BOTTOM) {
                    n3 = -1;
                }
                String string = this.buffer.toString();
                int n4 = 0;
                while (n4 < string.length()) {
                    gC.drawText(string.substring(n4, n4 + 1), n2 * (this.startCharCol + n4), n * (this.startCharLine + n3));
                    ++n4;
                }
            }
            if (this.startChar.underscore) {
                int n5 = this.startCharCol;
                while (n5 < this.startCharCol + this.buffer.length()) {
                    gC.drawText("_", n2 * n5, n * this.startCharLine, true);
                    ++n5;
                }
            }
        }
    }

    private void resetStartChar(Char char_, int n, int n2) {
        if (char_.ch != '\u0000') {
            this.buffer.delete(0, this.buffer.length());
            this.addToStringBuffer(this.buffer, char_);
        }
        this.startChar = char_;
        this.startCharLine = n;
        this.startCharCol = n2;
        this.selected = this.selection.isSelected(n + this.terminal.getScrollbarPosLine(), n2);
        this.numChars = 1;
        this.lineHeight = this.lineHeightMode[n + this.terminal.getScrollbarPosLine()];
        this.lineWidth = this.lineWidthMode[n + this.terminal.getScrollbarPosLine()];
    }

    public void paintControl(PaintEvent paintEvent) {
        boolean bl;
        Char[][] charArray = this.terminal.getScreenBuffer();
        this.lineHeightMode = this.terminal.getLineHeightMode();
        this.lineWidthMode = this.terminal.getLineWidthMode();
        this.selection = (TerminalSelection)this.terminal.getSelection();
        int n = this.terminal.getNumLines();
        int n2 = charArray[0].length;
        int n3 = this.terminal.getFontHeigth();
        int n4 = this.terminal.getFontWidth();
        int n5 = paintEvent.y / n3;
        int n6 = (paintEvent.y + paintEvent.height + n3) / n3;
        boolean bl2 = bl = charArray.length < n6 + this.terminal.getScrollbarPosLine();
        if (n6 > n && bl) {
            n6 = n;
        }
        int n7 = n5;
        while (n7 < n6) {
            int n8 = paintEvent.x / n4;
            int n9 = (paintEvent.x + paintEvent.width + n4) / n4;
            if (n9 > n2) {
                n9 = n2;
            }
            if (this.lineWidthMode[n7 + this.terminal.getScrollbarPosLine()] == LineWidthMode.DOUBLE) {
                n8 /= 2;
                n9 = (n9 + 1) / 2;
            }
            int n10 = n8;
            while (n10 < n9) {
                Char char_ = charArray[n7 + this.terminal.getScrollbarPosLine()][n10];
                if (this.startChar == null) {
                    this.resetStartChar(char_, n7, n10);
                } else if (this.startChar.ch == '\u0000' && char_.ch == '\u0000' && char_.hasSameFormat(this.startChar) && this.selection.isSelected(n7 + this.terminal.getScrollbarPosLine(), n10) == this.selected) {
                    ++this.numChars;
                } else if (this.startChar.ch != '\u0000' && char_.ch != '\u0000' && char_.hasSameFormat(this.startChar) && this.selection.isSelected(n7 + this.terminal.getScrollbarPosLine(), n10) == this.selected) {
                    this.addToStringBuffer(this.buffer, char_);
                    ++this.numChars;
                } else {
                    this.paintBufferedArea(paintEvent.gc);
                    this.resetStartChar(char_, n7, n10);
                }
                ++n10;
            }
            this.paintBufferedArea(paintEvent.gc);
            this.startChar = null;
            if (n7 + this.terminal.getScrollbarPosLine() == this.terminal.getCursorLine() + this.terminal.getHistorySize()) {
                n10 = 1;
                if (this.lineWidthMode[n7 + this.terminal.getScrollbarPosLine()] == LineWidthMode.DOUBLE) {
                    n10 = 2;
                }
                paintEvent.gc.drawText("_", n4 * this.terminal.getCursorCol() * n10, n3 * n7, true);
            }
            ++n7;
        }
        paintEvent.gc.setBackground(this.terminal.getBackground());
        if (bl && paintEvent.y + paintEvent.height >= n3 * n) {
            n7 = paintEvent.y + paintEvent.height - n3 * n;
            paintEvent.gc.fillRectangle(paintEvent.x, n3 * n, paintEvent.width, n7);
        }
        if (paintEvent.x + paintEvent.width >= n4 * n2) {
            n7 = paintEvent.x + paintEvent.width - n4 * n2;
            paintEvent.gc.fillRectangle(n4 * n2, paintEvent.y, n7, paintEvent.height);
        }
    }

    void setFont(Font font) {
        FontData fontData = font.getFontData()[0];
        fontData.setStyle(0);
        this.normalFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(1);
        this.boldFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(0);
        fontData.setHeight(fontData.getHeight() * 2);
        this.normalDoubleFont = new Font(font.getDevice(), fontData);
        fontData.setStyle(1);
        this.boldDoubleFont = new Font(font.getDevice(), fontData);
    }

    void scrollUp(int n, int n2) {
        Char[][] charArray = this.terminal.getScreenBuffer();
        int n3 = charArray[0].length;
        int n4 = this.terminal.getFontHeigth();
        int n5 = this.terminal.getFontWidth();
        GC gC = new GC((Drawable)this.terminal);
        gC.copyArea(0, n4 * (n + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine() + 1), n5 * n3, n4 * (n2 - n), 0, n4 * (n + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine()), true);
        gC.dispose();
    }

    void scrollDown(int n, int n2) {
        Char[][] charArray = this.terminal.getScreenBuffer();
        int n3 = charArray[0].length;
        int n4 = this.terminal.getFontHeigth();
        int n5 = this.terminal.getFontWidth();
        GC gC = new GC((Drawable)this.terminal);
        gC.copyArea(0, n4 * (n + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine()), n5 * n3, n4 * (n2 - n), 0, n4 * (n + this.terminal.getHistorySize() - this.terminal.getScrollbarPosLine() + 1), true);
        gC.dispose();
    }
}

