/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.terminal.internal.Char;
import eu.geclipse.terminal.internal.Terminal;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.widgets.Display;

class TerminalSelection
implements ITextSelection,
MouseMoveListener,
MouseListener {
    private int startRow;
    private int startCol;
    private int endRow;
    private int endCol;
    private int row1;
    private int col1;
    private int row2;
    private int col2;
    private Terminal terminal;

    TerminalSelection(Terminal terminal) {
        this.terminal = terminal;
    }

    void clearSelection() {
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                TerminalSelection.this.clearSelection(0, 0);
            }
        });
    }

    void clearSelection(int n, int n2) {
        boolean bl = !this.isEmpty();
        this.row1 = n;
        this.col1 = n2;
        this.row2 = n;
        this.col2 = n2;
        this.startRow = n;
        this.startCol = n2;
        this.endRow = n;
        this.endCol = n2;
        if (bl) {
            this.terminal.redraw();
        }
    }

    private void updateSelection(int n, int n2) {
        this.row2 = n;
        this.col2 = n2;
        if (this.row1 < this.row2 || this.row1 == this.row2 && this.col1 < this.col2) {
            this.startRow = this.row1;
            this.startCol = this.col1;
            this.endRow = n;
            this.endCol = n2;
        } else {
            this.startRow = n;
            this.startCol = n2;
            this.endRow = this.row1;
            this.endCol = this.col1;
        }
    }

    private int getColForXPos(int n) {
        int n2 = n / this.terminal.getFontWidth();
        if (n2 > this.terminal.getNumCols()) {
            n2 = this.terminal.getNumCols();
        }
        return n2;
    }

    private int getRowForYPos(int n) {
        int n2 = this.terminal.getScrollbarPosLine();
        int n3 = n / this.terminal.getFontHeigth() + n2;
        if (n3 >= this.terminal.getNumLines() + this.terminal.getHistorySize()) {
            n3 = this.terminal.getNumLines() + this.terminal.getHistorySize() - 1;
        }
        return n3;
    }

    public int getEndLine() {
        return this.endRow;
    }

    public int getLength() {
        return this.getText().length();
    }

    public int getOffset() {
        return 0;
    }

    public int getStartLine() {
        return this.startRow;
    }

    public String getText() {
        StringBuilder stringBuilder = new StringBuilder();
        Char[][] charArray = this.terminal.getScreenBuffer();
        int n = this.startRow;
        while (n <= this.endRow) {
            int n2 = n == this.startRow ? this.startCol : 0;
            while (n2 < (n == this.endRow ? this.endCol : this.terminal.getNumCols())) {
                char c = charArray[n][n2].ch;
                if (c != '\u0000') {
                    stringBuilder.append(c);
                }
                ++n2;
            }
            if (n != this.endRow) {
                stringBuilder.append('\n');
            }
            ++n;
        }
        return stringBuilder.toString();
    }

    public boolean isEmpty() {
        return this.startCol == this.endCol && this.startRow == this.endRow;
    }

    public void mouseDoubleClick(MouseEvent mouseEvent) {
        char c;
        int n;
        int n2 = this.getRowForYPos(mouseEvent.y);
        int n3 = n = this.getColForXPos(mouseEvent.x);
        int n4 = n;
        do {
            c = this.terminal.getScreenBuffer()[n2][n3].ch;
        } while (--n3 >= 0 && c != ' ' && c != '\u0000');
        ++n3;
        if (c == ' ' || c == '\u0000') {
            ++n3;
        }
        do {
            c = this.terminal.getScreenBuffer()[n2][n4].ch;
        } while (++n4 < this.terminal.getNumCols() && c != ' ' && c != '\u0000');
        if (c == ' ' || c == '\u0000') {
            --n4;
        }
        this.clearSelection(n2, n3);
        this.updateSelection(n2, n4);
        this.triggerRedraw(n2, n3, n2, n4);
        this.terminal.fireSelectionChanged();
    }

    public void mouseDown(MouseEvent mouseEvent) {
        if (mouseEvent.button == 1) {
            this.clearSelection(this.getRowForYPos(mouseEvent.y), this.getColForXPos(mouseEvent.x));
        }
    }

    public void mouseUp(MouseEvent mouseEvent) {
    }

    public void mouseMove(MouseEvent mouseEvent) {
        if ((mouseEvent.stateMask & 0x80000) != 0) {
            int n = this.startRow;
            int n2 = this.startCol;
            int n3 = this.endRow;
            int n4 = this.endCol;
            this.updateSelection(this.getRowForYPos(mouseEvent.y), this.getColForXPos(mouseEvent.x));
            this.triggerRedraw(n, n2, this.startRow, this.startCol);
            this.triggerRedraw(n3, n4, this.endRow, this.endCol);
            this.terminal.fireSelectionChanged();
        }
    }

    private void triggerRedraw(int n, int n2, int n3, int n4) {
        int n5 = Math.min(n, n3);
        int n6 = Math.max(n, n3);
        int n7 = Math.min(n2, n4);
        int n8 = Math.max(n2, n4);
        if (n5 != n6) {
            this.terminal.triggerRedraw(0, n5 - this.terminal.getHistorySize(), this.terminal.getNumCols(), n6 - n5 + 1);
        } else if (n7 != n8) {
            this.terminal.triggerRedraw(n7, n5 - this.terminal.getHistorySize(), n8 - n7, 1);
        }
    }

    boolean isSelected(int n, int n2) {
        return n > this.startRow && n < this.endRow || n == this.startRow && n != this.endRow && n2 >= this.startCol || n != this.startRow && n == this.endRow && n2 < this.endCol || n == this.startRow && n == this.endRow && n2 >= this.startCol && n2 < this.endCol;
    }
}

