/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.terminal.internal;

import eu.geclipse.core.IBidirectionalConnection;
import eu.geclipse.terminal.ITerminalListener;
import eu.geclipse.terminal.ITerminalPage;
import eu.geclipse.terminal.ITerminalView;
import eu.geclipse.terminal.internal.Activator;
import eu.geclipse.terminal.internal.NewTerminalDropDownAction;
import eu.geclipse.terminal.internal.SelectionProviderIntermediate;
import eu.geclipse.terminal.internal.TerminalPage;
import java.io.IOException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabFolder2Adapter;
import org.eclipse.swt.custom.CTabFolder2Listener;
import org.eclipse.swt.custom.CTabFolderEvent;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.part.ViewPart;

public class TerminalView
extends ViewPart
implements ITerminalView {
    CTabFolder cTabFolder = null;
    SelectionProviderIntermediate selectionProvider;
    private NewTerminalDropDownAction newTerminalAction;

    public void createPartControl(Composite composite) {
        this.makeActions();
        this.contributeToActionBars();
        this.selectionProvider = new SelectionProviderIntermediate();
        this.getSite().setSelectionProvider((ISelectionProvider)this.selectionProvider);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        this.cTabFolder = new CTabFolder(composite, 0x800400);
        this.cTabFolder.setLayoutData((Object)gridData);
        this.cTabFolder.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent focusEvent) {
                CTabFolder cTabFolder = (CTabFolder)focusEvent.widget;
                CTabItem cTabItem = cTabFolder.getSelection();
                if (cTabItem != null && cTabItem.getControl() != null) {
                    cTabItem.getControl().setFocus();
                }
            }
        });
        this.cTabFolder.addCTabFolder2Listener((CTabFolder2Listener)new CTabFolder2Adapter(){

            public void close(CTabFolderEvent cTabFolderEvent) {
                ((TerminalPage)((CTabItem)cTabFolderEvent.item).getControl()).closeConnection();
            }
        });
        IActionBars iActionBars = this.getViewSite().getActionBars();
        iActionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)new Action(){

            public void run() {
                CTabItem cTabItem = TerminalView.this.cTabFolder.getSelection();
                if (cTabItem != null && cTabItem.getControl() != null) {
                    ((TerminalPage)cTabItem.getControl()).paste();
                }
            }
        });
    }

    private void contributeToActionBars() {
        IActionBars iActionBars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(iActionBars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager iToolBarManager) {
        iToolBarManager.add((IAction)this.newTerminalAction);
    }

    private void makeActions() {
        this.newTerminalAction = new NewTerminalDropDownAction(this);
    }

    public void setFocus() {
        this.cTabFolder.setFocus();
    }

    public ITerminalPage addTerminal(IBidirectionalConnection iBidirectionalConnection, ITerminalListener iTerminalListener) throws IOException {
        final CTabItem cTabItem = new CTabItem(this.cTabFolder, 64);
        TerminalPage terminalPage = new TerminalPage((Composite)this.cTabFolder, 0, cTabItem);
        terminalPage.setConnection(iBidirectionalConnection);
        terminalPage.addTerminalListener(iTerminalListener);
        terminalPage.addTerminalListener(new ITerminalListener(){

            public void terminated() {
                IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
                boolean bl = iPreferenceStore.getBoolean("closeTabs");
                if (bl) {
                    Display.getDefault().syncExec(new Runnable(){

                        public void run() {
                            cTabItem.dispose();
                        }
                    });
                }
            }

            public void windowSizeChanged(int n, int n2, int n3, int n4) {
            }

            public void windowTitleChanged(String string) {
            }
        });
        cTabItem.setControl((Control)terminalPage);
        this.cTabFolder.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                TerminalView.this.selectionProvider.setSelectionProviderDelegate(((TerminalPage)((CTabFolder)selectionEvent.getSource()).getSelection().getControl()).getTerminal());
            }
        });
        this.cTabFolder.setSelection(cTabItem);
        this.selectionProvider.setSelectionProviderDelegate(terminalPage.getTerminal());
        return terminalPage;
    }
}

