/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui;

import eu.geclipse.core.ISolution;
import eu.geclipse.core.Solution;
import eu.geclipse.core.SolutionRegistry;
import eu.geclipse.ui.Messages;
import eu.geclipse.ui.UISolution;
import eu.geclipse.ui.widgets.DateTimeText;
import org.eclipse.core.runtime.Assert;

public class DateTimeSolutionRegistry
extends SolutionRegistry {
    public static int USE_CALENDAR_BUTTON = SolutionRegistry.uniqueID();
    public static int APPLY_VALID_DATEFORMAT = SolutionRegistry.uniqueID();
    public static int DELETE_ENTERED_DATE = SolutionRegistry.uniqueID();
    private static DateTimeSolutionRegistry singleton;

    public static DateTimeSolutionRegistry getRegistry() {
        if (singleton == null) {
            singleton = new DateTimeSolutionRegistry();
        }
        return singleton;
    }

    public ISolution findSolution(int n, DateTimeText dateTimeText) {
        Object object = null;
        if (n == USE_CALENDAR_BUTTON) {
            object = this.createStartCalendarSolutution(dateTimeText);
        } else if (n == APPLY_VALID_DATEFORMAT) {
            object = new Solution(APPLY_VALID_DATEFORMAT, String.valueOf(Messages.getString("DateTimeSolutionRegistry.EnterDateInFormat")) + dateTimeText.getValidDateFormat()){};
        } else if (n == DELETE_ENTERED_DATE) {
            object = new Solution(DELETE_ENTERED_DATE, Messages.getString("DateTimeSolutionRegistry.DeleteDate")){};
        }
        Assert.isNotNull((Object)object, (String)("Unknown id in DateTimeSolutionRegistry: " + Integer.valueOf(n).toString()));
        return object;
    }

    private ISolution createStartCalendarSolutution(final DateTimeText dateTimeText) {
        return new UISolution(USE_CALENDAR_BUTTON, Messages.getString("DateTimeSolutionRegistry.UseCalendarButton"), dateTimeText.getShell()){

            public void solve() {
                dateTimeText.openCalendarDialog();
            }
        };
    }

    public static /* bridge */ /* synthetic */ SolutionRegistry getRegistry() {
        return DateTimeSolutionRegistry.getRegistry();
    }
}

