/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui;

import eu.geclipse.core.auth.AuthenticationException;
import eu.geclipse.core.auth.CoreAuthTokenProvider;
import eu.geclipse.core.auth.IAuthTokenProvider;
import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.core.auth.IAuthenticationTokenDescription;
import eu.geclipse.ui.Messages;
import eu.geclipse.ui.dialogs.NewProblemDialog;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.wizards.wizardselection.ExtPointWizardSelectionListPage;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.cheatsheets.CheatSheetListener;
import org.eclipse.ui.cheatsheets.ICheatSheetEvent;
import org.eclipse.ui.cheatsheets.ICheatSheetManager;

public class UIAuthTokenProvider
extends CheatSheetListener
implements IAuthTokenProvider {
    protected static ICheatSheetManager cheatSheetManager;
    private static final String WIZARD_PAGE_NAME = "pagename";
    protected Shell shell;
    protected Display display;

    public UIAuthTokenProvider() {
        this(null);
    }

    public UIAuthTokenProvider(Shell shell) {
        IWorkbenchWindow iWorkbenchWindow;
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        this.display = iWorkbench.getDisplay();
        this.shell = shell;
        if (shell == null && (iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow()) != null) {
            this.shell = iWorkbenchWindow.getShell();
        }
    }

    public IAuthenticationToken requestToken() {
        return this.requestToken(null);
    }

    public IAuthenticationToken requestToken(IAuthenticationTokenDescription iAuthenticationTokenDescription) {
        Runner runner = new Runner(iAuthenticationTokenDescription);
        this.display.syncExec((Runnable)runner);
        return runner.token;
    }

    public boolean showNewTokenWizard(final String string) {
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/wizban/newtoken_wiz.gif");
        Wizard wizard = new Wizard(){

            public boolean performFinish() {
                return false;
            }

            public void addPages() {
                ExtPointWizardSelectionListPage extPointWizardSelectionListPage = new ExtPointWizardSelectionListPage(UIAuthTokenProvider.WIZARD_PAGE_NAME, "eu.geclipse.ui.authTokenUI", Messages.getString("UIAuthTokenProvider.wizard_first_page_title"), Messages.getString("UIAuthTokenProvider.wizard_first_page_description"), Messages.getString("UIAuthTokenProvider.noTokenCreator"));
                extPointWizardSelectionListPage.setPreselectedId(string, true);
                extPointWizardSelectionListPage.setCheatSheetManager(cheatSheetManager);
                this.addPage((IWizardPage)extPointWizardSelectionListPage);
            }
        };
        wizard.setNeedsProgressMonitor(true);
        wizard.setForcePreviousAndNextButtons(true);
        wizard.setWindowTitle(Messages.getString("UIAuthTokenProvider.wizard_title"));
        wizard.setDefaultPageImageDescriptor(ImageDescriptor.createFromURL((URL)uRL));
        WizardDialog wizardDialog = new WizardDialog(this.shell, (IWizard)wizard);
        return wizardDialog.open() == 0;
    }

    protected void validateToken(final IAuthenticationToken iAuthenticationToken) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
        progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iAuthenticationToken.validate(iProgressMonitor);
                }
                catch (AuthenticationException authenticationException) {
                    throw new InvocationTargetException(authenticationException);
                }
            }
        });
    }

    protected void activateToken(final IAuthenticationToken iAuthenticationToken) throws InvocationTargetException, InterruptedException {
        ProgressMonitorDialog progressMonitorDialog = new ProgressMonitorDialog(this.shell);
        progressMonitorDialog.run(false, false, new IRunnableWithProgress(){

            public void run(IProgressMonitor iProgressMonitor) throws InvocationTargetException, InterruptedException {
                try {
                    iAuthenticationToken.setActive(true, iProgressMonitor);
                }
                catch (AuthenticationException authenticationException) {
                    throw new InvocationTargetException(authenticationException);
                }
            }
        });
    }

    public void cheatSheetEvent(ICheatSheetEvent iCheatSheetEvent) {
        cheatSheetManager = iCheatSheetEvent.getCheatSheetManager();
        if (cheatSheetManager.getData("startingPageName") == null) {
            cheatSheetManager.setData("startingPageName", "none");
        }
    }

    private class Runner
    implements Runnable {
        IAuthenticationTokenDescription description;
        IAuthenticationToken token;

        public Runner(IAuthenticationTokenDescription iAuthenticationTokenDescription) {
            this.description = iAuthenticationTokenDescription;
        }

        public void run() {
            String string;
            boolean bl;
            CoreAuthTokenProvider coreAuthTokenProvider = new CoreAuthTokenProvider();
            this.token = coreAuthTokenProvider.requestToken(this.description);
            if (this.token == null && (bl = MessageDialog.openQuestion((Shell)UIAuthTokenProvider.this.shell, (String)Messages.getString("UIAuthTokenProvider.req_token_title"), (String)Messages.getString("UIAuthTokenProvider.new_token_question"))) && UIAuthTokenProvider.this.showNewTokenWizard(string = this.description.getWizardId())) {
                this.token = coreAuthTokenProvider.requestToken(this.description);
            }
            if (this.token != null) {
                Throwable throwable = null;
                try {
                    if (!this.token.isValid()) {
                        UIAuthTokenProvider.this.validateToken(this.token);
                    }
                    if (!this.token.isActive()) {
                        UIAuthTokenProvider.this.activateToken(this.token);
                    }
                }
                catch (InvocationTargetException invocationTargetException) {
                    throwable = invocationTargetException.getCause();
                    if (throwable == null) {
                        throwable = invocationTargetException;
                    }
                }
                catch (InterruptedException interruptedException) {
                    throwable = interruptedException;
                }
                if (throwable != null) {
                    NewProblemDialog.openProblem(UIAuthTokenProvider.this.shell, Messages.getString("UIAuthTokenProvider.token_activation_error_title"), Messages.getString("UIAuthTokenProvider.token_activation_error_message"), throwable);
                }
            }
        }
    }
}

