/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.decorators;

import eu.geclipse.core.jobs.GridJob;
import eu.geclipse.core.model.IGridJobStatus;
import eu.geclipse.ui.internal.Activator;
import java.net.URL;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IDecoration;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ILightweightLabelDecorator;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;

public class GridJobDecorator
implements ILightweightLabelDecorator {
    private static final String STATUS_UNKNOWN_IMG = "status_unknown.gif";
    private static final String STATUS_SUBMITTED_IMG = "status_submitted.gif";
    private static final String STATUS_WAITING_IMG = "status_waiting.gif";
    private static final String STATUS_RUNNING_IMG = "status_running.gif";
    private static final String STATUS_DONE_IMG = "status_done.gif";
    private static final String STATUS_ABORTED_IMG = "status_aborted.gif";
    private static final String STATUS_ABANDONED_IMG = "status_abandoned.gif";
    private static Hashtable<Integer, String> imageNames = new Hashtable();
    private List<ILabelProviderListener> listeners = new LinkedList<ILabelProviderListener>();

    static {
        imageNames.put(new Integer(128), STATUS_UNKNOWN_IMG);
        imageNames.put(new Integer(1), STATUS_SUBMITTED_IMG);
        imageNames.put(new Integer(2), STATUS_WAITING_IMG);
        imageNames.put(new Integer(4), STATUS_RUNNING_IMG);
        imageNames.put(new Integer(8), STATUS_DONE_IMG);
        imageNames.put(new Integer(16), STATUS_ABORTED_IMG);
        imageNames.put(new Integer(32), STATUS_ABANDONED_IMG);
    }

    public void decorate(Object object, IDecoration iDecoration) {
        if (object instanceof GridJob) {
            IGridJobStatus iGridJobStatus = ((GridJob)object).getJobStatus();
            ImageDescriptor imageDescriptor = this.getIcon(iGridJobStatus.getType());
            iDecoration.addOverlay(imageDescriptor, 2);
        }
    }

    private ImageDescriptor getIcon(int n) {
        ImageDescriptor imageDescriptor = null;
        String string = imageNames.get(new Integer(n));
        URL uRL = Activator.getDefault().getBundle().getEntry("icons/ovr16/" + string);
        imageDescriptor = ImageDescriptor.createFromURL((URL)uRL);
        return imageDescriptor;
    }

    public void addListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.add(iLabelProviderListener);
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object object, String string) {
        return true;
    }

    public void removeListener(ILabelProviderListener iLabelProviderListener) {
        this.listeners.remove(iLabelProviderListener);
    }

    public void updateListeners() {
        for (ILabelProviderListener iLabelProviderListener : this.listeners) {
            iLabelProviderListener.labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
        }
    }
}

