/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.auth.IAuthenticationToken;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import java.util.Date;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AuthTokenInfoDialog
extends IconAndMessageDialog {
    private IAuthenticationToken token;

    public AuthTokenInfoDialog(IAuthenticationToken iAuthenticationToken, Shell shell) {
        super(shell);
        this.setShellStyle(68848);
        this.token = iAuthenticationToken;
    }

    protected IAuthenticationToken getToken() {
        return this.token;
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 600;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        Label label = new Label(composite2, 16384);
        label.setText(Messages.getString("AuthTokenInfoDialog.token_id_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        Text text = new Text(composite2, 18432);
        text.setText(this.token.getID());
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        text.setLayoutData((Object)gridData);
        text.setEditable(false);
        Label label2 = new Label(composite2, 16384);
        label2.setText(Messages.getString("AuthTokenInfoDialog.token_type_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label2.setLayoutData((Object)gridData);
        Text text2 = new Text(composite2, 18432);
        text2.setText(this.token.getDescription().getTokenTypeName());
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        text2.setLayoutData((Object)gridData);
        text2.setEditable(false);
        Label label3 = new Label(composite2, 16384);
        label3.setText(Messages.getString("AuthTokenInfoDialog.token_state_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label3.setLayoutData((Object)gridData);
        String string = this.token.isActive() ? Messages.getString("AuthTokenInfoDialog.state_active") : Messages.getString("AuthTokenInfoDialog.state_inactive");
        Text text3 = new Text(composite2, 18432);
        text3.setText(string);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        text3.setLayoutData((Object)gridData);
        text3.setEditable(false);
        Label label4 = new Label(composite2, 16384);
        label4.setText(Messages.getString("AuthTokenInfoDialog.exp_date_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label4.setLayoutData((Object)gridData);
        Text text4 = new Text(composite2, 18432);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        text4.setLayoutData((Object)gridData);
        text4.setEditable(false);
        if (!this.token.isActive()) {
            text4.setText(Messages.getString("AuthTokenInfoDialog.token_not_active_message"));
        } else {
            long l = this.token.getTimeLeft();
            if (l < 0L) {
                text4.setText(Messages.getString("AuthTokenInfoDialog.infinite_lifetime_message"));
            } else if (l == 0L) {
                text4.setText(Messages.getString("AuthTokenInfoDialog.token_expired_message"));
            } else {
                Date date = new Date();
                date.setTime(date.getTime() + l * 1000L);
                StringBuilder stringBuilder = new StringBuilder(date.toString());
                int n = (int)(l / 86400L);
                int n2 = (int)(l % 86400L / 3600L);
                int n3 = (int)(l % 3600L / 60L);
                int n4 = (int)(l % 60L);
                String string2 = String.format(" (%1$dd %2$2dh %3$2dm %4$2ds)", new Integer(n), new Integer(n2), new Integer(n3), new Integer(n4));
                text4.setText(String.valueOf(stringBuilder.toString()) + string2);
            }
        }
        Control control = this.createInfoArea(composite2);
        gridData = new GridData(1808);
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        control.setLayoutData((Object)gridData);
        return composite2;
    }

    protected Image getImage() {
        return this.getInfoImage();
    }

    protected Control createInfoArea(Composite composite) {
        Composite composite2 = new Composite(composite, 2048);
        composite2.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label(composite2, 0);
        label.setText(Messages.getString("AuthTokenInfoDialog.no_info_label"));
        GridData gridData = new GridData();
        label.setLayoutData((Object)gridData);
        return composite2;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return Activator.getDefault().getDialogSettings();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        String string = this.token.getDescription().getTokenTypeName();
        shell.setText(String.valueOf(string) + " " + Messages.getString("AuthTokenInfoDialog.info_suffix"));
    }
}

