/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.dialogs.ConfigureFilters.FilterCompositeFactory;
import eu.geclipse.ui.internal.dialogs.ConfigureFilters.IFilterComposite;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IGridFilter;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.TrayDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigureFiltersDialog
extends TrayDialog {
    protected TableViewer tableViewer;
    protected List<IFilterComposite> composites = new ArrayList<IFilterComposite>();
    protected List<IGridFilterConfiguration> configurations;
    protected GridFilterConfigurationsManager configurationsManager;

    public ConfigureFiltersDialog(Shell shell, GridFilterConfigurationsManager gridFilterConfigurationsManager) {
        super(shell);
        this.configurationsManager = gridFilterConfigurationsManager;
        this.configurations = this.copyConfigurations(gridFilterConfigurationsManager.getConfigurations());
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected void configureShell(Shell shell) {
        shell.setText(Messages.getString("ConfigureFiltersDialog.shell_text"));
        super.configureShell(shell);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = (Composite)super.createDialogArea(composite);
        ((GridLayout)composite2.getLayout()).numColumns = 2;
        this.createConfigurationsComposite(composite2);
        this.createFiltersComposite(composite2);
        this.selectEnabledConfiguration();
        return composite2;
    }

    private void createConfigurationsComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        composite2.setLayout((Layout)gridLayout);
        composite2.setLayoutData((Object)new GridData(4, 128, false, false));
        this.createTableLabel(composite2);
        this.createConfigsTable(composite2);
        this.createTableButtons(composite2);
    }

    private void createTableLabel(Composite composite) {
        Label label = new Label(composite, 0);
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        label.setText(Messages.getString("ConfigureFiltersDialog.table_label"));
    }

    private void createConfigsTable(Composite composite) {
        this.tableViewer = new TableViewer(composite, 2048);
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setLabelProvider((IBaseLabelProvider)this.createTableLabelProvider());
        this.tableViewer.addSelectionChangedListener(this.createTableSelectionListener());
        GridData gridData = new GridData();
        gridData.heightHint = 150;
        gridData.widthHint = 75;
        this.tableViewer.getTable().setLayoutData((Object)gridData);
        this.tableViewer.setInput(this.configurations);
    }

    protected void enableConfiguration(IGridFilterConfiguration iGridFilterConfiguration) {
        for (IGridFilterConfiguration iGridFilterConfiguration2 : this.configurations) {
            iGridFilterConfiguration2.setEnabled(iGridFilterConfiguration2 == iGridFilterConfiguration);
        }
    }

    private ILabelProvider createTableLabelProvider() {
        return new LabelProvider(){

            public String getText(Object object) {
                return ((IGridFilterConfiguration)object).getName();
            }
        };
    }

    ISelectionChangedListener createTableSelectionListener() {
        return new ISelectionChangedListener(){
            private IGridFilterConfiguration selectedConfiguration;

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                StructuredSelection structuredSelection = (StructuredSelection)selectionChangedEvent.getSelection();
                if (structuredSelection != null) {
                    if (ConfigureFiltersDialog.this.saveFilter()) {
                        this.selectedConfiguration = (IGridFilterConfiguration)structuredSelection.getFirstElement();
                        ConfigureFiltersDialog.this.enableConfiguration(this.selectedConfiguration);
                        for (IFilterComposite iFilterComposite : ConfigureFiltersDialog.this.composites) {
                            iFilterComposite.setFilter(this.selectedConfiguration);
                        }
                    } else {
                        ConfigureFiltersDialog.this.tableViewer.removeSelectionChangedListener((ISelectionChangedListener)this);
                        ConfigureFiltersDialog.this.tableViewer.setSelection((ISelection)(this.selectedConfiguration != null ? new StructuredSelection((Object)this.selectedConfiguration) : null));
                        ConfigureFiltersDialog.this.tableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
                    }
                }
                ConfigureFiltersDialog.this.setEnabledComposites(structuredSelection != null && !structuredSelection.isEmpty());
            }
        };
    }

    void setEnabledComposites(boolean bl) {
        for (IFilterComposite iFilterComposite : this.composites) {
            iFilterComposite.setEnabled(bl);
        }
    }

    private void createTableButtons(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        GridData gridData = new GridData();
        gridData.verticalAlignment = 128;
        composite2.setLayoutData((Object)gridData);
        composite2.setLayout((Layout)new GridLayout(1, false));
        this.createNewButton(composite2);
        this.createDeleteButton(composite2);
    }

    private void createNewButton(Composite composite) {
        Button button = this.createButton(composite, Messages.getString("ConfigureFiltersDialog.new_button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                InputDialog inputDialog;
                if (ConfigureFiltersDialog.this.saveFilter() && (inputDialog = new InputDialog(ConfigureFiltersDialog.this.getShell(), Messages.getString("ConfigureFiltersDialog.create_new_filter"), Messages.getString("ConfigureFiltersDialog.enter_filter_name"), "", this.createNameValidator())).open() == 0) {
                    IGridFilterConfiguration iGridFilterConfiguration = ConfigureFiltersDialog.this.configurationsManager.createConfiguration(inputDialog.getValue());
                    ConfigureFiltersDialog.this.configurations.add(iGridFilterConfiguration);
                    ConfigureFiltersDialog.this.tableViewer.add((Object)iGridFilterConfiguration);
                    ConfigureFiltersDialog.this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)iGridFilterConfiguration));
                }
            }

            private IInputValidator createNameValidator() {
                return new IInputValidator(){

                    public String isValid(String string) {
                        String string2 = null;
                        if (ConfigureFiltersDialog.this.findConfiguration(string) != null) {
                            string2 = String.format(Messages.getString("ConfigureFiltersDialog.filter_already_exists"), string);
                        }
                        return string2;
                    }
                };
            }
        });
    }

    private void createDeleteButton(Composite composite) {
        Button button = this.createButton(composite, Messages.getString("ConfigureFiltersDialog.delete_button"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                if (ConfigureFiltersDialog.this.saveFilter()) {
                    StructuredSelection structuredSelection = (StructuredSelection)ConfigureFiltersDialog.this.tableViewer.getSelection();
                    if (structuredSelection == null || structuredSelection.isEmpty()) {
                        MessageDialog.openWarning((Shell)ConfigureFiltersDialog.this.getShell(), (String)Messages.getString("ConfigureFiltersDialog.delete_filter"), (String)Messages.getString("ConfigureFiltersDialog.select_filter"));
                    } else {
                        IGridFilterConfiguration iGridFilterConfiguration = (IGridFilterConfiguration)structuredSelection.getFirstElement();
                        ConfigureFiltersDialog.this.tableViewer.remove((Object)iGridFilterConfiguration);
                        ConfigureFiltersDialog.this.configurations.remove(iGridFilterConfiguration);
                        ConfigureFiltersDialog.this.selectDefaultConfiguration();
                    }
                }
            }
        });
    }

    void selectDefaultConfiguration() {
        if (!this.configurations.isEmpty()) {
            IGridFilterConfiguration iGridFilterConfiguration = this.configurations.get(0);
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)iGridFilterConfiguration));
        }
    }

    private Button createButton(Composite composite, String string) {
        Button button = new Button(composite, 0);
        GridData gridData = new GridData();
        gridData.widthHint = 80;
        button.setLayoutData((Object)gridData);
        button.setText(string);
        return button;
    }

    private void createFiltersComposite(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        IGridFilterConfiguration iGridFilterConfiguration = this.configurations.get(0);
        for (IGridFilter iGridFilter : iGridFilterConfiguration.getFilters()) {
            IFilterComposite iFilterComposite = FilterCompositeFactory.create(iGridFilter, composite2);
            Assert.isTrue((iFilterComposite != null ? 1 : 0) != 0, (String)"Probably IGridFilter.makeClone() returned null");
            if (iFilterComposite == null) continue;
            this.composites.add(iFilterComposite);
        }
    }

    private List<IGridFilterConfiguration> copyConfigurations(List<IGridFilterConfiguration> list) {
        ArrayList<IGridFilterConfiguration> arrayList = new ArrayList<IGridFilterConfiguration>(3 + (list != null ? list.size() : 0));
        if (list != null) {
            try {
                for (IGridFilterConfiguration iGridFilterConfiguration : list) {
                    arrayList.add(iGridFilterConfiguration.clone());
                }
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                Activator.logException(cloneNotSupportedException);
            }
        }
        if (arrayList.isEmpty()) {
            IGridFilterConfiguration iGridFilterConfiguration;
            iGridFilterConfiguration = this.configurationsManager.createConfiguration(Messages.getString("ConfigureFiltersDialog.default_config"));
            arrayList.add(iGridFilterConfiguration);
        }
        return arrayList;
    }

    IGridFilterConfiguration findConfiguration(String string) {
        IGridFilterConfiguration iGridFilterConfiguration = null;
        Iterator<IGridFilterConfiguration> iterator = this.configurations.iterator();
        while (iterator.hasNext() && iGridFilterConfiguration == null) {
            IGridFilterConfiguration iGridFilterConfiguration2 = iterator.next();
            if (!iGridFilterConfiguration2.getName().equals(string)) continue;
            iGridFilterConfiguration = iGridFilterConfiguration2;
        }
        return iGridFilterConfiguration;
    }

    protected void okPressed() {
        if (this.saveFilter()) {
            super.okPressed();
        }
    }

    public List<IGridFilterConfiguration> getConfigurations() {
        return this.configurations;
    }

    public boolean isHelpAvailable() {
        return false;
    }

    protected boolean saveFilter() {
        boolean bl = true;
        Iterator<IFilterComposite> iterator = this.composites.iterator();
        while (bl && iterator.hasNext()) {
            IFilterComposite iFilterComposite = iterator.next();
            bl &= iFilterComposite.saveToFilter();
        }
        return bl;
    }

    private void selectEnabledConfiguration() {
        IGridFilterConfiguration iGridFilterConfiguration;
        if (!this.configurations.isEmpty() && (iGridFilterConfiguration = this.findEnabledConfiguration()) != null) {
            this.tableViewer.setSelection((ISelection)new StructuredSelection((Object)iGridFilterConfiguration));
        }
    }

    private IGridFilterConfiguration findEnabledConfiguration() {
        IGridFilterConfiguration iGridFilterConfiguration = null;
        Iterator<IGridFilterConfiguration> iterator = this.configurations.iterator();
        while (iterator.hasNext() && iGridFilterConfiguration == null) {
            IGridFilterConfiguration iGridFilterConfiguration2 = iterator.next();
            if (!iGridFilterConfiguration2.isEnabled()) continue;
            iGridFilterConfiguration = iGridFilterConfiguration2;
        }
        return iGridFilterConfiguration;
    }
}

