/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.core.model.GridModel;
import eu.geclipse.core.model.IConnectionManager;
import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridModelEvent;
import eu.geclipse.core.model.IGridModelListener;
import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.GridConnectionFilter;
import eu.geclipse.ui.internal.GridConnectionProtocolFilter;
import eu.geclipse.ui.internal.actions.NewConnectionAction;
import eu.geclipse.ui.internal.actions.ViewModeToggleAction;
import eu.geclipse.ui.providers.ConfigurableContentProvider;
import eu.geclipse.ui.providers.ConnectionViewContentProvider;
import eu.geclipse.ui.providers.ConnectionViewLabelProvider;
import eu.geclipse.ui.providers.IConfigurationListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class GridFileDialog
extends Dialog
implements IGridModelListener {
    private static final String LOCAL_FILTER = "file";
    protected TreeViewer treeViewer;
    private GridConnectionFilter filter;
    private String title;
    private TreeColumn projectColumn;
    private int lastProjectColumnWidth = 100;
    private Text filenameText;
    private Combo filetypeCombo;
    private IGridConnectionElement selectedElement;
    private GridConnectionProtocolFilter protocolFilter;

    public GridFileDialog(Shell shell, String string, boolean bl) {
        super(shell);
        this.setShellStyle(67696);
        this.title = string;
        this.filter = new GridConnectionFilter();
        if (!bl) {
            this.protocolFilter = new GridConnectionProtocolFilter();
            this.protocolFilter.addFilterProtocol(LOCAL_FILTER);
        }
    }

    public static IGridConnectionElement openFileDialog(Shell shell, String string, String[] stringArray, boolean bl) {
        GridFileDialog gridFileDialog = new GridFileDialog(shell, string, bl);
        gridFileDialog.setFilteredFileExtensions(stringArray);
        gridFileDialog.open();
        return gridFileDialog.getSelectedElement();
    }

    public boolean close() {
        GridModel.getRoot().removeGridModelListener((IGridModelListener)this);
        return super.close();
    }

    public void setFilteredFileExtensions(String[] stringArray) {
        this.filter.clearFileExtensionFilters();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string = stringArray2[n2];
                this.filter.addFileExtensionFilter(string);
                ++n2;
            }
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected Control createDialogArea(Composite composite) {
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(1, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.widthHint = 400;
        gridData.heightHint = 400;
        composite2.setLayoutData((Object)gridData);
        Composite composite3 = new Composite(composite2, 2048);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        gridLayout.horizontalSpacing = 0;
        gridLayout.verticalSpacing = 0;
        composite3.setLayout((Layout)gridLayout);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        composite3.setLayoutData((Object)gridData);
        ToolBarManager toolBarManager = new ToolBarManager(0x800000);
        ToolBar toolBar = toolBarManager.createControl(composite3);
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.verticalAlignment = 1;
        toolBar.setLayoutData((Object)gridData);
        int n = 268436228;
        this.treeViewer = new TreeViewer(composite3, n);
        ConnectionViewContentProvider connectionViewContentProvider = new ConnectionViewContentProvider();
        this.treeViewer.setContentProvider((IContentProvider)connectionViewContentProvider);
        ConnectionViewLabelProvider connectionViewLabelProvider = new ConnectionViewLabelProvider();
        this.treeViewer.setLabelProvider((IBaseLabelProvider)connectionViewLabelProvider);
        IConnectionManager iConnectionManager = GridModel.getConnectionManager();
        this.treeViewer.setInput((Object)iConnectionManager);
        Tree tree = this.treeViewer.getTree();
        tree.setHeaderVisible(true);
        gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        tree.setLayoutData((Object)gridData);
        TreeColumn treeColumn = new TreeColumn(tree, 0);
        treeColumn.setText(Messages.getString("GridFileDialog.name_column"));
        treeColumn.setAlignment(16384);
        treeColumn.setWidth(300);
        this.projectColumn = new TreeColumn(tree, 0);
        this.projectColumn.setText(Messages.getString("GridFileDialog.project_column"));
        this.projectColumn.setAlignment(16384);
        this.projectColumn.setWidth(this.lastProjectColumnWidth);
        IWorkbenchWindow iWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        NewConnectionAction newConnectionAction = new NewConnectionAction(iWorkbenchWindow);
        toolBarManager.add((IAction)newConnectionAction);
        ViewModeToggleAction viewModeToggleAction = new ViewModeToggleAction(connectionViewContentProvider);
        toolBarManager.add((IAction)viewModeToggleAction);
        toolBarManager.update(true);
        Composite composite4 = new Composite(composite2, 0);
        composite4.setLayout((Layout)new GridLayout(2, false));
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        composite4.setLayoutData((Object)gridData);
        Label label = new Label(composite4, 0);
        label.setText(Messages.getString("GridFileDialog.filename_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label.setLayoutData((Object)gridData);
        this.filenameText = new Text(composite4, 2048);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.filenameText.setLayoutData((Object)gridData);
        Label label2 = new Label(composite4, 0);
        label2.setText(Messages.getString("GridFileDialog.filetype_label"));
        gridData = new GridData();
        gridData.horizontalAlignment = 1;
        label2.setLayoutData((Object)gridData);
        this.filetypeCombo = new Combo(composite4, 2056);
        gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.filetypeCombo.setLayoutData((Object)gridData);
        this.treeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                ISelection iSelection = selectionChangedEvent.getSelection();
                GridFileDialog.this.handleSelectionChanged(iSelection);
            }
        });
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent doubleClickEvent) {
                GridFileDialog.this.handleDoubleClick();
            }
        });
        GridModel.getRoot().addGridModelListener((IGridModelListener)this);
        connectionViewContentProvider.addConfigurationListener(new IConfigurationListener(){

            public void configurationChanged(ConfigurableContentProvider configurableContentProvider) {
                GridFileDialog.this.handleConfigurationChanged(configurableContentProvider);
            }
        });
        this.filter.link((StructuredViewer)this.treeViewer, this.filetypeCombo);
        if (this.protocolFilter != null) {
            this.treeViewer.addFilter((ViewerFilter)this.protocolFilter);
        }
        return composite2;
    }

    public IGridConnectionElement getSelectedElement() {
        return this.getReturnCode() == 0 ? this.selectedElement : null;
    }

    public void gridModelChanged(IGridModelEvent iGridModelEvent) {
        IGridElement iGridElement = iGridModelEvent.getSource();
        this.refreshViewer(iGridElement);
    }

    protected void handleConfigurationChanged(ConfigurableContentProvider configurableContentProvider) {
        int n = configurableContentProvider.getMode();
        if (n == 1) {
            this.projectColumn.setWidth(this.lastProjectColumnWidth);
        } else {
            this.lastProjectColumnWidth = this.projectColumn.getWidth();
            this.projectColumn.setWidth(0);
        }
        this.refreshViewer();
    }

    protected void handleDoubleClick() {
        IGridConnectionElement iGridConnectionElement;
        IStructuredSelection iStructuredSelection = (IStructuredSelection)this.treeViewer.getSelection();
        Object object = iStructuredSelection.getFirstElement();
        if (this.treeViewer.isExpandable(object)) {
            boolean bl = this.treeViewer.getExpandedState(object);
            this.treeViewer.setExpandedState(object, !bl);
        } else if (object instanceof IGridConnectionElement && !(iGridConnectionElement = (IGridConnectionElement)object).isFolder()) {
            this.selectedElement = iGridConnectionElement;
            this.setReturnCode(0);
            this.close();
        }
    }

    protected void handleSelectionChanged(ISelection iSelection) {
        this.filenameText.setText("");
        this.selectedElement = null;
        if (iSelection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)iSelection;
            for (Object e : iStructuredSelection) {
                if (!(e instanceof IGridConnectionElement)) continue;
                this.selectedElement = (IGridConnectionElement)e;
                if (this.selectedElement.isFolder()) {
                    this.selectedElement = null;
                    continue;
                }
                String string = this.selectedElement.getName();
                this.filenameText.setText(string);
            }
        }
    }

    private void refreshViewer() {
        this.refreshViewer(null);
    }

    private void refreshViewer(IGridElement iGridElement) {
        Display display = this.treeViewer.getControl().getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                GridFileDialog.this.treeViewer.refresh();
            }
        });
    }
}

