/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.dialogs;

import eu.geclipse.ui.dialogs.Messages;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.widgets.StoredCombo;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.jface.dialogs.IconAndMessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.PlatformUI;

public class NewCaCertDialog
extends IconAndMessageDialog {
    public static final int FROM_DIRECTORY = 1;
    public static final int FROM_REPOSITORY = 2;
    private static final String DEFAULT_REPOSITORY = "http://www.eugridpma.org/distribution/igtf/current/accredited/tgz";
    protected StoredCombo resultCombo;
    private int source;
    private String result;

    public NewCaCertDialog(int n, Shell shell) {
        super(shell);
        this.source = n;
        switch (n) {
            case 1: {
                this.message = Messages.getString("NewCaCertDialog.from_dir_message");
                break;
            }
            case 2: {
                this.message = Messages.getString("NewCaCertDialog.from_rep_message");
            }
        }
    }

    public String getResult() {
        return this.result;
    }

    public void okPressed() {
        this.result = this.resultCombo.getText();
        super.okPressed();
    }

    protected Control createDialogArea(Composite composite) {
        this.createMessageArea(composite);
        Composite composite2 = new Composite(composite, 0);
        composite2.setLayout((Layout)new GridLayout(2, false));
        GridData gridData = new GridData(1808);
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.horizontalSpan = 2;
        composite2.setLayoutData((Object)gridData);
        switch (this.source) {
            case 2: {
                this.initFromRepository(composite2);
                break;
            }
            case 1: {
                this.initFromDirectory(composite2);
            }
        }
        return composite2;
    }

    protected void initFromRepository(Composite composite) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        this.resultCombo = new StoredCombo(composite, 2048){

            protected boolean isValidItem(String string) {
                boolean bl = true;
                try {
                    new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    bl = false;
                }
                return bl;
            }
        };
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.resultCombo.setLayoutData(gridData);
        this.resultCombo.setPreferences(iPreferenceStore, "ca_from_repo");
        if (this.resultCombo.getText().length() == 0) {
            this.resultCombo.setText(DEFAULT_REPOSITORY);
        }
    }

    protected void initFromDirectory(Composite composite) {
        IPreferenceStore iPreferenceStore = Activator.getDefault().getPreferenceStore();
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        Image image = iSharedImages.getImage("IMG_OBJ_FILE");
        this.resultCombo = new StoredCombo(composite, 2048){

            protected boolean isValidItem(String string) {
                File file = new File(string);
                return file.exists();
            }
        };
        GridData gridData = new GridData(768);
        gridData.grabExcessHorizontalSpace = true;
        this.resultCombo.setLayoutData(gridData);
        this.resultCombo.setPreferences(iPreferenceStore, "ca_from_dir");
        Button button = new Button(composite, 8);
        button.setImage(image);
        gridData = new GridData();
        button.setLayoutData((Object)gridData);
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                DirectoryDialog directoryDialog = new DirectoryDialog(NewCaCertDialog.this.getShell());
                directoryDialog.setMessage(Messages.getString("NewCaCertDialog.from_dir_dialog_message"));
                String string = directoryDialog.open();
                if (string != null) {
                    NewCaCertDialog.this.resultCombo.setText(string);
                }
            }
        });
    }

    protected Image getImage() {
        return this.getQuestionImage();
    }

    protected String showFileDialog(String string) {
        String[] stringArray = new String[]{"*.pem", "*.*"};
        String[] stringArray2 = new String[]{"PEM-Files", "All Files"};
        FileDialog fileDialog = new FileDialog(this.getShell(), 4100);
        fileDialog.setFilterExtensions(stringArray);
        fileDialog.setFilterNames(stringArray2);
        fileDialog.setFileName(string);
        String string2 = fileDialog.open();
        return string2;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        switch (this.source) {
            case 1: {
                shell.setText(Messages.getString("NewCaCertDialog.windowTitleDirectory"));
                break;
            }
            case 2: {
                shell.setText(Messages.getString("NewCaCertDialog.windowTitleRepository"));
            }
        }
    }
}

