/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.model.IGridConnectionElement;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.ui.providers.ProgressTreeNode;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Combo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridConnectionFilter
extends ViewerFilter {
    private static final String FILTER_PREFIX = "*.";
    private static final String WILDCARD_FILTER = "*";
    private List<String> filters = new ArrayList<String>();
    private String activeFilter;

    public void addFileExtensionFilter(String string) {
        if (!this.matches(string, this.filters)) {
            this.filters.add(string);
            if (this.activeFilter == null) {
                this.activeFilter = string;
            }
        }
    }

    public void clearFileExtensionFilters() {
        this.filters.clear();
        this.activeFilter = null;
    }

    public void link(final StructuredViewer structuredViewer, final Combo combo) {
        structuredViewer.addFilter((ViewerFilter)this);
        combo.removeAll();
        if (this.filters.isEmpty()) {
            combo.add("*.*");
            combo.setText("*.*");
        } else {
            for (String string : this.filters) {
                combo.add(FILTER_PREFIX + string);
            }
            combo.setText(FILTER_PREFIX + this.activeFilter);
        }
        combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String string = combo.getText();
                GridConnectionFilter.this.setActiveFilter(string.substring(2));
                structuredViewer.refresh();
            }
        });
    }

    public void setActiveFilter(String string) {
        if (string != null) {
            this.addFileExtensionFilter(string);
        }
        this.activeFilter = string;
    }

    public void setFileExtensionFilter(String string) {
        this.clearFileExtensionFilters();
        this.addFileExtensionFilter(string);
    }

    public boolean select(Viewer viewer, Object object, Object object2) {
        boolean bl = false;
        if (object2 instanceof IGridConnectionElement) {
            bl = this.select((IGridConnectionElement)object2);
        } else if (object2 instanceof IGridContainer) {
            bl = true;
        } else if (object2 instanceof ProgressTreeNode) {
            bl = true;
        }
        return bl;
    }

    protected boolean select(IGridConnectionElement iGridConnectionElement) {
        boolean bl = this.filters.isEmpty();
        if (this.activeFilter != null) {
            Path path;
            String string;
            bl = iGridConnectionElement.isFolder() ? true : ((string = (path = new Path(iGridConnectionElement.getName())).getFileExtension()) == null ? false : this.activeFilter.equals(WILDCARD_FILTER) || this.matches(string, this.activeFilter));
        }
        return bl;
    }

    private boolean matches(String string, List<String> list) {
        boolean bl = false;
        for (String string2 : list) {
            if (!this.matches(string, string2)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    private boolean matches(String string, String string2) {
        return string.equalsIgnoreCase(string2);
    }
}

