/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal;

import eu.geclipse.core.model.IGridElement;
import eu.geclipse.ui.internal.EmptySelection;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;

public class GridElementSelectionAdapter
implements ISelectionProvider,
ISelectionChangedListener {
    private List<ISelectionChangedListener> listeners = new ArrayList<ISelectionChangedListener>();
    private ISelection currentSelection;

    public void addSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        if (!this.listeners.contains(iSelectionChangedListener)) {
            this.listeners.add(iSelectionChangedListener);
        }
    }

    public ISelection getSelection() {
        return this.currentSelection == null ? new EmptySelection() : this.currentSelection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener iSelectionChangedListener) {
        this.listeners.remove(iSelectionChangedListener);
    }

    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
        this.setSelection(selectionChangedEvent.getSelection());
    }

    public void setSelection(ISelection iSelection) {
        if (iSelection instanceof IStructuredSelection) {
            this.setSelection((IStructuredSelection)iSelection);
        }
    }

    public void setSelection(IStructuredSelection iStructuredSelection) {
        this.currentSelection = this.remapSelection(iStructuredSelection);
        this.fireSelectionChanged();
    }

    protected void fireSelectionChanged() {
        SelectionChangedEvent selectionChangedEvent = new SelectionChangedEvent((ISelectionProvider)this, this.getSelection());
        for (ISelectionChangedListener iSelectionChangedListener : this.listeners) {
            iSelectionChangedListener.selectionChanged(selectionChangedEvent);
        }
    }

    protected IStructuredSelection remapSelection(IStructuredSelection iStructuredSelection) {
        ArrayList<IResource> arrayList = new ArrayList<IResource>();
        for (Object e : iStructuredSelection.toList()) {
            IResource iResource = this.remapObject(e);
            if (iResource == null) continue;
            arrayList.add(iResource);
        }
        return new StructuredSelection(arrayList);
    }

    private IResource remapGridElement(IGridElement iGridElement) {
        return iGridElement.getResource();
    }

    private IResource remapObject(Object object) {
        IResource iResource = null;
        if (object instanceof IResource) {
            iResource = (IResource)object;
        } else if (object instanceof IGridElement) {
            iResource = this.remapGridElement((IGridElement)object);
        } else if (object instanceof IAdaptable) {
            iResource = (IResource)((IAdaptable)object).getAdapter(IResource.class);
        }
        return iResource;
    }
}

