/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.GridElementSelectionAdapter;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.RefreshAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.jface.window.SameShellProvider;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.dialogs.PropertyDialogAction;

public class CommonActions
extends ActionGroup {
    RefreshAction refreshAction;
    private IWorkbenchSite site;
    private GridElementSelectionAdapter selectionAdapter;
    private PropertyDialogAction propertyAction;

    public CommonActions(GridModelViewPart gridModelViewPart) {
        this.site = gridModelViewPart.getSite();
        Shell shell = this.site.getShell();
        SameShellProvider sameShellProvider = new SameShellProvider((Control)shell);
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        this.selectionAdapter = new GridElementSelectionAdapter();
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
        this.propertyAction = new PropertyDialogAction((IShellProvider)sameShellProvider, (ISelectionProvider)this.selectionAdapter);
        this.refreshAction = new RefreshAction(shell);
        this.refreshAction.setText(Messages.getString("CommonActions.refresh"));
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
        ImageRegistry imageRegistry = Activator.getDefault().getImageRegistry();
        Image image = imageRegistry.get("refresh");
        ImageDescriptor imageDescriptor = ImageDescriptor.createFromImage((Image)image);
        this.refreshAction.setImageDescriptor(imageDescriptor);
        gridModelViewPart.getViewer().getControl().addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                if (keyEvent.keyCode == 0x100000E) {
                    CommonActions.this.refreshAction.run();
                }
            }
        });
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.selectionAdapter);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.refreshAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.propertyAction.isEnabled()) {
            iMenuManager.appendToGroup("group.properties", (IAction)this.propertyAction);
        }
        if (this.refreshAction.isEnabled()) {
            iMenuManager.appendToGroup("group.build", (IAction)this.refreshAction);
        }
        super.fillContextMenu(iMenuManager);
    }
}

