/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.views.filters.GridFilterConfigurationsManager;
import eu.geclipse.ui.views.filters.IFilterConfigurationListener;
import eu.geclipse.ui.views.filters.IGridFilterConfiguration;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.ui.IWorkbenchSite;

public class ConfigureFiltersAction
extends Action {
    private static final String CONFIGURE_IMG = "configure_filters";
    private static final String CONFIGURE_IMG_ON = "configure_filters_on";
    protected MenuCreator menuCreator;
    protected GridFilterConfigurationsManager filterConfigurationsManager;
    private IWorkbenchSite site;
    private IFilterConfigurationListener configurationListener;

    public ConfigureFiltersAction(IWorkbenchSite iWorkbenchSite, GridFilterConfigurationsManager gridFilterConfigurationsManager) {
        super(Messages.getString("ConfigureFiltersAction.name"), 4);
        this.filterConfigurationsManager = gridFilterConfigurationsManager;
        this.site = iWorkbenchSite;
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor(CONFIGURE_IMG));
        this.setToolTipText(Messages.getString("ConfigureFiltersAction.description"));
        this.menuCreator = new MenuCreator();
        this.setMenuCreator(this.menuCreator);
        this.initImage();
    }

    public void run() {
        this.filterConfigurationsManager.configure(this.site.getShell());
    }

    protected void setImage(boolean bl) {
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor(bl ? CONFIGURE_IMG_ON : CONFIGURE_IMG));
    }

    protected IFilterConfigurationListener getConfigurationListener() {
        if (this.configurationListener == null) {
            this.configurationListener = new IFilterConfigurationListener(){

                public void configurationChanged() {
                    ConfigureFiltersAction.this.menuCreator.disposeMenu();
                }

                public void filterConfigurationSelected(ViewerFilter[] viewerFilterArray) {
                    ConfigureFiltersAction.this.setImage(viewerFilterArray);
                }
            };
        }
        return this.configurationListener;
    }

    protected void setImage(ViewerFilter[] viewerFilterArray) {
        this.setImage(viewerFilterArray != null && viewerFilterArray.length > 0);
    }

    private void initImage() {
        if (this.filterConfigurationsManager != null) {
            this.setImage(this.filterConfigurationsManager.getEnabledFilters());
        } else {
            this.setImage(false);
        }
    }

    private class MenuCreator
    implements IMenuCreator {
        private Menu menu;

        protected MenuCreator() {
            ConfigureFiltersAction.this.filterConfigurationsManager.addConfigurationListener(ConfigureFiltersAction.this.getConfigurationListener());
        }

        public void dispose() {
            if (this.menu != null) {
                this.disposeMenu();
            }
            ConfigureFiltersAction.this.filterConfigurationsManager.removeConfigurationListener(ConfigureFiltersAction.this.getConfigurationListener());
        }

        public Menu getMenu(Control control) {
            if (this.menu == null) {
                this.menu = this.createMenu(control);
            }
            return this.menu;
        }

        public Menu getMenu(Menu menu) {
            return null;
        }

        protected void disposeMenu() {
            if (this.menu != null) {
                this.menu.dispose();
            }
            this.menu = null;
        }

        private Menu createMenu(Control control) {
            Menu menu = new Menu(control);
            for (IGridFilterConfiguration iGridFilterConfiguration : ConfigureFiltersAction.this.filterConfigurationsManager.getConfigurations()) {
                this.createMenuItem(menu, iGridFilterConfiguration);
            }
            if (!ConfigureFiltersAction.this.filterConfigurationsManager.getConfigurations().isEmpty()) {
                new MenuItem(menu, 2);
            }
            this.createConfigureMenu(menu);
            return menu;
        }

        private void createConfigureMenu(Menu menu) {
            MenuItem menuItem = new MenuItem(menu, 64);
            menuItem.setText(Messages.getString("ConfigureFiltersAction.ConfigureFilters"));
            menuItem.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent selectionEvent) {
                    ConfigureFiltersAction.this.run();
                }
            });
        }

        private void createMenuItem(Menu menu, IGridFilterConfiguration iGridFilterConfiguration) {
            MenuItem menuItem = new MenuItem(menu, 16);
            menuItem.setText(iGridFilterConfiguration.getName());
            menuItem.setSelection(iGridFilterConfiguration.isEnabled());
            menuItem.addSelectionListener((SelectionListener)new MenuItemSelectionListener(iGridFilterConfiguration));
        }
    }

    private class MenuItemSelectionListener
    extends SelectionAdapter {
        private IGridFilterConfiguration configuration;

        protected MenuItemSelectionListener(IGridFilterConfiguration iGridFilterConfiguration) {
            this.configuration = iGridFilterConfiguration;
        }

        public void widgetSelected(SelectionEvent selectionEvent) {
            MenuItem menuItem = (MenuItem)selectionEvent.getSource();
            if (menuItem != null && menuItem.getSelection()) {
                ConfigureFiltersAction.this.filterConfigurationsManager.enableConfiguration(this.configuration);
            }
        }
    }
}

