/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.jobs.JobOutputsDownloaderManager;
import eu.geclipse.core.model.IGridJob;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.Messages;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.SelectionListenerAction;

public class DownloadJobOutputsAction
extends SelectionListenerAction {
    protected DownloadJobOutputsAction() {
        super(Messages.getString("DownloadJobOutputsAction.actionName"));
        this.setImageDescriptor(Activator.getDefault().getImageRegistry().getDescriptor("DownloadJobOutput"));
    }

    public void run() {
        boolean bl = false;
        IStructuredSelection iStructuredSelection = this.getStructuredSelection();
        if (this.isAnyJobSelected(iStructuredSelection)) {
            for (Object e : iStructuredSelection) {
                if (!(e instanceof IGridJob)) continue;
                IGridJob iGridJob = (IGridJob)e;
                bl |= JobOutputsDownloaderManager.getManager().scheduleDownloading(iGridJob, true) == JobOutputsDownloaderManager.ScheduleStatus.ALREADY_SCHEDULED;
            }
        }
        if (bl) {
            this.showView("org.eclipse.ui.views.ProgressView");
        }
        super.run();
    }

    private boolean isAnyJobSelected(IStructuredSelection iStructuredSelection) {
        return iStructuredSelection != null && !iStructuredSelection.isEmpty();
    }

    protected boolean updateSelection(IStructuredSelection iStructuredSelection) {
        return this.isAnyJobSelected(iStructuredSelection);
    }

    private void showView(String string) {
        IWorkbench iWorkbench = PlatformUI.getWorkbench();
        IWorkbenchWindow iWorkbenchWindow = iWorkbench.getActiveWorkbenchWindow();
        IWorkbenchPage iWorkbenchPage = iWorkbenchWindow.getActivePage();
        try {
            iWorkbenchPage.showView(string);
        }
        catch (PartInitException partInitException) {
            Activator.logException(partInitException);
        }
    }
}

