/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.CopyAction;
import eu.geclipse.ui.internal.actions.PasteAction;
import eu.geclipse.ui.views.GridModelViewPart;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionGroup;
import org.eclipse.ui.actions.DeleteResourceAction;

public class FileActions
extends ActionGroup {
    private Clipboard clipboard;
    private IWorkbenchSite site;
    private CopyAction copyAction;
    private PasteAction pasteAction;
    private DeleteResourceAction deleteAction;

    public FileActions(GridModelViewPart gridModelViewPart) {
        this.site = gridModelViewPart.getSite();
        Shell shell = this.site.getShell();
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        this.clipboard = new Clipboard(shell.getDisplay());
        this.copyAction = new CopyAction(this.clipboard);
        this.pasteAction = new PasteAction(gridModelViewPart, this.clipboard);
        this.deleteAction = new DeleteResourceAction(shell);
        ISharedImages iSharedImages = PlatformUI.getWorkbench().getSharedImages();
        ImageDescriptor imageDescriptor = iSharedImages.getImageDescriptor("IMG_TOOL_DELETE");
        this.deleteAction.setImageDescriptor(imageDescriptor);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.copyAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.pasteAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.deleteAction);
        this.clipboard.dispose();
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.deleteAction.isEnabled()) {
            iMenuManager.appendToGroup("group.edit", (IAction)this.copyAction);
            iMenuManager.appendToGroup("group.edit", (IAction)this.pasteAction);
            iMenuManager.appendToGroup("group.edit", (IAction)this.deleteAction);
        }
        super.fillContextMenu(iMenuManager);
    }
}

