/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.DownloadJobOutputsAction;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.UpdateJobStatusAction;
import eu.geclipse.ui.views.jobdetails.JobDetailsView;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.actions.ActionGroup;

public class JobDetailsViewActions
extends ActionGroup {
    private static final String MEMENTOKEY_SHOW_EMPTY_VALUES = "ShowEmptyValues";
    private JobDetailsView view;
    private IAction showEmptyValuesAction;
    private UpdateJobStatusAction updateJobStatusAction;
    private DownloadJobOutputsAction downloadJobOutputAction;

    public JobDetailsViewActions(JobDetailsView jobDetailsView) {
        this.view = jobDetailsView;
    }

    public void fillActionBars(IActionBars iActionBars) {
        super.fillActionBars(iActionBars);
        iActionBars.getToolBarManager().add((IAction)this.getUpdateJobStatusAction());
        iActionBars.getToolBarManager().add((IAction)this.getDownloadJobOutputAction());
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        super.fillContextMenu(iMenuManager);
        iMenuManager.add((IAction)this.getUpdateJobStatusAction());
        iMenuManager.add((IAction)this.getDownloadJobOutputAction());
        iMenuManager.add(this.getShowEmptyValuesAction());
    }

    private IAction getShowEmptyValuesAction() {
        if (this.showEmptyValuesAction == null) {
            this.showEmptyValuesAction = new Action(Messages.getString("JobDetailsViewActions.showEmptyValues"), 2){

                public void run() {
                    JobDetailsViewActions.this.getView().refresh();
                }
            };
        }
        return this.showEmptyValuesAction;
    }

    public boolean isShowEmptyEnabled() {
        return this.getShowEmptyValuesAction().isChecked();
    }

    private boolean getMementoBoolean(IMemento iMemento, String string) {
        Integer n = iMemento.getInteger(string);
        return n != null && n != 0;
    }

    public void readState(IMemento iMemento) {
        this.getShowEmptyValuesAction().setChecked(this.getMementoBoolean(iMemento, MEMENTOKEY_SHOW_EMPTY_VALUES));
    }

    public void saveState(IMemento iMemento) {
        iMemento.putInteger(MEMENTOKEY_SHOW_EMPTY_VALUES, this.isShowEmptyEnabled() ? 1 : 0);
    }

    private UpdateJobStatusAction getUpdateJobStatusAction() {
        if (this.updateJobStatusAction == null) {
            this.updateJobStatusAction = new UpdateJobStatusAction();
            this.view.getJobSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.updateJobStatusAction);
        }
        return this.updateJobStatusAction;
    }

    public void dispose() {
        if (this.updateJobStatusAction != null) {
            this.view.getJobSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.updateJobStatusAction);
            this.updateJobStatusAction = null;
        }
        if (this.downloadJobOutputAction != null) {
            this.view.getJobSelectionProvider().removeSelectionChangedListener((ISelectionChangedListener)this.downloadJobOutputAction);
            this.downloadJobOutputAction = null;
        }
        super.dispose();
    }

    JobDetailsView getView() {
        return this.view;
    }

    private DownloadJobOutputsAction getDownloadJobOutputAction() {
        if (this.downloadJobOutputAction == null) {
            this.downloadJobOutputAction = new DownloadJobOutputsAction();
            this.view.getJobSelectionProvider().addSelectionChangedListener((ISelectionChangedListener)this.downloadJobOutputAction);
        }
        return this.downloadJobOutputAction;
    }
}

