/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.ui.internal.actions.DownloadJobOutputsAction;
import eu.geclipse.ui.internal.actions.Messages;
import eu.geclipse.ui.internal.actions.ToggleUpdateJobsAction;
import eu.geclipse.ui.internal.actions.UpdateJobStatusAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchSite;
import org.eclipse.ui.actions.ActionGroup;

public class JobViewActions
extends ActionGroup {
    private ToggleUpdateJobsAction toggleJobsUpdateAction;
    private UpdateJobStatusAction updateSelectedJobStatusAction;
    private DownloadJobOutputsAction downloadOutputsAction;
    private IWorkbenchSite site;

    public JobViewActions(IWorkbenchSite iWorkbenchSite) {
        this.site = iWorkbenchSite;
        this.toggleJobsUpdateAction = new ToggleUpdateJobsAction();
        this.updateSelectedJobStatusAction = new UpdateJobStatusAction(iWorkbenchSite.getWorkbenchWindow());
        this.downloadOutputsAction = new DownloadJobOutputsAction();
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.toggleJobsUpdateAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.updateSelectedJobStatusAction);
        iSelectionProvider.addSelectionChangedListener((ISelectionChangedListener)this.downloadOutputsAction);
    }

    public void setJobsUpdateStatus(boolean bl) {
        this.toggleJobsUpdateAction.setChecked(bl);
        if (bl) {
            this.toggleJobsUpdateAction.setToolTipText(Messages.getString("ToggleJobsUpdatesAction.toggle_jobs_updates_action_active_text"));
        } else {
            this.toggleJobsUpdateAction.setToolTipText(Messages.getString("ToggleJobsUpdatesAction.toggle_jobs_updates_action_inactive_text"));
        }
    }

    public void dispose() {
        ISelectionProvider iSelectionProvider = this.site.getSelectionProvider();
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.toggleJobsUpdateAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.updateSelectedJobStatusAction);
        iSelectionProvider.removeSelectionChangedListener((ISelectionChangedListener)this.downloadOutputsAction);
    }

    public void fillActionBars(IActionBars iActionBars) {
        IToolBarManager iToolBarManager = iActionBars.getToolBarManager();
        iToolBarManager.add((IAction)this.toggleJobsUpdateAction);
    }

    public void fillContextMenu(IMenuManager iMenuManager) {
        if (this.toggleJobsUpdateAction != null) {
            iMenuManager.appendToGroup("group.new", (IAction)this.toggleJobsUpdateAction);
            if (this.updateSelectedJobStatusAction.isEnabled()) {
                iMenuManager.appendToGroup("group.build", (IAction)this.updateSelectedJobStatusAction);
            }
            super.fillContextMenu(iMenuManager);
        }
        iMenuManager.appendToGroup("group.build", (IAction)this.downloadOutputsAction);
    }
}

