/*
 * Decompiled with CFR 0.152.
 */
package eu.geclipse.ui.internal.actions;

import eu.geclipse.core.filesystem.GEclipseURI;
import eu.geclipse.core.model.IGridContainer;
import eu.geclipse.core.model.IGridElement;
import eu.geclipse.core.model.IGridProject;
import eu.geclipse.core.model.IGridStorage;
import eu.geclipse.ui.internal.Activator;
import eu.geclipse.ui.internal.actions.MountMenu;
import java.net.URI;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.Action;

public class MountAction
extends Action {
    private String accessProtocol;
    private IGridStorage[] sources;

    protected MountAction(IGridStorage[] iGridStorageArray, String string) {
        super(string);
        this.accessProtocol = string;
        this.sources = iGridStorageArray;
    }

    public void run() {
        IGridStorage[] iGridStorageArray = this.sources;
        int n = this.sources.length;
        int n2 = 0;
        while (n2 < n) {
            IGridStorage iGridStorage = iGridStorageArray[n2];
            try {
                this.createMount(iGridStorage);
            }
            catch (CoreException coreException) {
                Activator.logException(coreException);
            }
            ++n2;
        }
    }

    protected void createMount(IGridStorage iGridStorage) throws CoreException {
        IContainer iContainer;
        String string;
        IGridProject iGridProject = iGridStorage.getProject();
        IGridElement iGridElement = iGridProject.findChild(string = IGridProject.DIR_MOUNTS);
        if (iGridElement instanceof IGridContainer && (iContainer = (IContainer)iGridElement.getResource()) != null) {
            Path path = new Path(this.getMountName(iGridStorage));
            IFolder iFolder = iContainer.getFolder((IPath)path);
            URI uRI = this.findAccessToken(this.accessProtocol, iGridStorage);
            GEclipseURI gEclipseURI = new GEclipseURI(uRI);
            URI uRI2 = gEclipseURI.toMasterURI();
            iFolder.createLink(uRI2, 16, null);
        }
    }

    protected URI findAccessToken(String string, IGridStorage iGridStorage) {
        URI[] uRIArray;
        URI uRI = null;
        URI[] uRIArray2 = uRIArray = iGridStorage.getAccessTokens();
        int n = uRIArray.length;
        int n2 = 0;
        while (n2 < n) {
            URI uRI2 = uRIArray2[n2];
            if (MountMenu.getProtocol(uRI2).equalsIgnoreCase(string)) {
                uRI = uRI2;
                break;
            }
            ++n2;
        }
        return uRI;
    }

    protected String getMountName(IGridStorage iGridStorage) {
        String[] stringArray = this.accessProtocol.split(":");
        String string = String.valueOf(stringArray[0]) + '.' + iGridStorage.getName() + '.' + stringArray[1];
        return string;
    }
}

